<?php
/**
 * アップグレードFlavor画面(6)クラス
 *
 * アップグレードFlavor画面(6)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page05 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない  or 前画面のActが「page04」 and 「page05」 and 「page06」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or ( $tmp_act != 'page04' and $tmp_act != 'page05' and $tmp_act != 'page06' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // 配置対象をセットする
      // 他に配置する対象があれば、この配列に加えてください。
      // target: 対象ファイル名 / destination: 配置先のパス/パーミッション/オーナ名/グループ名） / 
      // operation: 操作の内容(copy/move/unlink/mkdir/rmdir)
      $this->filelist = array(
                                array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/index.php'
                                     , 'destination' => RISOLUTO_DOCROOT . '/index.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/common.css'
                                     , 'destination' => RISOLUTO_DOCROOT . '/css/common.css'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/zipcode.sh'
                                     , 'destination' => RISOLUTO_BATCH . 'zipcode.sh'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/zipcode_batch.php'
                                     , 'destination' => RISOLUTO_BATCH . 'zipcode_batch.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto.ini'
                                     , 'destination' => RISOLUTO_CONF . 'risoluto.ini'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto_admin.ini'
                                     , 'destination' => RISOLUTO_CONF . 'risoluto_admin.ini'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto_version'
                                     , 'destination' => RISOLUTO_CONF . 'risoluto_version'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/extlib_setup.sh'
                                     , 'destination' => RISOLUTO_EXTLIB . 'extlib_setup.sh'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto_conf.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_conf.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto_core.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_core.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto_db.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_db.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto_hooks.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_hooks.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto_log.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_log.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto_session.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_session.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/risoluto_util.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_util.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/admin_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/admin_base.inc'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/auth.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/auth.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/login.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/login.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/login.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/login.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/logout.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/logout.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/logout.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/logout.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/menu.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/menu.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/00002_admin.user.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu/00002_admin.user.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/00003_admin.site.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu/00003_admin.site.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/admin_site_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/admin_site_base.inc'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headeradd_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headeradd_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headeradd_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headeradd_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headeradd_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headeradd_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headeradd_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headeradd_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headeradd_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headeradd_entry.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headeradd_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headeradd_entry.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headerdel_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headerdel_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headerdel_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headerdel_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headerdel_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headerdel_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headerdel_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headerdel_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headerlist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headerlist.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headerlist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headerlist.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headermod_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headermod_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headermod_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headermod_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headermod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headermod_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headermod_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headermod_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headermod_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headermod_entry.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/headermod_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headermod_entry.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/sitestat_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/sitestat_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/sitestat_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/sitestat_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/sitestat_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/sitestat_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/sitestat_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/sitestat_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/sitestat_select.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/sitestat_select.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/sitestat_select.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/sitestat_select.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/upload_add.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/upload_add.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/upload_del.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/upload_del.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/uploadlist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/uploadlist.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/uploadlist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/uploadlist.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/uploadviewer.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/uploadviewer.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/admin_user_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/admin_user_base.inc'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupadd_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupadd_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupadd_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupadd_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupadd_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_entry.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupadd_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_entry.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupdel_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupdel_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupdel_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupdel_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupdel_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupdel_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupdel_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupdel_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/grouplist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/grouplist.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/grouplist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/grouplist.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupmod_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupmod_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupmod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupmod_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupmod_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_entry.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/groupmod_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_entry.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/useradd_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/useradd_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/useradd_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/useradd_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/useradd_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/useradd_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/useradd_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/useradd_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/useradd_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/useradd_entry.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/useradd_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/useradd_entry.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/userdel_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/userdel_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/userdel_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/userdel_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/userdel_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/userdel_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/userdel_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/userdel_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/userlist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/userlist.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/userlist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/userlist.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/usermod_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/usermod_complete.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/usermod_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/usermod_complete.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/usermod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/usermod_confirm.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/usermod_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/usermod_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/usermod_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/usermod_entry.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/usermod_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/usermod_entry.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/admin_footer.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'common/admin_footer.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/admin_header.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'common/admin_header.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/footer.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'common/footer.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/header.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'common/header.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/error.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'error/error.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/error.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'error/error.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/error_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . 'error/error_base.inc'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/servicestop.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'servicestop/servicestop.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/servicestop.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'servicestop/servicestop.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/servicestop_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . 'servicestop/servicestop_base.inc'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/skeleton.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'skeleton/skeleton.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/skeleton.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'skeleton/skeleton.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/skeleton_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . 'skeleton/skeleton_base.inc'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/welcome.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'welcome/welcome.php'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/welcome.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'welcome/welcome.tpl'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => true
                                     )
                             ,  array(
                                       'target'      => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/file/welcome_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . 'welcome/welcome_base.inc'
                                     , 'operation'   => 'copy'
                                     , 'pass'        => false
                                     )
                             );

      // 処理を行う
      foreach( $this->filelist as $dat )
      {
        if ( $dat[ 'pass' ] )
        {
          continue;
        } // end of if

        // 処理を呼び出す
        $tmp_errflag = $this->obj_util->fileOperator( $dat[ 'operation' ], $dat[ 'target' ], $dat[ 'destination' ] );

        // 処理結果によって、状態を変える
        if ( ! $tmp_errflag )
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'OK'
                                      );
        } // end of if
        else
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'NG'
                                      );
          $this->errStatus     = 'NG';
        } // end of else
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(5)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page05.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page05
?>
