<?php
/**
 * ユーザ情報変更内容確認画面クラス
 *
 * ユーザ情報変更内容確認画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_user_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class usermod_confirm extends admin_user_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.user」でない or 前画面のActが「usermod_entry」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.user' or ( $tmp_act != 'usermod_entry' ) )
      {
        $this->obj_util->redirectTo( 'usermod_entry', 'admin.user' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'message'         ] = null;
      $tmp_entered[ 'userid'          ] = null;
      $tmp_entered[ 'password'        ] = null;
      $tmp_entered[ 'password_retype' ] = null;
      $tmp_entered[ 'groupid'         ] = null;

      // ユーザID
      if ( isset( $_POST[ 'userid' ] ) )
      {
        $tmp_entered[ 'userid'          ] = strip_tags( trim( $_POST[ 'userid' ] ) );
      } // end of if
      // パスワード
      if ( isset( $_POST[ 'password' ] ) )
      {
        $tmp_entered[ 'password'        ] = strip_tags( trim( $_POST[ 'password' ] ) );
      } // end of if
      // パスワード（再入力）
      if ( isset( $_POST[ 'password_retype' ] ) )
      {
        $tmp_entered[ 'password_retype' ] = strip_tags( trim( $_POST[ 'password_retype' ] ) );
      } // end of if
      // グループ
      if ( isset( $_POST[ 'groupid' ] ) )
      {
        $tmp_entered[ 'groupid'         ] = strip_tags( trim( $_POST[ 'groupid' ] ) );
      } // end of if



      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();



      //------------------------------------------------------------------------
      // 表示の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `user`.`user_name`     -- ユーザ名
                   , `groups`.`group_name`  -- グループ名
                FROM `risoluto_t_user`  user
                   , `risoluto_m_group` groups
               WHERE `user`.`user_id`    = ?
                 AND `groups`.`group_id` = ?
                 AND `user`.`status`     = 1
                 AND `groups`.`status`   = 1

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'userid'  ]
                      , $tmp_entered[ 'groupid' ]
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'userinfo get Failure' );
          return false;
        } // end of if
        // 成功したなら、変数に取得した値を入れる
        else
        {
          $tmp_entered[ 'username'  ] = $tmp_result[ 'user_name'  ];
          $tmp_entered[ 'groupname' ] = $tmp_result[ 'group_name' ];
        } // end of else

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // ユーザID（ユーザIDが不正）
      if ( $tmp_entered[ 'userid' ] == null or ! is_numeric( $tmp_entered[ 'userid' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_username';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'usermod_entry', 'admin.user' );
        return false;
      } // end of if

      // ユーザ名（ユーザ名が不正）
      if ( ! preg_match( $this->obj_adminconf->get( 'COMMON', 'valid_username' ), $tmp_entered[ 'username' ] ) )
      {
        // 例外を投げる
        throw new Exception( 'Invalid username' );
        return false;
      } // end of if

      // パスワード（ユーザ名と同じ）
      if ( $tmp_entered[ 'password' ] == $tmp_entered[ 'username' ] or $tmp_entered[ 'password_retype' ] == $tmp_entered[ 'username' ] )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'notmatch';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'usermod_entry', 'admin.user' );
        return false;
      } // end of if

      // パスワード（入力が空）
      if ( empty( $tmp_entered[ 'password' ] ) or empty( $tmp_entered[ 'password_retype' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'notmatch';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'usermod_entry', 'admin.user' );
        return false;
      } // end of if

      // パスワード（入力が一致しない）
      if ( $tmp_entered[ 'password' ] != $tmp_entered[ 'password_retype' ] )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'notmatch';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'usermod_entry', 'admin.user' );
        return false;
      } // end of if

      // グループID（数値ではない）
      if ( ! is_numeric( $tmp_entered[ 'groupid' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_groupid';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'usermod_entry', 'admin.user' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 特に問題がなければ、画面表示用にクラス変数とセッションに値をセットする
      //------------------------------------------------------------------------
      $this->gotDat = $tmp_entered;
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',            $this->obj_util->getHeader() );

      $this->smarty->assign ( 'entered_username',  $this->gotDat[ 'username'  ] );
      $this->smarty->assign ( 'entered_groupname', $this->gotDat[ 'groupname' ] );

      // 表示
      $this->smarty->display( 'usermod_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:usermod_confirm

?>
