<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class UserDetailTableVerify{
	var $valid = true;

	function UserDetailTableVerify(){
	}
	function verify($tableObject){
		$this->verifyUserId($tableObject->getUserId());
		$this->verifyUrl($tableObject->getUrl());
		$this->verifyComment($tableObject->getComment());
		$this->verifyRegistDate($tableObject->getRegistDate());
		$this->verifyLastLoginDate($tableObject->getLastLoginDate());
		$this->verifyTags($tableObject->getTags());
		$this->verifyBookmarkCount($tableObject->getBookmarkCount());
		return $this->valid;	
	}
	function verifyUserId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedUserId())),$this->_validName("userId"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedUserId())),$this->_validName("userId"));
		}
		unset($value);
	}
	function verifyUrl($value){
		if(!empty($value) && !Validate::isString($value,0,2000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedUrl(),2000)),$this->_validName("url"));
		}
		unset($value);
	}
	function verifyComment($value){
		if(!empty($value) && !Validate::isString($value,0,6000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedComment(),6000)),$this->_validName("comment"));
		}
		unset($value);
	}
	function verifyRegistDate($value){
		if(!empty($value) && !Validate::isDate(date("Y",$value),date("m",$value),date("d",$value))){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedRegistDate())),$this->_validName("registDate"));
		}
		unset($value);
	}
	function verifyLastLoginDate($value){
		if(!empty($value) && !Validate::isTimestamp($value)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedLastLoginDate())),$this->_validName("lastLoginDate"));
		}
		unset($value);
	}
	function verifyTags($value){
		if(!empty($value) && !Validate::isString($value,0,6000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedTags(),6000)),$this->_validName("tags"));
		}
		unset($value);
	}
	function verifyBookmarkCount($value){
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedBookmarkCount())),$this->_validName("bookmarkCount"));
		}
		unset($value);
	}

	function namedUserId(){
		return Message::_("USER_ID");
	}
	function namedUrl(){
		return Message::_("URL");
	}
	function namedComment(){
		return Message::_("COMMENT");
	}
	function namedRegistDate(){
		return Message::_("REGIST_DATE");
	}
	function namedLastLoginDate(){
		return Message::_("LAST_LOGIN_DATE");
	}
	function namedTags(){
		return Message::_("TAGS");
	}
	function namedBookmarkCount(){
		return Message::_("BOOKMARK_COUNT");
	}
	function _validName($name){
		$this->valid = false;
		return "UserDetail_".$name;
	}
}

?>