<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionGoesby");
Rhaco::importLibrary("data.verify.PageVerify");
Rhaco::importLibrary("data.Bookmark");
Rhaco::importLibrary("data.PageFeed");
class PageTable extends TableObjectBase{
	var $id;
	var $title;
	var $url;
	var $updateDate;
	var $registDate;
	var $description;
	var $count;
	var $tags;
	function PageTable(
		$id=null
	){
		$this->id = 0;
		$this->title = null;
		$this->url = null;
		$this->updateDate = null;
		$this->registDate = time();
		$this->description = null;
		$this->count = 0;
		$this->tags = null;
		$this->setId($id);
	}
	function setId($value){
		$this->id = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getId(){
		return $this->id;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setUrl($value){
		$this->url = $value;
	}
	function getUrl(){
		return $this->url;
	}
	function setUpdateDate($value){
		if(!empty($value) && !is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->updateDate = $value;
	}
	function getUpdateDate(){
		return $this->updateDate;
	}
	function formatUpdateDate($format="Y/m/d H:i:s"){
		return date($format,$this->updateDate);
	}
	function setRegistDate($value){
		if(!empty($value) && !is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->registDate = $value;
	}
	function getRegistDate(){
		return $this->registDate;
	}
	function formatRegistDate($format="Y/m/d H:i:s"){
		return date($format,$this->registDate);
	}
	function setDescription($value){
		$this->description = $value;
	}
	function getDescription(){
		return $this->description;
	}
	function setCount($value){
		$this->count = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getCount(){
		return $this->count;
	}
	function setTags($value){
		$this->tags = $value;
	}
	function getTags(){
		return $this->tags;
	}
	function columnId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE","PAGE"),"ID","Id","SERIAL");
	}
	function columnTitle(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE","PAGE"),"TITLE","Title","STRING");
	}
	function columnUrl(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE","PAGE"),"URL","Url","STRING");
	}
	function columnUpdateDate(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE","PAGE"),"UPDATE_DATE","UpdateDate","TIMESTAMP");
	}
	function columnRegistDate(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE","PAGE"),"REGIST_DATE","RegistDate","TIMESTAMP");
	}
	function columnDescription(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE","PAGE"),"DESCRIPTION","Description","STRING");
	}
	function columnCount(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE","PAGE"),"COUNT","Count","INTEGER");
	}
	function columnTags(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE","PAGE"),"TAGS","Tags","STRING");
	}
	function dependColumnId(){
		return array(
				array(new Bookmark(),new PageFeed(),),
				array(Bookmark::columnPageId(),PageFeed::columnPageId(),),
				$this->getId());
	}
	function related($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		return $criteria;
	}
	function unique(){
		return array(
			);
	}
	function verifyObject(){
		return new PageVerify();
	}
	function connection(){
		return new DbConnectionGoesby();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
			list($objList,$columnList,$value) = $this->dependColumnId();
			foreach($objList as $key => $obj){
				$dbUtil->delete($obj,new Criteria($columnList[$key],$value));
			}
		}
		unset($dbUtil,$criteria);
	}
	function verify(){
		$verify = new PageVerify();
		return $verify->verify($this);
	}
	function columns(){
		return array(Page::columnId(),Page::columnTitle(),Page::columnUrl(),Page::columnUpdateDate(),Page::columnRegistDate(),Page::columnDescription(),Page::columnCount(),Page::columnTags(),);
	}
	function primaryKey(){
		return array(Page::columnId(),);
	}
}
?>