<?php
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.DuplicateException");
Rhaco::import("lang.StringUtil");
Rhaco::import("network.http.RequestLogin");
Rhaco::import("network.http.Header");
Rhaco::importLibrary("data.UserLogin");
Rhaco::importLibrary("data.UserDetail");
Rhaco::importLibrary("data.Memory");
Rhaco::importLibrary("DbUtilGoesby");

class UserController{
	function isLoginUser($loginuUerDetail,$login){
		if(Variable::isClassType(UserDetail,$loginuUerDetail)){
			return ($loginuUerDetail->getLogin() == $login);
		}
		return false;
	}
	function add($login,$password,$dbUtil=null){
		$dbUtil	= DbUtilGoesby::instance($dbUtil);
		
		if($dbUtil->get(new UserLogin(),new Criteria(UserLogin::columnLogin(),$login))){
			ExceptionTrigger::raise(new DuplicateException(UserLoginVerify::namedLogin()));
			return false;
		}
		if(Variable::isClassType(UserLogin,$dbUtil->insert(Variable::hashConvObject(array("login"=>$login,"encodePassword"=>$password),new UserLogin())))){
			$dbUtil->commit();
			return true;
		}
		$dbUtil->rollback();
		return false;
	}
	function update($loginUserDetail,$userDetail,$password="",$dbUtil=null){
		if(Variable::isClassType(UserDetail,$loginUserDetail)){
			$dbUtil			= DbUtilGoesby::instance($dbUtil);
			$baseUserDetail	= $dbUtil->get(new UserDetail(),new Criteria(UserDetail::columnUserId(),$loginUserDetail->getUserId()));

			if(Variable::isClassType(UserDetail,$baseUserDetail)){
				if($dbUtil->update(Variable::hashConvObject(array("bookmarkCount"=>sizeof($bookmarkList),"comment"=>$userDetail->getComment(),"url"=>$userDetail->getUrl()),$baseUserDetail))){
					if(!empty($password)){
						$user = $dbUtil->get(new UserLogin($loginUserDetail->getUserId()));
	
						if(Variable::isClassType(UserLogin,$user)){
							$dbUtil->update(Variable::hashConvObject(array("encodePassword"=>$password),$user));
						}
					}
					$dbUtil->commit();
					return true;
				}
			}
		}
		$dbUtil->rollback();
		return false;
	}
	function get($login,$dbUtil=null){
		$dbUtil		= DbUtilGoesby::instance($dbUtil);
		$criteria	= new Criteria(UserLogin::columnLogin(),$login);
		$criteria->addJoin(UserLogin::columnId(),UserDetail::columnUserId());				

		list(list($user),list($userDetail)) = $dbUtil->select(array(new UserLogin(),new UserDetail()),$criteria);

		if(!Variable::isClassType(UserLogin,$user)){
			return new UserDetail();
		}
		$userDetail->setUser($user);
		return $userDetail;
	}
	function addMemory($loginUserDetail,$memory,$dbUtil=null){
		if(Variable::isClassType(UserDetail,$loginUserDetail) && Variable::isClassType(Memory,$memory)){
			$dbUtil	= DbUtilGoesby::instance($dbUtil);
			$memory->setUserId($loginUserDetail->getUserId());
			$memory->setTitle(StringUtil::encoding($memory->getTitle(),StringUtil::getEncodeTypeUTF8()));
			return $dbUtil->insert($memory);
		}
		return false;
	}
	function memoryList($login,$dbUtil=null){
		$dbUtil		= DbUtilGoesby::instance($dbUtil);
		$criteria	= new Criteria(UserLogin::columnLogin(),$login);
		$criteria->add(Memory::columnUserId(),UserLogin::columnId());
		$criteria->addOrder(Memory::columnRegistDate());
		return $dbUtil->select(new Memory(),$criteria);
	}
	function redirect($userDetail){
		if(Variable::isClassType(UserDetail,$userDetail)){
			Header::redirect(Rhaco::url(sprintf("bookmarkList.php/%s",$userDetail->getLogin())));
		}
	}
}
?>