<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.feed.Rss10");
Rhaco::import("network.http.Http");
Rhaco::import("io.FileUtil");

class Rss10Test extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testSet(){
		$feed = new Rss10();
		$src = Http::body(Rhaco::url("feed.php?mode=rss10"));

		$feed->set($src);

		$this->_assert($feed);
	}
	function testGet(){
		$feed = new Rss10();
		$src = Http::body(Rhaco::url("feed.php?mode=rss10"));

		$feed->set($src);
		$fileUtil = new FileUtil();
//		$fileUtil->write(Rhaco::templatepath("tag/feed/rss10Result.xml"),$feed->get());
		$this->assertEquals($fileUtil->read(Rhaco::templatepath("tag/feed/rss10Result.xml")),$feed->get());
		
		$newfeed = new Rss10();
		$newfeed->set($feed->get());
		$this->_assert($newfeed);
	}
	function _assert($feed){
		$this->assertTrue(Variable::isClassType(RssChannel10,$feed->getChannel()));		
		
		$this->assertEquals(1,sizeof($feed->getItemList()));
		foreach($feed->getItemList() as $item){
			$this->assertTrue(Variable::isClassType(RssItem,$item));
			$this->assertTrue(strlen($item->getTitle()) > 0);
			$this->assertTrue(strlen($item->getLink()) > 0);
			$this->assertTrue(strlen($item->getDescription()) > 0);
			
			$dc = $item->getDc();
			$this->assertEquals("技術",$dc->getSubject());
			$this->assertEquals("2006-03-31T21:55:35+09:00",$dc->getDate());
			$this->assertEquals("kenzii",$dc->getCreator());
		}
	}
}
?>