<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.feed.Rss09");
Rhaco::import("network.http.Http");
Rhaco::import("io.FileUtil");

class Rss09Test extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testSet(){
		$feed = new Rss09();
		$src = Http::body(Rhaco::url("feed.php?mode=rss091"));

		$feed->set($src);

		$this->_assert($feed);
	}
	function testGet(){
		$feed = new Rss09();
		$src = Http::body(Rhaco::url("feed.php?mode=rss091"));

		$feed->set($src);
		$fileUtil = new FileUtil();
//		$fileUtil->write(Rhaco::templatepath("tag/feed/rss09Result.xml"),$feed->get());
		$this->assertEquals($fileUtil->read(Rhaco::templatepath("tag/feed/rss09Result.xml")),$feed->get());
		
		$newfeed = new Rss09();
		$newfeed->set($feed->get());
		$this->_assert($newfeed);
	}
	function _assert($feed){
		$this->assertEquals("0.91",$feed->getVersion());
		$this->assertTrue(Variable::isClassType(RssChannel09,$feed->getChannel()));		

		foreach($feed->getItemList() as $item){
			$this->assertTrue(Variable::isClassType(RssItem,$item));
			$this->assertTrue(strlen($item->getTitle()) > 0);
			$this->assertTrue(strlen($item->getLink()) > 0);
		}
	}
}
?>