/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.Validator;
import com.sdicons.json.validator.impl.ValidatorUtil;
import com.sdicons.json.validator.impl.predicates.Predicate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Or
extends Predicate {
    private List<Validator> rules = new LinkedList<Validator>();

    public Or(String aName, JSONObject aRule, HashMap<String, Validator> aRuleset) throws ValidationException {
        super(aName, aRule);
        ValidatorUtil.requiresAttribute(aRule, "rules", JSONArray.class);
        List<JSONValue> lRules = ((JSONArray)aRule.get("rules")).getValue();
        Iterator<JSONValue> i$ = lRules.iterator();
        while (i$.hasNext()) {
            JSONValue lRule;
            JSONValue lVal = lRule = i$.next();
            Validator lValidator = ValidatorUtil.buildValidator(lVal, aRuleset);
            this.rules.add(lValidator);
        }
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        for (Validator rule1 : this.rules) {
            try {
                Validator lValidator = rule1;
                lValidator.validate(aValue);
                return;
            }
            catch (ValidationException e) {
            }
        }
        this.fail("All or rules failed.", aValue);
    }
}

