/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.Validator;
import com.sdicons.json.validator.impl.ValidatorUtil;
import com.sdicons.json.validator.impl.predicates.CustomValidator;
import com.sdicons.json.validator.impl.predicates.Predicate;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomPredicate
extends Predicate {
    private Validator validator;

    public CustomPredicate(String aName, JSONObject aRule, HashMap<String, Validator> aRuleset) throws ValidationException {
        super(aName, aRule);
        ValidatorUtil.requiresAttribute(aRule, "class", JSONString.class);
        String lClassname = ((JSONString)aRule.get("class")).getValue();
        try {
            Class<?> lCustomClass = Class.forName(lClassname);
            if (!CustomValidator.class.isAssignableFrom(lCustomClass)) {
                throw new ValidationException("The custom class is not derived from CustomValidator: " + lClassname, aRule, aName);
            }
            Constructor<?> lConstructor = lCustomClass.getConstructor(String.class, JSONObject.class, HashMap.class);
            this.validator = (Validator)lConstructor.newInstance(aName, aRule, aRuleset);
        }
        catch (ClassNotFoundException e) {
            throw new ValidationException("The custom class was not found: " + lClassname, aRule, aName);
        }
        catch (NoSuchMethodException e) {
            throw new ValidationException("Constructor method not found on custom class: " + lClassname, aRule, aName);
        }
        catch (InstantiationException e) {
            throw new ValidationException("Error during construction of validtor of class: " + lClassname, aRule, aName);
        }
        catch (IllegalAccessException e) {
            throw new ValidationException("Access rights problem during construction of validator of class: " + lClassname, aRule, aName);
        }
        catch (InvocationTargetException e) {
            throw new ValidationException("Access rights problem during construction of validator of class: " + lClassname, aRule, aName);
        }
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        this.validator.validate(aValue);
    }
}

