/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.layout;

import java.util.Hashtable;
import java.util.Map;
import org.nishiohirokazu.graph.IEdge;
import org.nishiohirokazu.graph.IVertex;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.UtilCast;
import org.nishiohirokazu.layout.IMassPoint;
import org.nishiohirokazu.layout.PhysicalLaw;
import org.nishiohirokazu.vector.Vec;

public class PL_SpringEdge
extends PhysicalLaw {
    public double defaultNormalLength = 1.0;
    public double defaultSpringStrength = 0.1;
    private Map<IEdge, Double> normalLength = new Hashtable<IEdge, Double>();
    private Map<IEdge, Double> springStrength = new Hashtable<IEdge, Double>();
    private String targetName;

    public PL_SpringEdge() {
        this.targetName = "Edge";
    }

    public PL_SpringEdge(String targetName) {
        this.targetName = targetName;
    }

    private double getSpringStrength(IEdge e) {
        if (this.springStrength.containsKey(e)) {
            return this.springStrength.get(e);
        }
        return this.defaultSpringStrength;
    }

    private double getNormalLength(IEdge e) {
        if (this.normalLength.containsKey(e)) {
            return this.normalLength.get(e);
        }
        return this.defaultNormalLength;
    }

    public boolean apply(int iter) {
        Hashtable target = Mediator.getInstance().getNamedDict(this.targetName);
        if (iter == 0) {
            for (IEdge e : target.values()) {
                IVertex v1 = e.getV1();
                IVertex v2 = e.getV2();
                if (v1 == null || v2 == null) continue;
                IMassPoint mv1 = (IMassPoint)((Object)v1);
                IMassPoint mv2 = (IMassPoint)((Object)v2);
                double[] dir = Vec.sub(mv2.getPosition(), mv1.getPosition());
                double dist = Vec.mag(dir);
                double[] ndir = Vec.normalize(dir);
                double k = this.getSpringStrength(e);
                double length = this.getNormalLength(e);
                double power = (length - dist) * k;
                double[] force = Vec.scale(ndir, power);
                mv2.getDVelList().add(force);
                mv1.getDVelList().add(Vec.inv(force));
            }
        }
        return true;
    }

    public void setDefaultNormalLength(Object o) {
        this.defaultNormalLength = UtilCast.o2double(o);
    }

    public void setDefaultSpringStrength(Object o) {
        this.defaultSpringStrength = UtilCast.o2double(o);
    }

    public Hashtable getParams() {
        Hashtable result = super.getParams();
        result.put("defaultNormalLength", this.defaultNormalLength);
        result.put("defaultSpringStrength", this.defaultSpringStrength);
        return result;
    }

    public void setTargetName(Object o) {
        this.targetName = o.toString();
    }

    public void putNormalLength(String name, Object value) {
        this.normalLength.put((IEdge)Mediator.getInstance().getObject(name), UtilCast.o2double(value));
    }

    public void putNormalLength(IEdge o, Object value) {
        this.normalLength.put(o, UtilCast.o2double(value));
    }

    public void removeNormalLength(String name) {
        this.normalLength.remove(Mediator.getInstance().getObject(name));
    }

    public void setNormalLength(Object o) {
        this.normalLength = new Hashtable<IEdge, Double>();
        Map map = UtilCast.maplike2map(o);
        Mediator med = Mediator.getInstance();
        for (Object key : map.keySet()) {
            this.normalLength.put(med.getEdge(key.toString()), UtilCast.o2double(map.get(key)));
        }
    }

    public void putSpringStrength(String name, Object value) {
        this.springStrength.put((IEdge)Mediator.getInstance().getObject(name), UtilCast.o2double(value));
    }

    public void putSpringStrength(IEdge o, Object value) {
        this.springStrength.put(o, UtilCast.o2double(value));
    }

    public void removeSpringStrength(String name) {
        this.springStrength.remove(Mediator.getInstance().getObject(name));
    }

    public void setSpringStrength(Object o) {
        this.springStrength = new Hashtable<IEdge, Double>();
        Map map = UtilCast.maplike2map(o);
        Mediator med = Mediator.getInstance();
        for (Object key : map.keySet()) {
            this.springStrength.put(med.getEdge(key.toString()), UtilCast.o2double(map.get(key)));
        }
    }
}

