/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.layout;

import java.util.Hashtable;
import java.util.List;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.UtilCast;
import org.nishiohirokazu.layout.MassPoint;
import org.nishiohirokazu.layout.PhysicalLaw;
import org.nishiohirokazu.swt.ViewportTransformer;
import org.nishiohirokazu.vector.Vec;

public class PL_RigidBody
extends PhysicalLaw {
    private double[][] dirList;
    private MassPoint[] vertexList;
    private int tolerance = 7;
    private int N;
    private double[] magList;
    private double[] ax = new double[]{1.0, 0.0};
    private double[] ay = new double[]{0.0, 1.0};
    private double avel = 0.0;
    private double dumperK = 0.9;
    private double moment = 10.0;

    public PL_RigidBody() {
    }

    public PL_RigidBody(List target) {
        this.initialize(target);
    }

    public void setTarget(Object target) {
        this.initialize(UtilCast.o2list(target));
    }

    private void initialize(List target) {
        MassPoint v;
        int i;
        this.N = target.size();
        this.vertexList = new MassPoint[this.N];
        if (target.get(0) instanceof String) {
            Mediator med = Mediator.getInstance();
            i = 0;
            while (i < this.N) {
                this.vertexList[i] = (MassPoint)med.getVertex((String)target.get(i));
                ++i;
            }
        } else {
            target.toArray(this.vertexList);
        }
        double[] gp = new double[]{0.0, 0.0};
        i = 0;
        while (i < this.N) {
            v = this.vertexList[i];
            Vec.addD(gp, v.getPosition());
            ++i;
        }
        gp = Vec.scale(gp, 1.0 / (double)this.N);
        this.dirList = new double[this.N][];
        this.magList = new double[this.N];
        i = 0;
        while (i < this.N) {
            v = this.vertexList[i];
            double[] diff = Vec.sub(v.getPosition(), gp);
            this.dirList[i] = Vec.normalize(diff);
            this.magList[i] = Vec.mag(diff);
            ++i;
        }
    }

    public boolean apply(int iter) {
        boolean isSatisfied = true;
        if (iter == 0) {
            return false;
        }
        if (iter < this.tolerance) {
            double[] gp = new double[]{0.0, 0.0};
            int i = 0;
            while (i < this.N) {
                MassPoint v = this.vertexList[i];
                Vec.addD(gp, v.getPosition());
                ++i;
            }
            gp = Vec.scale(gp, 1.0 / (double)this.N);
            this.avel *= this.dumperK;
            double rot = 0.0;
            int i2 = 0;
            while (i2 < this.N) {
                MassPoint v = this.vertexList[i2];
                double[] diff = Vec.sub(v.getPosition(), gp);
                double[] dir = Vec.normalize(diff);
                double[] oldDir = this.dirList[i2];
                double[] trueDir = Vec.add(Vec.scale(this.ax, oldDir[0]), Vec.scale(this.ay, oldDir[1]));
                rot += (trueDir[0] * dir[1] - trueDir[1] * dir[0]) * this.magList[i2];
                ++i2;
            }
            this.avel += rot / this.moment;
            double[] nax = Vec.normalize(Vec.add(this.ax, Vec.scale(this.ay, this.avel)));
            this.ay = Vec.normalize(Vec.add(this.ay, Vec.scale(this.ax, -this.avel)));
            this.ax = nax;
            ViewportTransformer vp = Infrastructure.getViewportTransformer();
            int i3 = 0;
            while (i3 < this.N) {
                MassPoint v = this.vertexList[i3];
                double[] oldDiff = this.dirList[i3];
                double[] truePos = Vec.add(gp, Vec.scale(Vec.add(Vec.scale(this.ax, oldDiff[0]), Vec.scale(this.ay, oldDiff[1])), this.magList[i3]));
                double[] updateVec = Vec.sub(truePos, v.getPosition());
                if (Vec.mag(vp.scaling(updateVec)) > 0.1) {
                    isSatisfied = false;
                    v.getDVelList().add(updateVec);
                }
                ++i3;
            }
        }
        return isSatisfied;
    }

    public Hashtable getParams() {
        Hashtable result = super.getParams();
        return result;
    }
}

