/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.nishiohirokazu.graph.RenderableEdge;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Mediator;

public class Selection {
    private List vertexList = new Vector();
    private Vector edgeList = new Vector();
    private Vector marginalList = new Vector();
    private Mediator med;

    public Selection(Mediator mediator) {
        this.med = mediator;
    }

    public void set(List l) {
        RenderableVertex v;
        int i = 0;
        while (i < this.vertexList.size()) {
            v = (RenderableVertex)this.vertexList.get(i);
            v.selected = false;
            ++i;
        }
        this.vertexList = l;
        i = 0;
        while (i < this.vertexList.size()) {
            v = (RenderableVertex)this.vertexList.get(i);
            v.selected = true;
            ++i;
        }
        this.edgeList = new Vector();
        this.marginalList = new Vector();
        Hashtable allEdges = this.med.getEdgeDict();
        for (RenderableEdge e : allEdges.values()) {
            RenderableVertex v1 = (RenderableVertex)e.getV1();
            RenderableVertex v2 = (RenderableVertex)e.getV2();
            if (v1.selected && v2.selected) {
                this.edgeList.add(e);
                e.selected = true;
                continue;
            }
            if (v1.selected || v2.selected) {
                this.marginalList.add(e);
                e.selected = false;
                continue;
            }
            e.selected = false;
        }
    }

    public List getVertex() {
        return this.vertexList;
    }

    public Vector getEdges() {
        return this.edgeList;
    }

    public Vector getMarginalEdges() {
        return this.marginalList;
    }
}

