/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import org.nishiohirokazu.awt.ColorHolder;

public class DoubleBufferer {
    private Image bgImage;
    int width;
    int height;
    public Canvas canvas;
    private Graphics gc;
    private Graphics bg;
    public Color bgcolor = ColorHolder.WHITE;
    public Color fgcolor = ColorHolder.BLACK;

    public DoubleBufferer(Canvas canvas) {
        this.setCanvas(canvas);
    }

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
        canvas.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                DoubleBufferer.this.initBackgroundImage();
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        this.gc = canvas.getGraphics();
    }

    public void initBackgroundImage() {
        if (this.canvas.getSize().width != 0) {
            this.bgImage = this.canvas.createImage(this.canvas.getWidth(), this.canvas.getHeight());
            this.bg = this.bgImage.getGraphics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw() {
        if (this.bgImage == null) {
            this.initBackgroundImage();
        }
        Graphics graphics = this.gc;
        synchronized (graphics) {
            this.gc.drawImage(this.bgImage, 0, 0, this.canvas);
        }
    }

    public void drawOnBackground() {
    }

    public Graphics getBG() {
        return this.bg;
    }

    public Graphics getGC() {
        return this.gc;
    }

    public void clearBG() {
        if (this.bg != null) {
            this.bg.setColor(this.bgcolor);
            this.bg.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
            this.bg.setColor(this.fgcolor);
        }
    }
}

