/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.python;

import com.artenum.jyconsole.io.MultiStreamWriter;
import com.artenum.jyconsole.io.SimpleSingleStream;
import com.artenum.jyconsole.io.SingleStream;
import org.python.core.PyObject;
import org.python.util.InteractiveInterpreter;

public class JInteractiveInterpreter
extends InteractiveInterpreter {
    private static MultiStreamWriter mStdOut;
    private static MultiStreamWriter mStdErr;

    public JInteractiveInterpreter() {
        this(true);
    }

    public JInteractiveInterpreter(boolean bl) {
        this.initOutputStream(bl);
    }

    public JInteractiveInterpreter(PyObject pyObject) {
        this(pyObject, true);
    }

    public JInteractiveInterpreter(PyObject pyObject, boolean bl) {
        super(pyObject);
        this.initOutputStream(bl);
    }

    private void initOutputStream(boolean bl) {
        if (mStdOut == null) {
            mStdOut = new MultiStreamWriter();
            this.setOut(mStdOut);
            if (bl) {
                this.addOut(new SimpleSingleStream(System.out, true));
            }
        }
        if (mStdErr == null) {
            mStdErr = new MultiStreamWriter();
            this.setErr(mStdErr);
            if (bl) {
                this.addErr(new SimpleSingleStream(System.err, true));
            }
        }
    }

    public void addOut(SingleStream singleStream) {
        mStdOut.addSingleStream(singleStream);
    }

    public void removeOut(SingleStream singleStream) {
        mStdOut.removeSingleStream(singleStream);
    }

    public void addErr(SingleStream singleStream) {
        mStdErr.addSingleStream(singleStream);
    }

    public void removeErr(SingleStream singleStream) {
        mStdErr.removeSingleStream(singleStream);
    }
}

