/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.jarRunner;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.nishiohirokazu.jarRunner.Splash;

public class JarRunner {
    private static Splash splash;
    private static JTextArea errorText;

    public static void main(String[] args) {
        JarRunner.makeSplash();
        String[] command = new String[args.length + 3];
        command[0] = "java";
        command[1] = "-jar";
        command[2] = "grinedit-app-alpha0.20.jar";
        int i = 0;
        while (i < args.length) {
            command[i + 3] = args[i];
            ++i;
        }
        try {
            Process p = new ProcessBuilder(command).start();
            while (true) {
                JarRunner.relay(p.getInputStream(), false);
                JarRunner.relay(p.getErrorStream(), true);
                Thread.sleep(100L);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void makeSplash() {
        splash = new Splash();
    }

    private static void relay(InputStream stream, boolean isErr) {
        try {
            int a = stream.available();
            if (a > 0) {
                byte[] data = new byte[a];
                stream.read(data);
                JarRunner.addOutput(new String(data), isErr);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addOutput(String string, boolean isErr) {
        String[] stringArray = string.split("\n");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String line = stringArray[n];
            System.out.println("{" + line + "}");
            if (string.indexOf("processing new jar") != -1) {
                Pattern pattern = Pattern.compile(".*processing new jar, '.*?([^\\\\]+\\.jar)'.*$", 32);
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    splash.updateStatus("processing new jar: " + matcher.group(1));
                }
            } else if (string.indexOf("CLOSE_SPLASH") != -1) {
                System.exit(0);
            } else if (!isErr) {
                splash.updateStatus(line);
            } else {
                JarRunner.makeErrorDialog().append(String.valueOf(line) + "\n");
            }
            ++n;
        }
    }

    private static JTextArea makeErrorDialog() {
        if (errorText == null) {
            JFrame f = new JFrame("Error");
            errorText = new JTextArea();
            f.getContentPane().add(new JScrollPane(errorText));
            f.setSize(600, 200);
            f.setLocationRelativeTo(null);
            f.setDefaultCloseOperation(3);
            f.setVisible(true);
        }
        return errorText;
    }
}

