-- 固定砲台の AI
-- Satofumi KAMIMURA
-- $Id: artillery_ai.lua 321 2009-03-20 06:43:16Z satofumi $


-- !!! 属性値で個々に指定できるようにする。ArtilleryControl の関数にすればよい
local shot_threshold = 0.996


-- state: 最初の状態
Artillery_startup = {}

Artillery_startup["Enter"] =
   function(unit)
   end

Artillery_startup["Execute"] =
   function(unit)
      unit:stateMachine():changeState(Artillery_random)
      --unit:stateMachine():changeState(Artillery_none)
   end

Artillery_startup["Exit"] =
   function(unit)
   end


-- state: 何もしない
Artillery_none = {}

Artillery_none["Enter"] =
   function(unit)
   end

Artillery_none["Execute"] =
   function(unit)
   end

Artillery_none["Exit"] =
   function(unit)
   end


-- state: まっすぐ弾を発射
Artillery_straight = {}

Artillery_straight["Enter"] =
   function(unit)
   end

Artillery_straight["Execute"] =
   function(unit)
      if math.random() > shot_threshold then
         local direction = unit:degree()
         unit:fire(direction)
      end
   end

Artillery_straight["Exit"] =
   function(unit)
   end


-- state: ランダム方向に弾を発射
Artillery_random = {}

Artillery_random["Enter"] =
   function(unit)
   end

Artillery_random["Execute"] =
   function(unit)

      if math.random() > shot_threshold then
         local direction = unit:degree() + (140.0 * (math.random() - 0.5))
         unit:fire(deg(direction))
      end
   end

Artillery_random["Exit"] =
   function(unit)
   end


-- state: 目標位置に弾を発射
Artillery_aim = {}

Artillery_aim["Enter"] =
   function(unit)
   end

Artillery_aim["Execute"] =
   function(unit)
      if math.random() > shot_threshold then
         local target = unit:nearestEnemy()
         local direction = math.atan2(target.y, target.x) * 180.0 / math.pi
         unit:fire(deg(direction))
      end
   end

Artillery_aim["Exit"] =
   function(unit)
   end


-- state: 目標の移動速度を考慮して弾を発射
Artillery_aim_careful = {}

Artillery_aim_careful["Enter"] =
   function(unit)
   end

Artillery_aim_careful["Execute"] =
   function(unit)

      -- 前回と今回のユニット位置から、速度を推定する
      -- !!!

      if math.random() > shot_threshold then
         -- 現在位置、速度、距離、弾速から、発射角度を導出する
         -- !!!
         -- !!! 仮実装
         local direction = unit:degree()
         unit:fire(direction)
      end
   end

Artillery_aim_careful["Exit"] =
   function(unit)
   end
