/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.fontencodingpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class FontEncodingView {
    private JPanel panel;

    FontEncodingView(Object[][] tableData, Map<String, String> headerAttributes, String[] columnNames, double[] yBounds) {
        this.createView(this.getHeaderPanel(headerAttributes), this.getTable(tableData, columnNames, yBounds));
    }

    private void createView(JPanel headerPanel, JTable table) {
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setPreferredSize(new Dimension(300, 500));
        JScrollPane scrollPane = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        scrollPane.setAlignmentX(0.0f);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.05;
        gbc.fill = 2;
        gbc.anchor = 19;
        this.panel.add((Component)headerPanel, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.9;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 1792;
        this.panel.add((Component)scrollPane, gbc);
    }

    private JTable getTable(Object[][] tableData, String[] columnNames, double[] yBounds) {
        JTable table = new JTable(tableData, columnNames);
        table.setRowHeight(40);
        table.setDefaultRenderer(Object.class, new GlyphCellRenderer(yBounds));
        return table;
    }

    private JPanel getHeaderPanel(Map<String, String> attributes) {
        JPanel headerPanel = new JPanel(new GridBagLayout());
        if (attributes != null) {
            Iterator<String> keys = attributes.keySet().iterator();
            int row = 0;
            while (keys.hasNext()) {
                String key = keys.next();
                JLabel encodingNameLabel = new JLabel(key + ": " + attributes.get(key));
                encodingNameLabel.setFont(new Font("Monospaced", 1, 17));
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = row++;
                gbc.weighty = 0.1;
                gbc.anchor = 21;
                headerPanel.add((Component)encodingNameLabel, gbc);
            }
        }
        return headerPanel;
    }

    JPanel getPanel() {
        return this.panel;
    }

    private static final class GlyphCellRenderer
    implements TableCellRenderer {
        private final double[] yBounds;

        private GlyphCellRenderer(double[] yBounds) {
            this.yBounds = yBounds;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object o, boolean b, boolean b1, int row, int col) {
            if (o instanceof GeneralPath) {
                GeneralPath path = (GeneralPath)o;
                Rectangle2D bounds2D = path.getBounds2D();
                if (bounds2D.isEmpty()) {
                    JLabel label = new JLabel("None", 0);
                    label.setFont(new Font("SansSerif", 0, 25));
                    label.setForeground(Color.RED);
                    return label;
                }
                Rectangle cellRect = jTable.getCellRect(row, col, false);
                BufferedImage bim = this.renderGlyph(path, bounds2D, cellRect);
                return new JLabel(new ImageIcon(bim));
            }
            if (o != null) {
                JLabel label = new JLabel(o.toString(), 0);
                label.setFont(new Font("SansSerif", 0, 25));
                if ("None".equals(o) || ".notdef".equals(o)) {
                    label.setText(o.toString());
                    label.setForeground(Color.RED);
                }
                return label;
            }
            return new JLabel();
        }

        private BufferedImage renderGlyph(GeneralPath path, Rectangle2D bounds2D, Rectangle cellRect) {
            BufferedImage bim = new BufferedImage((int)cellRect.getWidth(), (int)cellRect.getHeight(), 1);
            Graphics2D g = (Graphics2D)bim.getGraphics();
            g.setBackground(Color.white);
            g.clearRect(0, 0, bim.getWidth(), bim.getHeight());
            double scale = 1.0 / ((this.yBounds[1] - this.yBounds[0]) / cellRect.getHeight());
            g.scale(1.0, -1.0);
            g.translate(0, -bim.getHeight());
            g.translate((cellRect.getWidth() - bounds2D.getWidth() * scale) / 2.0, 0.0);
            g.scale(scale, scale);
            g.translate(0.0, -this.yBounds[0]);
            g.setColor(Color.black);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fill(path);
            g.dispose();
            return bim;
        }
    }
}

