/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.util.LinkedList;
import java.util.List;
import zephyr.util.ThreadWork;

public class ThreadWorkInvoker {
    private final LinkedList<ThreadWork> works = new LinkedList();
    public static final int THREAD_NUM = Integer.parseInt(System.getProperty("THREAD_NUM", "1"));

    public void addWork(ThreadWork threadWork) {
        this.works.add(threadWork);
    }

    public void runJob() {
        System.err.println("start " + this.works.size() + " worker threads");
        for (ThreadWork threadWork : this.works) {
            threadWork.start();
        }
        for (ThreadWork threadWork : this.works) {
            threadWork.waitFinish();
        }
    }

    public static <T> LinkedList<LinkedList<T>> divideArray(T[] TArray, int n) {
        int n2 = TArray.length / n;
        int n3 = 0;
        LinkedList<LinkedList<T>> linkedList = new LinkedList<LinkedList<T>>();
        for (int i = 0; i < n; ++i) {
            int n4 = Integer.min(n3 + n2, TArray.length);
            LinkedList<T> linkedList2 = new LinkedList<T>();
            linkedList.add(linkedList2);
            for (int j = n3; j < n4; ++j) {
                linkedList2.add(TArray[j]);
            }
            n3 += n2;
        }
        return linkedList;
    }

    public static Integer[] makeIntArray(int n, int n2) {
        Integer[] integerArray = new Integer[n2 - n + 1];
        int n3 = n;
        int n4 = 0;
        while (n3 <= n2) {
            integerArray[n4] = n3;
            ++n3;
            ++n4;
        }
        return integerArray;
    }

    public static LinkedList<LinkedList<Integer>> divideIntArrayPara(int n, int n2, int n3) {
        return ThreadWorkInvoker.divideArrayPara(ThreadWorkInvoker.makeIntArray(n, n2), n3);
    }

    public static <T> LinkedList<LinkedList<T>> divideArrayPara(T[] TArray, int n) {
        int n2;
        LinkedList<LinkedList<T>> linkedList = new LinkedList<LinkedList<T>>();
        int n3 = Integer.min(TArray.length, n);
        for (n2 = 0; n2 < n3; ++n2) {
            linkedList.add(new LinkedList());
        }
        for (n2 = 0; n2 < TArray.length; ++n2) {
            linkedList.get(n2 % n3).add(TArray[n2]);
        }
        return linkedList;
    }

    public static <T> LinkedList<LinkedList<T>> divideList(List<T> list, int n) {
        int n2;
        LinkedList<LinkedList<T>> linkedList = new LinkedList<LinkedList<T>>();
        int n3 = list.size() / n;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n5 = Integer.min(n4 + n3, list.size());
            LinkedList<T> linkedList2 = new LinkedList<T>();
            linkedList.add(linkedList2);
            for (int i = n4; i < n5; ++i) {
                linkedList2.add(list.get(i));
            }
            n4 += n3;
        }
        if (n5 < list.size()) {
            n2 = list.size() - n5;
            for (int i = 0; i < n2; ++i) {
                linkedList.get(i).add(list.get(n5 + i));
            }
        }
        return linkedList;
    }

    public static void main(String[] stringArray) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n = 8;
        for (int i = 0; i < 2 * n + 5; ++i) {
            System.out.println(i);
            System.out.println(ThreadWorkInvoker.divideList(linkedList, n));
            System.out.println(ThreadWorkInvoker.divideIntArrayPara(0, i - 1, n));
            linkedList.add(i);
        }
    }

    static {
        System.err.println("THREAD_NUM=" + THREAD_NUM);
    }
}

