/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import zephyr.util.BIMUtil;
import zephyr.util.PDF2MonoBMP;

public class PDF2MonoBMPDual
extends PDF2MonoBMP {
    private static final int DROP_LINE_WIDTH = 1;
    private static final int MARGIN_WIDTH = 10;
    private final int dropLineDot;
    private final int marginSpan;

    PDF2MonoBMPDual(int n) {
        super(n);
        this.dropLineDot = BIMUtil.mm2dot(1.0, n);
        this.marginSpan = BIMUtil.mm2dot(10.0, n);
        this.dumpProp("line.top");
        this.dumpProp("line.centerOdd");
        this.dumpProp("line.centerEven");
    }

    private void dumpProp(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            System.out.println(string + "\t" + string2);
        }
    }

    @Override
    protected void convert(BufferedImage bufferedImage, File file) throws Exception {
        int n;
        int n2;
        bufferedImage = this.cleanup(bufferedImage);
        boolean bl = file.getName().matches(".*[13579]\\.bmp");
        int n3 = BIMUtil.findHorizontalLine(bufferedImage) + this.dropLineDot;
        int n4 = bufferedImage.getHeight() - n3;
        int n5 = BIMUtil.findVerticalLine(bufferedImage, bl);
        if (n5 > 0) {
            n2 = n5 - this.dropLineDot;
            n = n5 + this.dropLineDot;
        } else {
            System.err.println("\u7e26\u7dda\u691c\u51fa\u5931\u6557 " + file.getName());
            n5 = -n5;
            n2 = Integer.min(n5 + this.marginSpan, bufferedImage.getWidth());
            n = Integer.max(n5 - this.marginSpan, 0);
        }
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(0, n3, n2, n4);
        bufferedImage2 = BIMUtil.trim(bufferedImage2);
        File file2 = new File(file.getAbsolutePath().replace(".bmp", "a.bmp"));
        if (bufferedImage2 != null) {
            ImageIO.write((RenderedImage)bufferedImage2, this.OUTPUT_TYPE, file2);
            System.out.print(file2.getName() + " ");
        } else {
            System.out.print(file2.getName() + "\u767d\u7d19 ");
        }
        BufferedImage bufferedImage3 = bufferedImage.getSubimage(n, n3, bufferedImage.getWidth() - n, n4);
        bufferedImage3 = BIMUtil.trim(bufferedImage3);
        File file3 = new File(file.getAbsolutePath().replace(".bmp", "b.bmp"));
        if (bufferedImage3 != null) {
            ImageIO.write((RenderedImage)bufferedImage3, this.OUTPUT_TYPE, file3);
            System.out.print(file3.getName() + " ");
        } else {
            System.out.print(file3.getName() + "\u767d\u7d19 ");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java PDF2MonoBMPDual sample.pdf outDir [dpi] [startPage] [endPage] [prefix] [startIdx]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 200;
        int n2 = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : 1;
        int n3 = stringArray.length > 4 ? Integer.parseInt(stringArray[4]) : Integer.MAX_VALUE;
        String string3 = stringArray.length > 5 && !stringArray[5].equals("null") ? stringArray[5] : null;
        int n4 = stringArray.length > 6 ? Integer.parseInt(stringArray[6]) : 1;
        PDF2MonoBMPDual pDF2MonoBMPDual = new PDF2MonoBMPDual(n);
        pDF2MonoBMPDual.convert(string, string2, string3, n4, n, n2, n3);
    }
}

