/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class ImageConverter {
    private final String inExt;
    private final String outExt;
    private final String inDotExt;
    private final String outDotExt;
    private final String DOT_EXT = ".";
    private final int scaling;
    private final boolean toUpper;
    private final boolean toLower;

    public ImageConverter(String string, String string2) {
        this(string, string2, 100);
    }

    public ImageConverter(String string, String string2, int n) {
        this.inExt = this.dropDot(string).toLowerCase();
        this.outExt = this.dropDot(string2).toLowerCase();
        this.inDotExt = "." + string;
        this.outDotExt = "." + string2;
        this.scaling = n;
        this.toUpper = "true".equals(System.getProperty("upperName"));
        this.toLower = "true".equals(System.getProperty("lowerName"));
    }

    private String dropDot(String string) {
        if (string.startsWith(".")) {
            return string.substring(".".length());
        }
        return string;
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        bufferedImage2.getGraphics().drawImage(bufferedImage.getScaledInstance(n, n2, 16), 0, 0, n, n2, null);
        return bufferedImage2;
    }

    private void convert(File file, File file2) throws Exception {
        String string = file.getName();
        System.err.print(string + " ");
        string = string.substring(0, string.length() - this.inDotExt.length()) + this.outDotExt;
        if (this.toUpper) {
            string = string.toUpperCase();
        } else if (this.toLower) {
            string = string.toLowerCase();
        }
        File file3 = new File(file2, string);
        BufferedImage bufferedImage = ImageIO.read(file);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, Color.WHITE, null);
        if (this.scaling != 100) {
            int n = this.scaling * bufferedImage2.getWidth() / 100;
            int n2 = this.scaling * bufferedImage2.getHeight() / 100;
            bufferedImage2 = ImageConverter.resize(bufferedImage2, n, n2);
        }
        ImageIO.write((RenderedImage)bufferedImage2, this.outExt, file3);
    }

    private void convertDir(File file, File file2) throws Exception {
        System.err.println("\u5909\u63db\u5143\uff1a" + file.getAbsolutePath() + "\t" + this.inExt);
        System.err.println("\u5909\u63db\u5148\uff1a" + file2.getAbsolutePath() + "\t" + this.outExt);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            if (!((String)object).toLowerCase().endsWith(this.inDotExt)) continue;
            this.convert(new File(file, (String)object), file2);
        }
        System.err.println();
    }

    public void convertDir(String string, String string2) throws Exception {
        File file = new File(string);
        File file2 = new File(string2);
        this.convertDir(file, file2);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 4) {
            System.err.println("Usage: java ImageConverter inDir inExt outDir outExt [scalling%]");
            return;
        }
        ImageConverter imageConverter = stringArray.length < 5 ? new ImageConverter(stringArray[1], stringArray[3]) : new ImageConverter(stringArray[1], stringArray[3], Integer.parseInt(stringArray[4]));
        imageConverter.convertDir(stringArray[0], stringArray[2]);
    }
}

