/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.imageio.ImageIO;
import zephyr.util.ImageConverter;

public class MakeGaiji {
    private static final String RET = System.getProperty("line.separator");
    private static final int EBCODE_START = 41260;
    private static final int UNICODE_START = 57344;
    private int nextUnicode = 57344;
    private static final int GAIJI_SIZE = 16;

    private BufferedImage getImage(File file) throws Exception {
        BufferedImage bufferedImage = ImageIO.read(file);
        return ImageConverter.resize(bufferedImage, 16, 16);
    }

    private void load(File file, PrintWriter printWriter, PrintWriter printWriter2) throws Exception {
        BufferedImage bufferedImage = this.getImage(file);
        if (bufferedImage.getWidth() != bufferedImage.getHeight()) {
            return;
        }
        System.out.print(" " + file.getName());
        String string = file.getName().substring(0, 4).toUpperCase();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<fontData ebcode=\"");
        stringBuilder.append(string);
        stringBuilder.append("\" unicode=\"");
        stringBuilder.append(String.format("%X", this.nextUnicode));
        stringBuilder.append("\">\n");
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                boolean bl;
                boolean bl2 = bl = bufferedImage.getRGB(j, i) != 0;
                if (bl) {
                    stringBuilder.append("#");
                    continue;
                }
                stringBuilder.append(" ");
            }
            stringBuilder.append(RET);
        }
        stringBuilder.append("</fontData>");
        printWriter.println(stringBuilder.toString());
        printWriter2.printf("<gaijiMap unicode=\"#x%X\" ebcode=\"%s\"/>\n", this.nextUnicode, string);
        ++this.nextUnicode;
    }

    private void load(String string) throws Exception {
        File file = new File(string);
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        PrintWriter printWriter = new PrintWriter("Gaiji.xml");
        printWriter.println("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
        printWriter.println("<gaijiData xml:space=\"preserve\">");
        printWriter.printf("<fontSet size=\"%dX%d\" start=\"%X\">\n", 16, 16, 41260);
        PrintWriter printWriter2 = new PrintWriter("GaijiMap.xml");
        printWriter2.println("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
        printWriter2.println("<gaijiSet>");
        for (Object object : objectArray) {
            if (!((String)object).matches("[ABCabc][0-9A-Fa-f]{3}\\.[Pp][Nn][Gg]")) continue;
            this.load(new File(file, (String)object), printWriter, printWriter2);
        }
        printWriter.println("</fontSet>");
        printWriter.println("</gaijiData>");
        printWriter.close();
        printWriter2.println("</gaijiSet>");
        printWriter2.close();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "C:\\Program Files\\LogoVista\\LVEDBRSR\\DIC\\NKGORIN2\\Gaijitemp";
        MakeGaiji makeGaiji = new MakeGaiji();
        makeGaiji.load(string);
    }
}

