/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.taishukan.kangorin.IndexManager;
import zephyr.taishukan.kangorin.MakeImages;
import zephyr.util.Counter;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<Character, Character> zenhanMap = new HashMap();
    private static final TreeSet<Character> unknownHanSet = new TreeSet();
    private static final HashMap<String, String> GAIJI2TXT;
    private static final Pattern MAP_LINE;
    private static final Pattern GAIJI_LINE;
    private final HashMap<String, String> uni2privMap = new HashMap();
    private static final Pattern LINE;
    static final String WARN_CH = "<sup>*</sup>";
    private static final String RET;
    private static final HashMap<String, String> eb2htmlMap;
    private static final Pattern CHCODE;
    private static final String EP_DT_START_BUSHU = "<1F09><0001><1F41><0160>";
    private static final String EP_DT_START_KANJI = "<1F09><0002><1F41><0160>";
    private static final String EP_ANKER = "<1F09><9999>";
    private static final int EPTAG_LEN;
    private final LinkedList<String> closeTags = new LinkedList();
    private final HashSet<String> posSet = new HashSet();
    public static final String SUBKEY = "<subkey/>";
    public static final String JP = "";
    public static final String EXMP_EN = "<exmp/>";
    public static final String EXMP_JP = "<exmpjp/>";
    public static final String IDIOM_EN = "<idiom/>";
    public static final String IDIOM_JP = "<idiomjp/>";
    private final Counter<String> unknownGaijiCounter = new Counter();
    private boolean prevJukugo = false;
    private boolean inJukugoDT = false;
    private String dtKeys = null;
    private final LinkedList<String> kanjiNos = new LinkedList();
    private static final Pattern EP_REF;

    private static char zen2han(char c) {
        if ('\uff10' <= c && c <= '\uff19') {
            return (char)(48 + (c - 65296));
        }
        if ('\uff21' <= c && c <= '\uff3a') {
            return (char)(65 + (c - 65313));
        }
        if ('\uff41' <= c && c <= '\uff5a') {
            return (char)(97 + (c - 65345));
        }
        if (c <= '~') {
            return c;
        }
        Character c2 = zenhanMap.get(Character.valueOf(c));
        if (c2 != null) {
            return c2.charValue();
        }
        unknownHanSet.add(Character.valueOf(c));
        return '#';
    }

    public static String zen2han(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(MakeBodyHtml.zen2han(string.charAt(i)));
        }
        return stringBuilder.toString();
    }

    private void loadLVGaijiMap(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = MAP_LINE.matcher(string2);
            if (!matcher.find()) continue;
            String string3 = matcher.group(1).toUpperCase();
            char c = (char)Integer.parseInt(matcher.group(2), 16);
            GAIJI2TXT.put(string3, Character.toString(c));
        }
        bufferedReader.close();
    }

    private void loadGaijiMap(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = GAIJI_LINE.matcher(string2);
            if (!matcher.find()) continue;
            String string3 = matcher.group(2).toUpperCase();
            String string4 = matcher.group(1);
            this.uni2privMap.put(string3, string4);
        }
        bufferedReader.close();
        System.err.println("load " + this.uni2privMap.size() + " extra gaiji entries");
    }

    private void addGaiji2Unicode(String string, String string2, boolean bl) {
        String string3 = bl ? "<sup>?</sup>" : JP;
        int n = Integer.parseInt(string2, 16);
        if (n < 131072) {
            GAIJI2TXT.put(string, "/&#x" + string2 + ";" + string3 + " <img src=\"i/" + string + ".JPG\"/>/");
        } else {
            String string4 = this.uni2privMap.get(string2);
            if (string4 != null) {
                GAIJI2TXT.put(string, "/&#x" + string4 + ";" + string3 + " <img src=\"i/" + string + ".JPG\"/>/");
            } else {
                System.err.println("\u79c1\u7684\u30b3\u30fc\u30c9\u4e0d\u660e\uff1a" + string);
                GAIJI2TXT.put(string, "/&amp;#x" + string2 + ";" + string3 + " <img src=\"i/" + string + ".JPG\"/>/");
            }
        }
    }

    private void loadGaiji2Unicode(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\t");
            if (stringArray.length < 4 || stringArray[3].length() <= 0) continue;
            this.addGaiji2Unicode(stringArray[0], stringArray[3], false);
        }
        bufferedReader.close();
    }

    private void loadUnknownGaiji2Unicode(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            boolean bl;
            Matcher matcher = LINE.matcher(string2);
            if (!matcher.find()) continue;
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            boolean bl2 = bl = matcher.group(3) != null && matcher.group(3).length() > 0;
            if (!bl) {
                this.addGaiji2Unicode(string3, string4, false);
                continue;
            }
            this.addGaiji2Unicode(string3, string4, true);
        }
        bufferedReader.close();
    }

    private String makeUTFChar(String string) {
        StringBuilder stringBuilder = null;
        Matcher matcher = CHCODE.matcher(string);
        int n = 0;
        while (matcher.find()) {
            if (n >= matcher.start()) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string.substring(n, matcher.start()));
            int n2 = Integer.parseInt(MakeBodyHtml.zen2han(matcher.group(1)), 16);
            stringBuilder.append((char)n2);
            n = matcher.end();
        }
        if (stringBuilder == null) {
            return string;
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    private void addKanjiNo(String string) {
        string = string.replaceAll("<[0-9A-F]+>", JP);
        string = MakeBodyHtml.zen2han(string);
        this.kanjiNos.add(string);
    }

    private void handleImage(StringBuilder stringBuilder, String string) {
        Matcher matcher = MakeImages.SINGLE_IMAGE.matcher(string);
        if (!matcher.find()) {
            System.err.println("\u56f3\u5f62\u7570\u5e38\uff1a" + string);
            return;
        }
        String string2 = MakeImages.pos2filename(matcher.group(1), matcher.group(2));
        String string3 = matcher.group(3);
        stringBuilder.append("<img src=\"g/");
        stringBuilder.append(string2);
        stringBuilder.append("\"/>");
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(string3);
        }
        stringBuilder.append("\u3000");
    }

    private String ep2html(String string, HashSet<String> hashSet, IndexManager indexManager) {
        String string2;
        if ((string = this.makeUTFChar(string)).contains("<1F09><0062>")) {
            string = string.replace('\uff0a', '*');
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        int n = string.indexOf(93);
        String[] stringArray = string.substring(1, n).replace(" ", "0").split(":");
        if (stringArray[1].equals("800")) {
            stringArray[0] = String.format("%X", Integer.parseInt(stringArray[0], 16) + 1);
            stringArray[1] = "000";
        }
        String string3 = stringArray[0] + stringArray[1];
        boolean bl2 = hashSet.contains(string3);
        String string4 = indexManager.getKey(string3);
        if (string4 != null) {
            bl2 = true;
            if (this.dtKeys == null) {
                this.dtKeys = string4;
            }
        }
        String string5 = string.substring(++n);
        if (!bl2 && string5.startsWith(EP_ANKER)) {
            return JP;
        }
        boolean bl3 = false;
        if (bl2) {
            string2 = "</p>" + RET + "<p id=\"" + string3 + "\">";
            this.posSet.add(string3);
        } else {
            string2 = "</p>" + RET + "<p>";
        }
        String string6 = "</p></dd>" + RET + "<dt id=\"" + string3 + "\" noindex=\"1\">";
        String string7 = this.dtKeys != null ? "</dt>" + this.dtKeys + "<dd>" + RET + "<p>" : "</dt><dd>" + RET + "<p>";
        boolean bl4 = false;
        boolean bl5 = false;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                String string8;
                switch (string8 = string.substring(n + 1, n + 5)) {
                    case "1FE0": {
                        String string9;
                        switch (string9 = string.substring(n + 7, n + 11)) {
                            case "0001": {
                                stringBuilder.append("<i>");
                                this.closeTags.addFirst("</i>");
                                break;
                            }
                            case "0000": 
                            case "0003": {
                                if (bl3) break;
                                stringBuilder.append("<b>");
                                this.closeTags.addFirst("</b>");
                            }
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F09": {
                        String string9;
                        String string10 = string.substring(n);
                        if (string10.startsWith(EP_DT_START_BUSHU) || string10.startsWith(EP_DT_START_KANJI)) {
                            if (!this.closeTags.isEmpty()) {
                                System.err.println("missing closeTags before " + string3);
                            }
                            if (bl2) {
                                stringBuilder.append("<dt id=\"" + string3 + "\" noindex=\"1\">");
                                bl2 = false;
                            } else {
                                stringBuilder.append("<dt>");
                            }
                            bl3 = true;
                            n += EP_DT_START_BUSHU.length();
                            this.inJukugoDT = false;
                            break;
                        }
                        switch (string9 = string.substring(n + 7, n + 11)) {
                            case "0011": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0010": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0060": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0061": {
                                stringBuilder.append(string2);
                                stringBuilder.append("\u3000");
                                break;
                            }
                            case "0030": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0062": {
                                stringBuilder.append(" ");
                                break;
                            }
                            case "0002": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0007": {
                                return JP;
                            }
                            case "0020": {
                                stringBuilder.append(string2 + "\u6f22\u5b57\u756a\u53f7\uff1a");
                                this.addKanjiNo(string5);
                                break;
                            }
                            case "0014": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0021": {
                                stringBuilder.append("\u3000");
                                break;
                            }
                            case "0022": {
                                stringBuilder.append("\u3000");
                                break;
                            }
                            case "0023": {
                                stringBuilder.append("\u3000");
                                break;
                            }
                            case "0024": {
                                stringBuilder.append("\u3000");
                                break;
                            }
                            case "0012": {
                                stringBuilder.append("\u3000");
                                break;
                            }
                            case "0013": {
                                break;
                            }
                            case "0028": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0027": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0026": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0025": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0008": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0090": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0063": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0031": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0032": {
                                stringBuilder.append(string2 + "\u6f22\u5b57\u756a\u53f7\uff1a");
                                this.addKanjiNo(string5);
                                break;
                            }
                            case "0033": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0034": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0035": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0036": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0037": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0038": 
                            case "0070": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0039": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0043": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0044": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0040": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0041": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0042": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0068": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0051": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0050": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0052": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0053": {
                                if (this.inJukugoDT) {
                                    stringBuilder.append(string7);
                                    this.inJukugoDT = false;
                                    this.dtKeys = null;
                                    break;
                                }
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0054": {
                                if (this.inJukugoDT) {
                                    stringBuilder.append(string7);
                                    this.inJukugoDT = false;
                                    this.dtKeys = null;
                                    break;
                                }
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0055": {
                                stringBuilder.append(string2 + "\u3000");
                                break;
                            }
                            case "0056": {
                                stringBuilder.append(string2 + "\u3000\u3000");
                                break;
                            }
                            case "0081": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0082": {
                                break;
                            }
                            case "0080": {
                                bl4 = true;
                                if (this.prevJukugo) {
                                    stringBuilder.append("\u3000");
                                    break;
                                }
                                stringBuilder.append(string2 + "\u25a0 ");
                                break;
                            }
                            case "0003": {
                                stringBuilder.append(string6);
                                this.inJukugoDT = true;
                                break;
                            }
                            case "0067": {
                                stringBuilder.append("\u3000");
                                bl5 = true;
                                break;
                            }
                            case "0066": {
                                if (!this.inJukugoDT) break;
                                stringBuilder.append(string7);
                                this.inJukugoDT = false;
                                this.dtKeys = null;
                                break;
                            }
                            case "0064": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0083": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0084": {
                                break;
                            }
                            case "0065": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0086": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0085": {
                                stringBuilder.append(string2);
                                break;
                            }
                            default: {
                                System.err.println("Unknown 1F09 " + string9);
                                System.exit(1);
                            }
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F61": {
                        if (bl3) {
                            if (string4 != null) {
                                stringBuilder.append("</dt>" + string4 + "<dd><p>");
                            } else {
                                stringBuilder.append("</dt><dd><p>");
                            }
                            bl3 = false;
                        }
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F04": {
                        bl = false;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F05": {
                        bl = true;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1FE1": {
                        for (String string11 : this.closeTags) {
                            stringBuilder.append(string11);
                        }
                        this.closeTags.clear();
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1FE2": {
                        int n2 = string.indexOf("<1FE3>", n);
                        if (n2 < 0) {
                            System.err.println("<1FE3>\u306a\u3057");
                            System.err.println(string);
                            return JP;
                        }
                        n = n2 + EPTAG_LEN;
                        break;
                    }
                    case "1F4A": {
                        stringBuilder.append("\u3000\u97f3\u58f0");
                        n += 3 * EPTAG_LEN;
                        n = string.indexOf(93, n);
                        n = string.indexOf(93, n + 1) + 1;
                        break;
                    }
                    case "1F4D": {
                        int n2 = string.indexOf("<1F6D>", n);
                        if (n2 < 0) {
                            System.err.println("<1F6D>\u4e0d\u660e");
                            System.err.println(string);
                            return JP;
                        }
                        this.handleImage(stringBuilder, string.substring(n, n2 += EPTAG_LEN));
                        n = n2;
                        break;
                    }
                    default: {
                        String string12;
                        if (string8.compareTo("A121") >= 0 && string8.compareTo("FE7E") <= 0) {
                            string12 = GAIJI2TXT.get(string8);
                            if (string12 != null) {
                                stringBuilder.append(string12);
                            } else {
                                stringBuilder.append("<img src=\"i/");
                                stringBuilder.append(string8);
                                stringBuilder.append(".jpg\" /> ");
                                stringBuilder.append(string8);
                            }
                        } else {
                            string12 = eb2htmlMap.get(string8);
                            if (string12 != null) {
                                stringBuilder.append(string12);
                            }
                        }
                        n += EPTAG_LEN;
                        break;
                    }
                }
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append(MakeBodyHtml.zen2han(c));
            }
            ++n;
        }
        String string13 = stringBuilder.toString();
        if (bl3) {
            string13 = string13 + "</dt>" + string4 + "<dd><p>";
        }
        this.prevJukugo = bl4;
        if (bl5) {
            string13 = string13 + "\u3000";
        }
        return string13;
    }

    private HashSet<String> findRefs(String string) throws Exception {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        bufferedReader.readLine();
        bufferedReader.readLine();
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = EP_REF.matcher(string2);
            while (matcher.find()) {
                hashSet.add(matcher.group(1) + matcher.group(2));
            }
        }
        bufferedReader.close();
        System.err.println("found " + hashSet.size() + " unique refs");
        return hashSet;
    }

    private String normalize(String string) {
        string = string.replaceAll("(<p[^>]*>)[\u3000 ]*(\\(<b>[0-9]+</b>\\))", "$1\u3000$2");
        string = string.replaceAll("(<p[^>]*>\u3000*<i>[a-z]+</i>(, *<i>[a-z]+</i>)*) *", "$1\u3000");
        string = string.replaceAll("\\{a\\}([^\\{\\}]+?)\\{/a\\}\\[0*([0-9A-F]+):0([0-9A-F]+)\\]", "<a href=\"#$2$3\">$1</a>");
        string = string.replaceAll("[\u3000 ]+</p>", "</p>");
        string = string.replaceAll("<p[^>]*></p>", JP);
        string = string.replace("<p><jp/></p><p>", "<p><jp/>");
        string = string.replaceAll("=0>=0>\\[[0-9A-F]+:[0-9A-F]+\\]", JP);
        string = string.replaceAll("\u3000+</dt>", "</dt>");
        string = string.replace("\u25b3", "<sup>\u25b3</sup>");
        if (this.kanjiNos.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : this.kanjiNos) {
                stringBuilder.append("<key type=\"\u8868\u8a18\">");
                stringBuilder.append(string2);
                stringBuilder.append("</key>");
            }
            String string3 = stringBuilder.toString();
            string = string.replaceFirst("<dd>", (String)string3 + "<dd>");
            this.kanjiNos.clear();
        }
        string = string.replaceFirst("<dt id=\"(.+?)\" noindex=\"1\">(\u300a.+?\u300b)</dt>(.+?)<dd>", "<h1 id=\"$1\" noindex=\"1\">$2</h1>$3");
        string = string.replaceFirst("(<p>[0-9]+\u753b .+</a></p>)</dd>", "$1");
        return string;
    }

    private void parse(String string, IndexManager indexManager) throws Exception {
        String string2;
        HashSet<String> hashSet = this.findRefs(string);
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        bufferedReader.readLine();
        bufferedReader.readLine();
        StringBuilder stringBuilder = null;
        System.out.println("<html><body>");
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            if ((string2 = string2.trim()).isEmpty() || (string3 = this.ep2html(string2, hashSet, indexManager)).isEmpty()) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else if (string3.startsWith("<dt") && stringBuilder != null) {
                String string4 = this.normalize(stringBuilder.toString() + "</p></dd>");
                System.out.println(string4);
                this.dtKeys = null;
                stringBuilder = new StringBuilder();
                if (++n % 1000 == 0) {
                    if (n % 10000 == 0) {
                        System.err.print(n / 10000);
                    } else {
                        System.err.print(".");
                    }
                }
            }
            stringBuilder.append(string3);
        }
        bufferedReader.close();
        if (stringBuilder != null) {
            System.out.println(this.normalize(stringBuilder.toString()) + "</p></dd>");
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println(n + " entries");
        this.unknownGaijiCounter.dump();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            System.err.println("Usage: java MakeBodyHtml kangorin.txt hyoki.txt kana.txt");
            return;
        }
        ZephyrUtil.setUTF8Ouput();
        MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
        IndexManager indexManager = new IndexManager(stringArray[1], stringArray[2]);
        makeBodyHtml.loadLVGaijiMap("NKGORIN2.map");
        makeBodyHtml.loadGaijiMap("GaijiMap.xml");
        makeBodyHtml.loadGaiji2Unicode("gaiji2unicode.txt");
        makeBodyHtml.loadUnknownGaiji2Unicode("gaiji2unicode.html");
        makeBodyHtml.parse(stringArray[0], indexManager);
    }

    static {
        zenhanMap.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        zenhanMap.put(Character.valueOf('\uff0c'), Character.valueOf(','));
        zenhanMap.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        zenhanMap.put(Character.valueOf('\uff08'), Character.valueOf('('));
        zenhanMap.put(Character.valueOf('\uff09'), Character.valueOf(')'));
        zenhanMap.put(Character.valueOf('\uff3b'), Character.valueOf('['));
        zenhanMap.put(Character.valueOf('\uff3d'), Character.valueOf(']'));
        zenhanMap.put(Character.valueOf('\uff01'), Character.valueOf('!'));
        zenhanMap.put(Character.valueOf('\uff1f'), Character.valueOf('?'));
        zenhanMap.put(Character.valueOf('\uff0b'), Character.valueOf('+'));
        zenhanMap.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0a'), Character.valueOf('*'));
        zenhanMap.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        zenhanMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        zenhanMap.put(Character.valueOf('\uff1a'), Character.valueOf(':'));
        zenhanMap.put(Character.valueOf('\uff1b'), Character.valueOf(';'));
        zenhanMap.put(Character.valueOf('\uff06'), Character.valueOf('&'));
        zenhanMap.put(Character.valueOf('\uff3e'), Character.valueOf('^'));
        zenhanMap.put(Character.valueOf('\uff5c'), Character.valueOf('|'));
        zenhanMap.put(Character.valueOf('\uff1d'), Character.valueOf('='));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        String string = "\u30fc\u300a\u300b\u2015\u3008\u3009\u25c6\u00b0\u21d2\u00b4\uff40\u2032\u2033\uffe0\u2026\u4e00\uff1c\uff1e\u00a7\u00a8\u00d7\u2191\u2193\u300c\u300d\uff5e\u2018\uffe3]";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            zenhanMap.put(Character.valueOf(c), Character.valueOf(c));
        }
        GAIJI2TXT = new HashMap();
        GAIJI2TXT.put("B238", JP);
        GAIJI2TXT.put("B239", JP);
        GAIJI2TXT.put("B23B", JP);
        GAIJI2TXT.put("B241", JP);
        GAIJI2TXT.put("B242", JP);
        GAIJI2TXT.put("A12C", "\u00ea\u0300");
        GAIJI2TXT.put("A13A", "\u00fc\u030c");
        GAIJI2TXT.put("A13B", "\u00fc\u0301");
        GAIJI2TXT.put("A132", "d\u0323");
        GAIJI2TXT.put("A133", "n\u0323");
        GAIJI2TXT.put("A139", "\u00fc\u0300");
        GAIJI2TXT.put("A142", "h\u0323");
        GAIJI2TXT.put("A143", "m\u0323");
        GAIJI2TXT.put("A144", "r\u0323");
        GAIJI2TXT.put("A145", "s\u0323");
        GAIJI2TXT.put("A146", "t\u0323");
        GAIJI2TXT.put("A149", " ");
        GAIJI2TXT.put("B12B", JP);
        GAIJI2TXT.put("B12C", "[\u5b57\u7fa9]");
        GAIJI2TXT.put("B12D", "[\u53c2\u8003]");
        GAIJI2TXT.put("B12E", "[\u540d\u524d]");
        GAIJI2TXT.put("B12F", "[\u96e3\u8aad]");
        GAIJI2TXT.put("B13A", "[\u6559]");
        GAIJI2TXT.put("B13B", "[\u5e38]");
        GAIJI2TXT.put("B13C", "[\u4eba]");
        GAIJI2TXT.put("B13D", "[\u6a19]");
        GAIJI2TXT.put("B13E", "[\u56fd\u5b57]");
        GAIJI2TXT.put("B13F", "[\u52a9\u5b57\u30fb\u53e5\u6cd5\u89e3\u8aac]");
        GAIJI2TXT.put("B148", "(1)");
        GAIJI2TXT.put("B149", "(2)");
        GAIJI2TXT.put("B14A", "(3)");
        GAIJI2TXT.put("B14B", "(4)");
        GAIJI2TXT.put("B14C", "(5)");
        GAIJI2TXT.put("B14D", "(6)");
        GAIJI2TXT.put("B14E", "(7)");
        GAIJI2TXT.put("B14F", "(8)");
        GAIJI2TXT.put("B150", "(9)");
        GAIJI2TXT.put("B151", "(10)");
        GAIJI2TXT.put("B152", "(11)");
        GAIJI2TXT.put("B153", "(12)");
        GAIJI2TXT.put("B154", "(13)");
        GAIJI2TXT.put("B155", "(14)");
        GAIJI2TXT.put("B156", "(15)");
        GAIJI2TXT.put("B157", "(16)");
        GAIJI2TXT.put("B158", "(17)");
        GAIJI2TXT.put("B159", "(18)");
        GAIJI2TXT.put("B15A", "(19)");
        GAIJI2TXT.put("B15B", "(\u30a2)");
        GAIJI2TXT.put("B15C", "(\u30a4)");
        GAIJI2TXT.put("B15D", "(\u30a6)");
        GAIJI2TXT.put("B15E", "(\u30a8)");
        GAIJI2TXT.put("B15F", "(\u30aa)");
        GAIJI2TXT.put("B160", "(\u30ab)");
        GAIJI2TXT.put("B161", "(\u30ad)");
        GAIJI2TXT.put("B162", "(\u30af)");
        GAIJI2TXT.put("B163", "(\u30b1)");
        GAIJI2TXT.put("B164", "(\u30b3)");
        GAIJI2TXT.put("B165", "(\u30b5)");
        GAIJI2TXT.put("B166", "(\u30b7)");
        GAIJI2TXT.put("B167", "(\u30b9)");
        GAIJI2TXT.put("B168", "[[\u4e00]]");
        GAIJI2TXT.put("B169", "[[\u4e8c]]");
        GAIJI2TXT.put("B16A", "[[\u4e09]]");
        GAIJI2TXT.put("B16B", "[[\u56db]]");
        GAIJI2TXT.put("B16C", "[[\u4e94]]");
        GAIJI2TXT.put("B16D", "[[\u516d]]");
        GAIJI2TXT.put("B16E", "(1)");
        GAIJI2TXT.put("B16F", "(2)");
        GAIJI2TXT.put("B170", "(3)");
        GAIJI2TXT.put("B171", "(4)");
        GAIJI2TXT.put("B172", "(5)");
        GAIJI2TXT.put("B173", "(6)");
        GAIJI2TXT.put("B174", "(7)");
        GAIJI2TXT.put("B175", "(8)");
        GAIJI2TXT.put("B176", "(9)");
        GAIJI2TXT.put("B177", "(10)");
        GAIJI2TXT.put("B178", "(11)");
        GAIJI2TXT.put("B179", "(12)");
        GAIJI2TXT.put("B17A", "(13)");
        GAIJI2TXT.put("B17B", "(14)");
        GAIJI2TXT.put("B17C", "(15)");
        GAIJI2TXT.put("B17D", "(\u4e00)");
        GAIJI2TXT.put("B17E", "(\u4e8c)");
        GAIJI2TXT.put("B221", "(\u4e09)");
        GAIJI2TXT.put("B222", "(\u56db)");
        GAIJI2TXT.put("B223", "(\u7532)");
        GAIJI2TXT.put("B224", "(\u4e59)");
        GAIJI2TXT.put("B225", "(\u4e19)");
        GAIJI2TXT.put("B226", "(\u4e01)");
        GAIJI2TXT.put("B227", "(\u620a)");
        GAIJI2TXT.put("B228", "(\u5df1)");
        GAIJI2TXT.put("B229", "[\u4e00]");
        GAIJI2TXT.put("B22A", "[\u4e8c]");
        GAIJI2TXT.put("B22B", "[\u4e09]");
        GAIJI2TXT.put("B22C", "[\u56db]");
        GAIJI2TXT.put("B22D", "[\u4e94]");
        GAIJI2TXT.put("B22E", "((1))");
        GAIJI2TXT.put("B22F", "((2))");
        GAIJI2TXT.put("B230", "((3))");
        GAIJI2TXT.put("B231", "((4))");
        GAIJI2TXT.put("B232", "((5))");
        GAIJI2TXT.put("B233", "((6))");
        GAIJI2TXT.put("B234", "((7))");
        GAIJI2TXT.put("B235", " \u2192 ");
        GAIJI2TXT.put("B236", "\u3014");
        GAIJI2TXT.put("B237", "\u3015");
        GAIJI2TXT.put("B23C", "(\u6f22)");
        GAIJI2TXT.put("B23D", "(\u5449)");
        GAIJI2TXT.put("B23E", "(\u5510)");
        GAIJI2TXT.put("B23F", "(\u6163)");
        GAIJI2TXT.put("B240", "(\u97f3)");
        GAIJI2TXT.put("B243", "[\u540c]");
        GAIJI2TXT.put("B244", "(\u52a9)");
        GAIJI2TXT.put("B123", "[\u7528\u4f8b]");
        GAIJI2TXT.put("B124", "[JIS1\uff652]");
        GAIJI2TXT.put("B125", "[JIS3\uff654]");
        GAIJI2TXT.put("B126", "[S-JIS]");
        GAIJI2TXT.put("B127", "[\u88dc\u52a9]");
        GAIJI2TXT.put("B130", "[\u89e3\u5b57]");
        GAIJI2TXT.put("B131", "[[\u9006]]");
        GAIJI2TXT.put("B133", "<b>[[\u56fd]]</b>");
        GAIJI2TXT.put("B134", "[\u4ecf]");
        GAIJI2TXT.put("B135", "[\u4f7f\u3044\u5206\u3051]");
        GAIJI2TXT.put("B136", "[\u5e73\u58f0]");
        GAIJI2TXT.put("B137", "[\u4e0a\u58f0]");
        GAIJI2TXT.put("B138", "[\u53bb\u58f0]");
        GAIJI2TXT.put("B139", "[\u5165\u58f0]");
        GAIJI2TXT.put("B140", "[\u8a33]");
        GAIJI2TXT.put("B141", "[\u985e]");
        GAIJI2TXT.put("B142", "[\u6ce8\u610f]");
        GAIJI2TXT.put("B143", "[\u89e3\u5b571]");
        GAIJI2TXT.put("B144", "[\u89e3\u5b572]");
        GAIJI2TXT.put("B145", "[\u4fd7\u5b57]");
        GAIJI2TXT.put("B146", "[\u770c\u5b57]");
        GAIJI2TXT.put("B147", "[\u5e9c\u5b57]");
        MAP_LINE = Pattern.compile("[hz]([0-9a-fA-F]+)\tu([0-9a-fA-F]+)");
        GAIJI_LINE = Pattern.compile("<gaijiMap unicode=\"#x(....)\" orgcode=\"#x([0-9A-F]+)\" ebcode=\"....\"");
        LINE = Pattern.compile("<tr><td>([0-9A-F]+{4})</td><td>.+<td>&#x([0-9A-F]+);(.*)</td></tr>");
        RET = System.getProperty("line.separator");
        eb2htmlMap = new HashMap();
        eb2htmlMap.put("1F42", "{a}");
        eb2htmlMap.put("1F62", "{/a}");
        eb2htmlMap.put("1F06", "<sub>");
        eb2htmlMap.put("1F07", "</sub>");
        eb2htmlMap.put("1F0E", "<sup>");
        eb2htmlMap.put("1F0F", "</sup>");
        eb2htmlMap.put("1F12", "<b>");
        eb2htmlMap.put("1F13", "</b>");
        CHCODE = Pattern.compile("\uff06\uff03\uff58([\uff10-\uff19\uff21-\uff26]+)\uff1b");
        EPTAG_LEN = "<xxxx>".length();
        EP_REF = Pattern.compile("<1F62>\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
    }
}

