/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import zephyr.taishukan.daikanwa.DKWEntry;
import zephyr.taishukan.daikanwa.KanjiRefs;
import zephyr.util.MultiLinkedHashMap;
import zephyr.util.MultiTreeMap;

public class KanjiRefCheck {
    protected final HashMap<String, DKWEntry> dkwMap = new LinkedHashMap<String, DKWEntry>();
    private final MultiTreeMap<Integer, String> refCountMap = new MultiTreeMap();
    private final MultiTreeMap<Integer, String> refPointMap = new MultiTreeMap();
    private final MultiTreeMap<Integer, String> beRefCountMap = new MultiTreeMap();
    private final MultiTreeMap<Integer, String> beRefPointMap = new MultiTreeMap();

    private void loadDkw2Ucs(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            DKWEntry dKWEntry = new DKWEntry(string2);
            if (this.dkwMap.containsKey(dKWEntry.no)) {
                System.err.println("\u89aa\u5b57\u756a\u53f7\u91cd\u8907\t" + string2);
            }
            this.dkwMap.put(dKWEntry.no, dKWEntry);
        }
        bufferedReader.close();
    }

    private TreeSet<String> getUniqIds(KanjiRefs kanjiRefs, MultiLinkedHashMap<String, String> multiLinkedHashMap) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (multiLinkedHashMap == null) {
            return treeSet;
        }
        for (String string : multiLinkedHashMap.keySet()) {
            for (String string2 : multiLinkedHashMap.getList(string)) {
                if (string2 == null) continue;
                treeSet.add(string2);
            }
        }
        return treeSet;
    }

    private void check(KanjiRefs kanjiRefs, String string) throws Exception {
        TreeSet<String> treeSet = this.getUniqIds(kanjiRefs, kanjiRefs.getRefMap(string));
        TreeSet<String> treeSet2 = this.getUniqIds(kanjiRefs, kanjiRefs.getBeRefedMap(string));
        int n = 0;
        for (String object : treeSet) {
            if (treeSet2.contains(object)) continue;
            ++n;
        }
        this.refCountMap.put(treeSet.size(), string);
        this.refPointMap.put(n, string);
        int n2 = 0;
        for (String string2 : treeSet2) {
            if (treeSet.contains(string2)) continue;
            ++n2;
        }
        this.beRefCountMap.put(treeSet2.size(), string);
        this.beRefPointMap.put(n2, string);
    }

    private void check() throws Exception {
        KanjiRefs kanjiRefs = new KanjiRefs();
        Set<String> set = kanjiRefs.getDKWNos();
        for (String string : set) {
            this.check(kanjiRefs, string);
        }
    }

    private void output(MultiTreeMap<Integer, String> multiTreeMap) {
        for (Integer n : multiTreeMap.keySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n);
            stringBuilder.append("\t");
            LinkedList linkedList = multiTreeMap.getList(n);
            int n2 = linkedList.size();
            stringBuilder.append(n2);
            stringBuilder.append("\t");
            int n3 = 0;
            for (String string : linkedList) {
                DKWEntry dKWEntry = this.dkwMap.get(string);
                if (dKWEntry != null && dKWEntry.ucsList.size() > 0) {
                    for (String string2 : dKWEntry.ucsList) {
                        int n4 = Integer.parseInt(string2, 16);
                        stringBuilder.append(new String(Character.toChars(n4)));
                    }
                } else {
                    stringBuilder.append("\u25a0");
                }
                if (n2 <= 50) {
                    stringBuilder.append("(");
                    stringBuilder.append(string.replaceFirst("D0*", "").replaceFirst("\\.0", ""));
                    stringBuilder.append(")");
                    stringBuilder.append("   ");
                } else {
                    stringBuilder.append(" ");
                }
                if (++n3 < 100) continue;
                break;
            }
            System.out.println(stringBuilder.toString().trim());
        }
    }

    private void output() {
        System.out.println("\u53c2\u7167\u6570");
        this.output(this.refCountMap);
        System.out.println();
        System.out.println("\u88ab\u53c2\u7167\u6570");
        this.output(this.beRefCountMap);
        System.out.println();
        System.out.println("\u53c2\u7167\u306a\u3057\u30dd\u30a4\u30f3\u30c8");
        this.output(this.refPointMap);
        System.out.println();
        System.out.println("\u88ab\u53c2\u7167\u306a\u3057\u30dd\u30a4\u30f3\u30c8");
        this.output(this.beRefPointMap);
    }

    public static void main(String[] stringArray) throws Exception {
        KanjiRefCheck kanjiRefCheck = new KanjiRefCheck();
        kanjiRefCheck.loadDkw2Ucs("dkw2ucs.txt");
        kanjiRefCheck.check();
        kanjiRefCheck.output();
    }
}

