/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.util.LinkedList;
import zephyr.util.MultiHashMap;

class DKWEntry {
    final String no;
    String page;
    final int bushuNo;
    final int bushuKaku;
    final LinkedList<String> ucsList = new LinkedList();
    String duplicateNo = "";
    String ids = "";
    String relNo = "";
    final LinkedList<String> otherUcsList = new LinkedList();
    final LinkedList<String> otherInfo = new LinkedList();
    static final int UNKNOWN_BUSHUKAKU = 100000;
    static final int UNKNOWN_SOUKAKU = 200000;
    private static final MultiHashMap<String, String> uni2dkwMap = new MultiHashMap();

    DKWEntry(String string) {
        int n;
        String[] stringArray = string.trim().split(" ");
        if (stringArray.length < 4) {
            System.err.println("*** " + string);
            System.exit(1);
        }
        this.no = stringArray[0];
        this.bushuNo = Integer.parseInt(stringArray[1].replaceFirst("DR0*", ""));
        String string2 = stringArray[2].replaceFirst("DS0*", "");
        this.bushuKaku = string2.isEmpty() ? 0 : (string2.equals("??") ? 100000 : Integer.parseInt(string2));
        this.page = stringArray[3];
        for (n = 4; n < stringArray.length && stringArray[n].startsWith("U+"); ++n) {
            uni2dkwMap.put(stringArray[n], this.no);
            this.ucsList.add(stringArray[n].replaceFirst("U\\+0*", ""));
        }
        if (n == stringArray.length) {
            return;
        }
        if (stringArray[n].startsWith("D")) {
            this.duplicateNo = stringArray[n];
            ++n;
        }
        if (n == stringArray.length) {
            return;
        }
        if (stringArray[n].equals("#")) {
            ++n;
        }
        if (n == stringArray.length) {
            return;
        }
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("D")) {
                this.relNo = stringArray[n];
            } else if (stringArray[n].startsWith("U+")) {
                this.otherUcsList.add(stringArray[n].replaceFirst("U\\+0*", ""));
            } else if (stringArray[n].startsWith("missing") || stringArray[n].startsWith("removed") || stringArray[n].startsWith("moved") || stringArray[n].startsWith("changed") || stringArray[n].startsWith("added") || stringArray[n].startsWith("replaced")) {
                this.otherInfo.add(stringArray[n]);
            } else {
                this.ids = stringArray[n];
            }
            ++n;
        }
    }

    boolean isBushu() {
        return this.bushuKaku == 0;
    }

    static LinkedList<String> getByUnicode(int n) {
        return uni2dkwMap.getWithoutNull(String.format("U+%05X", n));
    }
}

