/*
 * Decompiled with CFR 0.152.
 */
package zephyr.omup.grgoi;

import java.awt.image.BufferedImage;
import java.io.File;
import zephyr.util.BIMUtil;
import zephyr.util.PDF2Mono;

public class PDF2BMP
extends PDF2Mono {
    private final int startIdx;
    private final int topDot;
    private final int bottomDot;
    private final int sideDot;
    private final int widthDot;

    PDF2BMP(int n, int n2) {
        super(n, ".bmp", "bmp");
        this.startIdx = n2;
        this.topDot = BIMUtil.mm2dot(10.0, n);
        this.bottomDot = BIMUtil.mm2dot(10.0, n);
        this.sideDot = BIMUtil.mm2dot(3.0, n);
        this.widthDot = BIMUtil.mm2dot(160.0, n);
    }

    static boolean isDual(int n) {
        if (19 <= n && n <= 50) {
            return true;
        }
        return 56 <= n && n <= 136;
    }

    private int leftWidth(BufferedImage bufferedImage, int n) {
        int n2;
        int n3 = BIMUtil.mm2dot(15.0, this.dpi);
        int n4 = bufferedImage.getHeight();
        if ((double)bufferedImage.getWidth() < 0.75 * (double)this.widthDot) {
            for (int i = bufferedImage.getWidth() - 1; i >= 0; --i) {
                if (BIMUtil.isLikeWhiteVertical(bufferedImage, i, 0.01, n3, n4)) continue;
                return i;
            }
            return bufferedImage.getWidth() - 1;
        }
        int n5 = BIMUtil.mm2dot(20.0, this.dpi);
        int n6 = bufferedImage.getWidth() / 2;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        boolean bl = false;
        for (n2 = n6 - n5; n2 < n6 + n5; ++n2) {
            if (BIMUtil.isLikeWhiteVertical(bufferedImage, n2, 0.01, n3, n4)) {
                if (bl) continue;
                bl = true;
                n8 = n2;
                continue;
            }
            if (!bl) continue;
            int n11 = n2 - n8;
            if (n7 < n11) {
                n7 = n11;
                n9 = n8;
                n10 = n2;
            }
            bl = false;
        }
        if (bl && n7 < (n2 = n6 + n5) - n8) {
            n9 = n8;
            n10 = n2;
        }
        if (n9 > 0) {
            if (n != 59 && n != 136) {
                return (n9 + n10) / 2;
            }
            return n9;
        }
        return -1;
    }

    @Override
    protected void convert(BufferedImage bufferedImage, File file) throws Exception {
        bufferedImage = bufferedImage.getSubimage(this.sideDot, this.topDot, bufferedImage.getWidth() - 2 * this.sideDot, bufferedImage.getHeight() - this.topDot - this.bottomDot);
        bufferedImage = this.cleanup(bufferedImage);
        bufferedImage = BIMUtil.trim(bufferedImage);
        int n = Integer.parseInt(file.getName().replaceAll("[^-0-9]+", ""));
        if (PDF2BMP.isDual(n)) {
            int n2;
            int n3;
            int n4 = this.leftWidth(bufferedImage, n);
            if (n4 < 0) {
                System.err.println("\u4e2d\u592e\u5206\u5272\u4f4d\u7f6e\u306e\u691c\u51fa\u5931\u6557  p." + n);
                n4 = bufferedImage.getWidth() / 2;
                n3 = (int)(1.1 * (double)n4);
                n2 = bufferedImage.getWidth() - n3;
            } else {
                n2 = n3 = n4;
            }
            BufferedImage bufferedImage2 = bufferedImage.getSubimage(0, 0, n3, bufferedImage.getHeight());
            BufferedImage bufferedImage3 = bufferedImage.getSubimage(n2, 0, bufferedImage.getWidth() - n2, bufferedImage.getHeight());
            File file2 = new File(file.getParentFile(), n + "a.bmp");
            File file3 = new File(file.getParentFile(), n + "b.bmp");
            super.convert(bufferedImage2, file2);
            super.convert(bufferedImage3, file3);
        } else {
            if (n <= 0) {
                file = new File(file.getParentFile(), "h" + (n - this.startIdx + 1) + ".bmp");
            }
            super.convert(bufferedImage, file);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java PDF2Mono sample.pdf [dpi] [startPage] [endPage]");
            return;
        }
        String string = stringArray[0];
        int n = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 300;
        int n2 = stringArray.length > 2 ? -Integer.parseInt(stringArray[2]) + 2 : 1;
        int n3 = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : Integer.MAX_VALUE;
        String string2 = "p";
        String string3 = "";
        int n4 = 1;
        PDF2BMP pDF2BMP = new PDF2BMP(n, n2);
        pDF2BMP.convert(string, string2, string3, n2, n, n4, n3);
    }
}

