/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.encol;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import zephyr.kenkyusha.encol.Gaiji;
import zephyr.kenkyusha.encol.Util;
import zephyr.util.ZephyrUtil;

public class EP2HTML {
    private static final String EP_DT_START = "<1F09><0001><1F41><0191><1F61>";
    private static final String EP_PART_START = "<1F09><0002><1F41><0291><1F61><1FE0><0003>";
    private static final String EP_SENTENCE_START = "<1F09><0002><1F41><0291><1F61>";
    private static final int EPTAG_LEN = "<xxxx>".length();
    private final LinkedList<String> closeTags = new LinkedList();
    private final Gaiji gaiji = new Gaiji("GaijiMap.xml");
    private int nEntry = 0;

    private String ep2html(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        int n = string.indexOf(93);
        ++n;
        boolean bl2 = false;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                String string2;
                switch (string2 = string.substring(n + 1, n + 5)) {
                    case "1FE0": {
                        String string3;
                        switch (string3 = string.substring(n + 7, n + 11)) {
                            case "0001": {
                                stringBuilder.append("<i>");
                                this.closeTags.addFirst("</i>");
                                break;
                            }
                            case "0000": 
                            case "0003": {
                                if (bl2) break;
                                stringBuilder.append("<b>");
                                this.closeTags.addFirst("</b>");
                            }
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F09": {
                        String string3;
                        String string4 = string.substring(n);
                        if (string4.startsWith(EP_DT_START)) {
                            if (!this.closeTags.isEmpty()) {
                                System.err.println("missing closeTags before" + string);
                            }
                            stringBuilder.append("<dt>");
                            bl2 = true;
                            n += EP_DT_START.length();
                            break;
                        }
                        if (string4.startsWith(EP_PART_START)) {
                            n += EP_PART_START.length();
                            break;
                        }
                        if (string4.startsWith(EP_SENTENCE_START)) {
                            n += EP_SENTENCE_START.length();
                            break;
                        }
                        switch (string3 = string.substring(n + 7, n + 11)) {
                            case "0001": {
                                break;
                            }
                            case "0002": {
                                break;
                            }
                            default: {
                                System.err.println("Unknown 1F09 " + string3);
                            }
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F04": {
                        bl = false;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F05": {
                        bl = true;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1FE1": {
                        for (String string5 : this.closeTags) {
                            stringBuilder.append(string5);
                        }
                        this.closeTags.clear();
                        if (bl2) {
                            stringBuilder.append("</dt>");
                            bl2 = false;
                        }
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F10": 
                    case "1F11": {
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F0A": {
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F42": {
                        if (string.substring(n + EPTAG_LEN).startsWith("\u2192<B12D><1F62>[")) {
                            return stringBuilder.toString();
                        }
                    }
                    case "1F62": {
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F06": {
                        stringBuilder.append("<sub>");
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F07": {
                        stringBuilder.append("</sub>");
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F0E": {
                        stringBuilder.append("<sup>");
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F0F": {
                        stringBuilder.append("</sup>");
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F03": {
                        n += EPTAG_LEN;
                        break;
                    }
                    default: {
                        if (string2.compareTo("A121") >= 0 && string2.compareTo("FE7E") <= 0) {
                            stringBuilder.append(this.gaiji.eb2uni(string2));
                        } else {
                            System.err.println("Unknown CODE : " + string2);
                            System.err.println(string.substring(n));
                            System.exit(1);
                        }
                        n += EPTAG_LEN;
                        break;
                    }
                }
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append(ZephyrUtil.zen2han(c));
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private void output(String string, LinkedList<String> linkedList) {
        if (string.isEmpty()) {
            return;
        }
        if (string.startsWith("<dt>")) {
            System.out.println(string);
            ++this.nEntry;
            return;
        }
        if (string.startsWith("\u3010") || string.matches("^\\(<b>[0-9]+</b>\\) .+")) {
            System.out.println("<p>" + string + "</p>");
            return;
        }
        System.out.println("<p>" + string + "</p>");
        linkedList.add(Util.dropHeadMark(string));
    }

    private void skipFirstPart(BufferedReader bufferedReader) throws Exception {
        String string;
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.contains("<1F02>") || ++n < 2) continue;
            return;
        }
    }

    public LinkedList<String> load(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        this.skipFirstPart(bufferedReader);
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3 = this.ep2html(string2);
            if (string3.length() <= 0) continue;
            this.output(string3, linkedList);
        }
        bufferedReader.close();
        System.err.println(this.nEntry + "\u898b\u51fa\u3057\u3001" + linkedList.size() + "\u7528\u4f8b");
        return linkedList;
    }
}

