/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import zephyr.kagakudoujin.kagakueigo.Util;

public class FileLoader {
    static LinkedList<byte[]> load(File file, byte[] byArray) throws Exception {
        return FileLoader.load(file, byArray, 0);
    }

    static LinkedList<byte[]> load(File file, byte[] byArray, int n) throws Exception {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        BinData binData = new BinData();
        byte[] byArray2 = FileLoader.loadBinary(file);
        if (byArray2 == null) {
            return linkedList;
        }
        int n2 = Util.findData(byArray2, n, byArray2.length, byArray);
        while (n2 < byArray2.length) {
            int n3;
            if ((n2 += byArray.length) == (n3 = Util.findData(byArray2, n2, byArray2.length, byArray))) continue;
            if (n2 < n3) {
                binData.add(byArray2, n2, n3);
                linkedList.add(binData.get());
                binData.clear();
                n2 = n3;
                continue;
            }
            binData.add(byArray2, n2, byArray2.length);
            linkedList.add(binData.get());
            break;
        }
        return linkedList;
    }

    static byte[] loadBinary(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        byte[] byArray = new byte[(int)file.length()];
        int n = bufferedInputStream.read(byArray, 0, byArray.length);
        bufferedInputStream.close();
        if ((long)n == file.length()) {
            return byArray;
        }
        return null;
    }

    private static class BinData {
        private byte[] data = null;

        private BinData() {
        }

        void add(byte[] byArray, int n, int n2) {
            int n3 = n2 - n;
            if (this.data == null) {
                this.data = Arrays.copyOfRange(byArray, n, n2);
            } else {
                byte[] byArray2 = Arrays.copyOf(this.data, this.data.length + n3);
                System.arraycopy(byArray, 0, byArray2, this.data.length, n3);
                this.data = byArray2;
            }
        }

        byte[] get() {
            return this.data;
        }

        void clear() {
            this.data = null;
        }

        public String toString() {
            if (this.data == null) {
                return "null";
            }
            try {
                String string = new String(this.data, "Windows-31J");
                return string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return "?";
            }
        }
    }
}

