/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class UTF8toSJIS {
    private static final TreeSet<Character> extChSet = new TreeSet();
    private static final HashMap<Integer, String> extFixMap = new HashMap();
    private static final HashSet<Character> sjisOkSet;
    private static final Pattern HEX;
    private static final String UNICODE_REGEXP = "unicode=\"#x([^\"]*)\"";
    private static final Pattern convpat;
    private HashSet<Integer> gaijiUniSet = new HashSet();

    private static void addExtFix(char c, String string) {
        extFixMap.put(Integer.valueOf(c), string);
    }

    private static String kuromarunum(int n) {
        return "<b>(" + Integer.toString(n) + ")</b>";
    }

    private static String siromarunum(int n) {
        return Integer.toString(n);
    }

    private static String parnum(int n) {
        return "(" + n + ")";
    }

    static String code2hex(char c) {
        return String.format("&#x%x;", c);
    }

    private static void addExtFixAsHex(char c) {
        UTF8toSJIS.addExtFix(c, UTF8toSJIS.code2hex(c));
    }

    private static void addExtFix(char c) {
        UTF8toSJIS.addExtFix(c, Character.toString(c));
    }

    public static String convert(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            String string2 = extFixMap.get(n);
            if (string2 != null) {
                stringBuffer.append(string2);
                continue;
            }
            if (n >= 65280 || 913 <= n && n <= 937 || 945 <= n && n <= 969 && n != 962) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (128 <= n && n < 1024 || 1280 <= n && n < 12288 || 57344 <= n) {
                stringBuffer.append(String.format("&#x%x;", n));
                extChSet.add(Character.valueOf(string.charAt(i)));
                continue;
            }
            if (n == 12316) {
                stringBuffer.append('\uff5e');
                continue;
            }
            char c = string.charAt(i);
            if (sjisOkSet.contains(Character.valueOf(c))) {
                stringBuffer.append(c);
                continue;
            }
            if (extChSet.contains(Character.valueOf(c))) {
                stringBuffer.append(String.format("&#x%x;", n));
                continue;
            }
            String string3 = string.substring(i, i + 1);
            try {
                byte[] byArray = string3.getBytes("ISO2022JP");
                String string4 = new String(byArray, "ISO2022JP");
                if (string3.equals(string4)) {
                    sjisOkSet.add(Character.valueOf(c));
                    stringBuffer.append(c);
                    continue;
                }
                extChSet.add(Character.valueOf(c));
                stringBuffer.append(String.format("&#x%x;", n));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(unsupportedEncodingException);
                System.exit(1);
            }
        }
        return stringBuffer.toString();
    }

    public static String hex2uni(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Matcher matcher = HEX.matcher(string);
        int n = 0;
        while (matcher.find()) {
            if (n < matcher.start()) {
                stringBuffer.append(string.substring(n, matcher.start()));
            }
            int n2 = "x".equals(matcher.group(1)) ? Integer.parseInt(matcher.group(2), 16) : Integer.parseInt(matcher.group(2), 10);
            stringBuffer.append((char)n2);
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private void output(String string) {
        System.out.println(string);
    }

    private void convert(String[] stringArray) throws Exception {
        String string;
        InputStream inputStream = stringArray.length > 0 && !stringArray[0].equals("-") ? new FileInputStream(new File(stringArray[0])) : System.in;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while ((string = bufferedReader.readLine()) != null) {
            this.output(UTF8toSJIS.convert(string));
        }
        bufferedReader.close();
    }

    private void loadGaijiMap(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = convpat.matcher(string2);
            if (!matcher.find()) continue;
            int n = Integer.parseInt(matcher.group(1), 16);
            this.gaijiUniSet.add(n);
        }
        bufferedReader.close();
    }

    private void checkExtChSet(String[] stringArray) throws Exception {
        String string = "../../ebwin/GaijiMap.xml";
        if (stringArray.length >= 3) {
            string = stringArray[2].equals("arabic") ? "../../ebwin/ArabicGaijiMap.xml" : (stringArray[2].equals("sanskrit") ? "../../ebwin/SanskritGaijiMap.xml" : stringArray[2]);
        }
        this.loadGaijiMap(string);
        for (Character c : extChSet.toArray(new Character[0])) {
            char c2 = c.charValue();
            if (this.gaijiUniSet.contains(c2)) continue;
            String string2 = String.format("&#x%04X=%c is not in %s", c2, c, string);
            System.err.println("WARN: " + string2);
        }
    }

    public static void main(String[] stringArray) {
        ZephyrUtil.setShiftJisOuput();
        try {
            UTF8toSJIS uTF8toSJIS = new UTF8toSJIS();
            uTF8toSJIS.convert(stringArray);
            if (stringArray.length >= 2 && stringArray[1].equals("check")) {
                uTF8toSJIS.checkExtChSet(stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        UTF8toSJIS.addExtFix('\u2776', UTF8toSJIS.kuromarunum(1));
        UTF8toSJIS.addExtFix('\u2777', UTF8toSJIS.kuromarunum(2));
        UTF8toSJIS.addExtFix('\u2778', UTF8toSJIS.kuromarunum(3));
        UTF8toSJIS.addExtFix('\u2779', UTF8toSJIS.kuromarunum(4));
        UTF8toSJIS.addExtFix('\u277a', UTF8toSJIS.kuromarunum(5));
        UTF8toSJIS.addExtFix('\u277b', UTF8toSJIS.kuromarunum(6));
        UTF8toSJIS.addExtFix('\u277c', UTF8toSJIS.kuromarunum(7));
        UTF8toSJIS.addExtFix('\u277d', UTF8toSJIS.kuromarunum(8));
        UTF8toSJIS.addExtFix('\u277e', UTF8toSJIS.kuromarunum(9));
        UTF8toSJIS.addExtFix('\u277f', UTF8toSJIS.kuromarunum(10));
        UTF8toSJIS.addExtFix('\u278a', UTF8toSJIS.kuromarunum(1));
        UTF8toSJIS.addExtFix('\u278b', UTF8toSJIS.kuromarunum(2));
        UTF8toSJIS.addExtFix('\u278c', UTF8toSJIS.kuromarunum(3));
        UTF8toSJIS.addExtFix('\u278d', UTF8toSJIS.kuromarunum(4));
        UTF8toSJIS.addExtFix('\u278e', UTF8toSJIS.kuromarunum(5));
        UTF8toSJIS.addExtFix('\u278f', UTF8toSJIS.kuromarunum(6));
        UTF8toSJIS.addExtFix('\u2790', UTF8toSJIS.kuromarunum(7));
        UTF8toSJIS.addExtFix('\u2791', UTF8toSJIS.kuromarunum(8));
        UTF8toSJIS.addExtFix('\u2792', UTF8toSJIS.kuromarunum(9));
        UTF8toSJIS.addExtFix('\u2793', UTF8toSJIS.kuromarunum(10));
        UTF8toSJIS.addExtFix('\u24eb', UTF8toSJIS.kuromarunum(11));
        UTF8toSJIS.addExtFix('\u24ec', UTF8toSJIS.kuromarunum(12));
        UTF8toSJIS.addExtFix('\u24ed', UTF8toSJIS.kuromarunum(13));
        UTF8toSJIS.addExtFix('\u24ee', UTF8toSJIS.kuromarunum(14));
        UTF8toSJIS.addExtFix('\u24ef', UTF8toSJIS.kuromarunum(15));
        UTF8toSJIS.addExtFix('\u24f0', UTF8toSJIS.kuromarunum(16));
        UTF8toSJIS.addExtFix('\u24f1', UTF8toSJIS.kuromarunum(17));
        UTF8toSJIS.addExtFix('\u24f2', UTF8toSJIS.kuromarunum(18));
        UTF8toSJIS.addExtFix('\u24f3', UTF8toSJIS.kuromarunum(19));
        UTF8toSJIS.addExtFix('\u24f4', UTF8toSJIS.kuromarunum(20));
        UTF8toSJIS.addExtFix('\u2460', UTF8toSJIS.siromarunum(1));
        UTF8toSJIS.addExtFix('\u2461', UTF8toSJIS.siromarunum(2));
        UTF8toSJIS.addExtFix('\u2462', UTF8toSJIS.siromarunum(3));
        UTF8toSJIS.addExtFix('\u2463', UTF8toSJIS.siromarunum(4));
        UTF8toSJIS.addExtFix('\u2464', UTF8toSJIS.siromarunum(5));
        UTF8toSJIS.addExtFix('\u2465', UTF8toSJIS.siromarunum(6));
        UTF8toSJIS.addExtFix('\u2466', UTF8toSJIS.siromarunum(7));
        UTF8toSJIS.addExtFix('\u2467', UTF8toSJIS.siromarunum(8));
        UTF8toSJIS.addExtFix('\u2469', UTF8toSJIS.siromarunum(10));
        UTF8toSJIS.addExtFix('\u246a', UTF8toSJIS.siromarunum(11));
        UTF8toSJIS.addExtFix('\u2471', UTF8toSJIS.siromarunum(18));
        UTF8toSJIS.addExtFix('\u2474', UTF8toSJIS.parnum(1));
        UTF8toSJIS.addExtFix('\u2475', UTF8toSJIS.parnum(2));
        UTF8toSJIS.addExtFix('\u2476', UTF8toSJIS.parnum(3));
        UTF8toSJIS.addExtFix('\u2477', UTF8toSJIS.parnum(4));
        UTF8toSJIS.addExtFix('\u2478', UTF8toSJIS.parnum(5));
        UTF8toSJIS.addExtFix('\u2479', UTF8toSJIS.parnum(6));
        UTF8toSJIS.addExtFix('\u247a', UTF8toSJIS.parnum(7));
        UTF8toSJIS.addExtFixAsHex('\u3016');
        UTF8toSJIS.addExtFixAsHex('\u3017');
        UTF8toSJIS.addExtFixAsHex('\u25b7');
        String string = "\u3000\u3001\u3002\uff0c\uff0e\u30fb\uff1a\uff1b\uff1f\uff01\u309b\u309c\u00b4\uff40\u00a8\uff3e\uffe3\uff3f\u30fd\u30fe\u309d\u309e\u3003\u4edd\u3005\u3006\u3007\u30fc\u2015\u2010\uff0f\uff3c\uff5e\u2225\uff5c\u2026\u2025\u2018\u2019\u201c\u201d\uff08\uff09\u3014\u3015\uff3b\uff3d\uff5b\uff5d\u3008\u3009\u300a\u300b\u300c\u300d\u300e\u300f\u3010\u3011\uff0b\uff0d\u00b1\u00d7\u3000\u00f7\uff1d\u2260\uff1c\uff1e\u2266\u2267\u221e\u2234\u2642\u2640\u00b0\u2032\u2033\u2103\uffe5\uff04\uffe0\uffe1\uff05\uff03\uff06\uff0a\uff20\u00a7\u2606\u2605\u25cb\u25cf\u25ce\u25c7\u25c6\u25a1\u25a0\u25b3\u25b2\u25bd\u25bc\u203b\u3012\u2192\u2190\u2191\u2193\u3013\u30fb\u30fb\u30fb\u2208\u220b\u2286\u2287\u2282\u2283\u222a\u2229\u2227\u2228\uffe2\u21d2\u21d4\u2200\u2203\u30fb\u2220\u22a5\u2312\u2202\u2207\u2261\u2252\u226a\u226b\u221a\u223d\u221d\u2235\u222b\u222c\u212b\u2030\u266f\u266d\u266a\u2020\u2021\u00b6\u25ef";
        for (int i = 0; i < string.length(); ++i) {
            UTF8toSJIS.addExtFix(string.charAt(i));
        }
        UTF8toSJIS.addExtFix('\u2010');
        UTF8toSJIS.addExtFix('\u2015');
        UTF8toSJIS.addExtFix('\u2501');
        UTF8toSJIS.addExtFixAsHex('\u7006');
        UTF8toSJIS.addExtFix('\uff5f', "\u300a");
        UTF8toSJIS.addExtFix('\uff60', "\u300b");
        sjisOkSet = new HashSet();
        HEX = Pattern.compile("&#(x?)([0-9a-fA-F]+);");
        convpat = Pattern.compile(UNICODE_REGEXP);
    }
}

