/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDF2Jpeg {
    protected int TRIM_MARGIN = 10;
    private final ImageType IMAGE_TYPE;
    private final String FILE_POSTFIX;
    protected final String OUTPUT_TYPE;
    private final boolean ADD_FILENAME_PREFIX;
    protected static final int WHITE = -1;

    protected PDF2Jpeg() {
        this.IMAGE_TYPE = ImageType.RGB;
        this.FILE_POSTFIX = ".jpg";
        this.OUTPUT_TYPE = "jpeg";
        this.ADD_FILENAME_PREFIX = true;
    }

    protected PDF2Jpeg(ImageType imageType, String string, String string2, boolean bl) {
        this.IMAGE_TYPE = imageType;
        this.FILE_POSTFIX = string;
        this.OUTPUT_TYPE = string2;
        this.ADD_FILENAME_PREFIX = bl;
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
    }

    protected void convert(String string, String string2, String string3, int n, int n2, int n3, int n4) throws Exception {
        File file;
        File file2 = new File(string);
        if (!file2.exists()) {
            System.err.println(string + " \u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        if (this.ADD_FILENAME_PREFIX) {
            if (string3 == null) {
                string3 = file2.getName();
                string3 = string3.substring(0, string3.length() - 4);
            }
        } else if (string3 == null) {
            string3 = "";
        }
        if (!(file = new File(string2)).exists()) {
            file.mkdirs();
        }
        System.out.println(string + " \u5909\u63db\u958b\u59cb");
        PDDocument pDDocument = PDDocument.load((File)file2);
        PDFRenderer pDFRenderer = new PDFRenderer(pDDocument);
        int n5 = n;
        for (int i = n3 - 1; i < pDDocument.getNumberOfPages() && i < n4; ++i) {
            BufferedImage bufferedImage = pDFRenderer.renderImageWithDPI(i, (float)n2, this.IMAGE_TYPE);
            String string4 = n < 0 && pDDocument.getNumberOfPages() <= 1 ? string3 + this.FILE_POSTFIX : string3 + n5 + this.FILE_POSTFIX;
            File file3 = new File(file, string4);
            bufferedImage = this.trim(bufferedImage, this.TRIM_MARGIN);
            this.write(bufferedImage, this.OUTPUT_TYPE, file3);
            ++n5;
        }
        pDDocument.close();
        System.out.println();
        System.out.println(string + " \u5909\u63db\u7d42\u4e86");
    }

    protected void write(BufferedImage bufferedImage, String string, File file) throws Exception {
        ImageIO.write((RenderedImage)bufferedImage, this.OUTPUT_TYPE, file);
        System.out.print(file.getName() + " ");
    }

    protected void convert(String string, String string2, String string3, int n, int n2) throws Exception {
        this.convert(string, string2, string3, n, n2, 1, Integer.MAX_VALUE);
    }

    public BufferedImage trim(BufferedImage bufferedImage, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        for (n5 = 0; n5 < n7; ++n5) {
            if (this.isWhiteHorizon(bufferedImage, n5)) continue;
            if ((n5 -= n) >= 0) break;
            n5 = 0;
            break;
        }
        for (n4 = n7 - 1; n4 > n5; --n4) {
            if (this.isWhiteHorizon(bufferedImage, n4)) continue;
            if ((n4 += n) <= n7) break;
            n4 = n7;
            break;
        }
        for (n3 = 0; n3 < n6; ++n3) {
            if (this.isWhiteVertical(bufferedImage, n3)) continue;
            if ((n3 -= n) >= 0) break;
            n3 = 0;
            break;
        }
        for (n2 = n6 - 1; n2 > n3; --n2) {
            if (this.isWhiteVertical(bufferedImage, n2)) continue;
            if ((n2 += n) <= n6) break;
            n2 = n6;
            break;
        }
        return bufferedImage.getSubimage(n3, n5, n2 - n3, n4 - n5);
    }

    public BufferedImage trim(BufferedImage bufferedImage) {
        return this.trim(bufferedImage, this.TRIM_MARGIN);
    }

    protected boolean isWhiteHorizon(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(i, n) == -1) continue;
            return false;
        }
        return true;
    }

    protected boolean isWhiteVertical(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(n, i) == -1) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java PDF2Jpeg sample.pdf outDir [dpi] [startIdx] [outputPrefix]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 200;
        int n2 = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : -1;
        String string3 = stringArray.length > 4 ? stringArray[4] : null;
        PDF2Jpeg pDF2Jpeg = new PDF2Jpeg();
        pDF2Jpeg.convert(string, string2, string3, n2, n);
    }
}

