/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.taishukan.kangorin.MakeBodyHtml;

public class GaijiFinder {
    private final HashMap<String, String> jisx2chMap = new HashMap();
    private final HashMap<String, String> sjis2chMap = new HashMap();
    private final HashMap<String, String> hojo2chMap = new HashMap();
    private static final Pattern MIDASHI_OYA = Pattern.compile("<1F09><0002><1F41><0160>\u3010<([0-9A-F]+{4})>\u3011<1F61><1F0A>");
    private static final Pattern MIDASHI_KYUUJI = Pattern.compile("<1F09><0031><([0-9A-F]+{4})><1F0A>");
    private static final Pattern KANJI_CODE = Pattern.compile("<1F09><00(24|37)>(.+)<1F0A>");

    private void loadJISX(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\t");
            String string3 = stringArray[0];
            String string4 = stringArray[1].substring(0, 4) + stringArray[1].substring(5);
            String string5 = stringArray[2];
            this.jisx2chMap.put(string4, string3);
            this.sjis2chMap.put(string5, string3);
        }
        bufferedReader.close();
    }

    private void loadHojo(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\t");
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            this.hojo2chMap.put(string4, string3);
        }
        bufferedReader.close();
    }

    private void out(String string, String string2, String string3) {
        if (string3 != null) {
            System.out.println(string + "\t" + string2 + "\t" + string3 + "\t" + String.format("%04X", string3.codePointAt(0)));
        } else {
            System.out.println(string + "\t" + string2);
        }
    }

    private void parse(String string, String string2) {
        string2 = string2.replaceAll("<[0-9A-F]+{4}>", "");
        String[] stringArray = (string2 = MakeBodyHtml.zen2han(string2)).split("\\|");
        if (!stringArray[0].equals("\u2015")) {
            this.out(string, string2, this.jisx2chMap.get(stringArray[0]));
        } else if (!stringArray[1].equals("\u2015")) {
            this.out(string, string2, this.sjis2chMap.get(stringArray[1]));
        } else if (stringArray.length == 3 && !stringArray[2].equals("\u2015")) {
            this.out(string, string2, this.hojo2chMap.get(stringArray[2]));
        } else {
            this.out(string, string2, null);
        }
    }

    private void load(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        String string3 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher;
            if (string2.contains("<1F09><0002>") || string2.contains("<1F09><0031>") || string2.contains("<1F09><0090>")) {
                string3 = null;
            }
            if ((matcher = MIDASHI_OYA.matcher(string2)).find()) {
                string3 = matcher.group(1);
                continue;
            }
            matcher = MIDASHI_KYUUJI.matcher(string2);
            if (matcher.find()) {
                string3 = matcher.group(1);
                continue;
            }
            if (string3 == null || !(matcher = KANJI_CODE.matcher(string2)).find()) continue;
            this.parse(string3, matcher.group(2));
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) throws Exception {
        GaijiFinder gaijiFinder = new GaijiFinder();
        String string = stringArray.length > 0 ? stringArray[0] : "kangorin.txt";
        String string2 = stringArray.length > 1 ? stringArray[1] : "jisxtable.txt";
        String string3 = stringArray.length > 2 ? stringArray[2] : "hojotable.txt";
        gaijiFinder.loadJISX(string2);
        gaijiFinder.loadHojo(string3);
        gaijiFinder.load(string);
    }
}

