/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class SVG2BMP {
    private Float PIXEL = new Float(50.0f);

    private void svg2png(File file, File file2) throws Exception {
        PNGTranscoder pNGTranscoder = new PNGTranscoder();
        pNGTranscoder.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)Color.white);
        pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_INDEXED, (Object)new Integer(1));
        pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)this.PIXEL);
        pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)this.PIXEL);
        TranscoderInput transcoderInput = new TranscoderInput(file.toURI().toString());
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)fileOutputStream);
        pNGTranscoder.transcode(transcoderInput, transcoderOutput);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    private void svg2bmp(File file, File file2, File file3) throws Exception {
        System.out.println(file.getName());
        this.svg2png(file, file3);
        BufferedImage bufferedImage = ImageIO.read(file3);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, Color.WHITE, null);
        File file4 = new File(file2, file.getName().replace(".svg", ".bmp"));
        ImageIO.write((RenderedImage)bufferedImage2, "bmp", file4);
    }

    private void svgDir2bmpDir(File file, File file2) throws Exception {
        file2.mkdirs();
        File file3 = new File(file2, "tmp.png");
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            this.svg2bmp(new File(file, (String)object), file2, file3);
        }
        file3.delete();
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        SVG2BMP sVG2BMP = new SVG2BMP();
        String string2 = stringArray.length > 0 ? stringArray[0] : "svg";
        String string3 = string = stringArray.length > 1 ? stringArray[1] : "s";
        if (stringArray.length > 2) {
            sVG2BMP.PIXEL = new Float(Integer.parseInt(stringArray[2]));
        }
        sVG2BMP.svgDir2bmpDir(new File(string2), new File(string));
    }
}

