/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.taishukan.daikanwa.DKWWords;
import zephyr.taishukan.daikanwa.GetSVG;
import zephyr.taishukan.daikanwa.Jukugo;
import zephyr.util.MultiHashMap;
import zephyr.util.MultiLinkedHashMap;
import zephyr.util.MultiTreeMap;
import zephyr.util.ZephyrUtil;

public class MakeDKWHtml {
    private static final int UNKNOWN_BUSHUKAKU = 100000;
    private static final int UNKNOWN_SOUKAKU = 200000;
    private final MultiHashMap<String, String> uni2dkwMap = new MultiHashMap();
    private final HashMap<String, DKWEntry> dkwMap = new HashMap();
    static final int[] PAGE_OFFSET = new int[]{-1, 0, 1082, 2274, 3402, 4638, 5712, 6908, 8136, 9354, 10442, 11542, 12596};
    private static final int LAST_PAGE_VOL12 = 13757;
    private final LinkedList<String> urlList = new LinkedList();
    private final HashMap<Integer, String> bushuKanaMap = new HashMap();
    private final HashMap<String, String> uni2kakuMap = new HashMap();
    private static final Pattern SOUKAKU_LINE = Pattern.compile("^(DH?[0-9\\.]+)\t([0-9,]+)");
    private final HashMap<String, String> dkw2kakuMap = new HashMap();
    private static final Pattern JIKUN = Pattern.compile("^[\u3041-\u31ff\u30fb\u2026\uff08\uff09\uff5c]+");
    private static final Pattern JIKUN_NO = Pattern.compile("^([0-9]+)(\\.[12])?");
    private final MultiLinkedHashMap<String, String> jikun2dkwMap = new MultiLinkedHashMap();
    private final MultiHashMap<String, String> dkw2jikunMap = new MultiHashMap();
    private static final HashMap<Integer, String> bushuCharMap = new HashMap();
    private static final int MAX_SOUKAKU = 100;
    private final TreeMap<Integer, BushGroup> bushuGroupMap = new TreeMap();
    private DKWEntry prevEntry = null;

    private static File hasDkwImage(String string) {
        File file = new File("s", string + ".bmp");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    String dkwImage(String string) {
        File file = MakeDKWHtml.hasDkwImage(string);
        if (file != null) {
            return "<img src=\"s/" + file.getName() + "\"/>";
        }
        return null;
    }

    private String shortenDNo(String string) {
        if (string.length() > 0) {
            return string.replaceFirst("D0*", "").replaceFirst("H0*", "H").replace(".0", "");
        }
        return string;
    }

    private LinkedList<Integer> ucss2codes(LinkedList<String> linkedList) {
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        for (String string : linkedList) {
            try {
                linkedList2.add(Integer.parseInt(string, 16));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(string);
            }
        }
        return linkedList2;
    }

    private String ucss2txt(LinkedList<String> linkedList, boolean bl, boolean bl2, boolean bl3) {
        if (linkedList.size() == 0) {
            return "[\u4e0d\u660e]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.ucss2codes(linkedList).iterator();
        while (iterator.hasNext()) {
            Object object;
            boolean bl4;
            int n = (Integer)iterator.next();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" / ");
            }
            if (bl2) {
                stringBuilder.append("\u3010<b>");
            }
            if ((bl4 = ZephyrUtil.isValidJISCode(n)) && !bl3) {
                stringBuilder.append(Character.toChars(n));
            } else {
                object = new File("i", String.format("%05X.bmp", n));
                if (((File)object).exists()) {
                    stringBuilder.append("<img src=\"i/");
                    stringBuilder.append(((File)object).getName());
                    stringBuilder.append("\"/>");
                } else {
                    stringBuilder.append("[\u753b\u50cf\u306a\u3057]");
                }
                if (bl4 && bl3) {
                    stringBuilder.append("(");
                    stringBuilder.append(Character.toChars(n));
                    stringBuilder.append(")");
                }
            }
            if (bl2) {
                stringBuilder.append("</b>\u3011");
            }
            if (!bl) continue;
            object = String.format("U+%05X", n);
            stringBuilder.append(" ");
            stringBuilder.append((String)object);
            String string = this.uni2kakuMap.get(object);
            if (string == null) continue;
            stringBuilder.append("(");
            stringBuilder.append(string);
            stringBuilder.append("\u753b)");
        }
        return stringBuilder.toString();
    }

    private String ucss2txt(LinkedList<String> linkedList, boolean bl) {
        return this.ucss2txt(linkedList, bl, false, false);
    }

    private String ucss2txt(LinkedList<String> linkedList) {
        return this.ucss2txt(linkedList, true, false, false);
    }

    private String list2txt(LinkedList<String> linkedList) {
        if (linkedList.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : linkedList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private int[] fullpage2volpage(int n) {
        if (n > 13757) {
            System.err.println("\u30da\u30fc\u30b8\u756a\u53f7\u7570\u5e38\uff1a" + n);
        }
        for (int i = PAGE_OFFSET.length - 1; i >= 1; --i) {
            if (n < PAGE_OFFSET[i] + 1) continue;
            return new int[]{i, n - PAGE_OFFSET[i]};
        }
        return new int[]{-1, -1};
    }

    private int[] dkwNo2volNo(String string) {
        if (string.compareTo("D48903.0") >= 0) {
            return new int[]{13, 0};
        }
        if (string.compareTo("D42210.0") >= 0) {
            return new int[]{12, PAGE_OFFSET[12]};
        }
        if (string.compareTo("D38700.0") >= 0) {
            return new int[]{11, PAGE_OFFSET[11]};
        }
        if (string.compareTo("D32804.0") >= 0) {
            return new int[]{10, PAGE_OFFSET[10]};
        }
        if (string.compareTo("D28108.0") >= 0) {
            return new int[]{9, PAGE_OFFSET[9]};
        }
        if (string.compareTo("D22678.0") >= 0) {
            return new int[]{8, PAGE_OFFSET[8]};
        }
        if (string.compareTo("D17575.0") >= 0) {
            return new int[]{7, PAGE_OFFSET[7]};
        }
        if (string.compareTo("D14415.0") >= 0) {
            return new int[]{6, PAGE_OFFSET[6]};
        }
        if (string.compareTo("D11530.0") >= 0) {
            return new int[]{5, PAGE_OFFSET[5]};
        }
        if (string.compareTo("D07411.0") >= 0) {
            return new int[]{4, PAGE_OFFSET[4]};
        }
        if (string.compareTo("D04675.0") >= 0) {
            return new int[]{3, PAGE_OFFSET[3]};
        }
        if (string.compareTo("D01450.0") >= 0) {
            return new int[]{2, PAGE_OFFSET[2]};
        }
        if (string.compareTo("D00001.0") >= 0) {
            return new int[]{1, PAGE_OFFSET[1]};
        }
        System.err.println(string);
        System.exit(1);
        return new int[]{-1, -1};
    }

    private int[] dkwNo2volNo(DKWEntry dKWEntry) {
        if (dKWEntry.page.startsWith("DPH")) {
            return new int[]{15, 0};
        }
        if (dKWEntry.page.startsWith("DPX")) {
            return new int[]{13, 0};
        }
        if (dKWEntry.page.equals("DP?????")) {
            return new int[]{-1, -1};
        }
        return this.dkwNo2volNo(dKWEntry.no);
    }

    private String uni2jis(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.codePointAt(i);
            if (ZephyrUtil.isValidJISCode(n2)) {
                stringBuilder.append(Character.toChars(n2));
            } else {
                boolean bl;
                LinkedList linkedList = this.uni2dkwMap.getWithoutNull(String.format("U+%05X", n2));
                boolean bl2 = bl = linkedList.size() == 1 && n2 != n;
                if (bl) {
                    stringBuilder.append("<nobr><a href=\"#");
                    stringBuilder.append((String)linkedList.getFirst());
                    stringBuilder.append("\">\u2192");
                }
                stringBuilder.append("<img src=\"i/");
                stringBuilder.append(String.format("%05X.bmp", n2));
                stringBuilder.append("\"/>");
                if (bl) {
                    stringBuilder.append("</a></nobr>");
                } else if (linkedList.size() > 1) {
                    stringBuilder.append("[");
                    boolean bl3 = true;
                    for (String string2 : linkedList) {
                        if (bl3) {
                            bl3 = false;
                        } else {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append("<a href=\"#");
                        stringBuilder.append(string2);
                        stringBuilder.append("\">");
                        stringBuilder.append(this.shortenDNo(string2));
                        stringBuilder.append("</a>");
                    }
                    stringBuilder.append("]");
                }
            }
            if (n2 < 131072) continue;
            ++i;
        }
        return stringBuilder.toString();
    }

    private String uni2jis(String string) {
        return this.uni2jis(string, -1);
    }

    private String linkToNo(String string) {
        String string2 = this.dkwImage(string);
        if (string2 != null) {
            return "<a href=\"#" + string + "\">" + this.shortenDNo(string) + string2 + "</a>";
        }
        DKWEntry dKWEntry = this.dkwMap.get(string);
        if (dKWEntry != null) {
            return "<a href=\"#" + string + "\">" + this.shortenDNo(string) + this.ucss2txt(dKWEntry.ucsList, false, false, true) + "</a>";
        }
        return "<a href=\"#" + string + "\">" + this.shortenDNo(string) + "</a>";
    }

    private String makeEntryKey(DKWEntry dKWEntry, DKWWords dKWWords) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.ucss2codes(dKWEntry.ucsList).iterator();
        while (object.hasNext()) {
            n = (Integer)object.next();
            stringBuilder.append("<key>U+");
            stringBuilder.append(String.format("%05X", n));
            stringBuilder.append("</key>");
            if (!ZephyrUtil.isValidJISCode(n)) continue;
            stringBuilder.append("<key>");
            stringBuilder.append(Character.toChars(n));
            stringBuilder.append("</key>");
        }
        object = this.dkwNo2volNo(dKWEntry);
        n = 0;
        if (object[0] > 0) {
            int n2 = Integer.parseInt(dKWEntry.page.replaceFirst("DP[XH0]*", ""));
            n = n2 - object[1];
            stringBuilder.append("<key>");
            stringBuilder.append((int)object[0]);
            stringBuilder.append(".");
            stringBuilder.append(n);
            stringBuilder.append("</key>");
        }
        for (Jukugo jukugo : dKWWords.getJukugo(dKWEntry.no)) {
            if (n != jukugo.pageNo && jukugo.pageNo > 0 && (object = (Object)this.fullpage2volpage(jukugo.pageNo))[0] > 0) {
                stringBuilder.append("<key>");
                stringBuilder.append((int)object[0]);
                stringBuilder.append(".");
                if (object[1] != jukugo.pageNo) {
                    stringBuilder.append((int)object[1]);
                } else {
                    stringBuilder.append(jukugo.pageNo);
                }
                stringBuilder.append("</key>");
            }
            n = jukugo.pageNo;
        }
        return stringBuilder.toString();
    }

    private void addJikun(StringBuilder stringBuilder, DKWEntry dKWEntry) {
        LinkedList linkedList = this.dkw2jikunMap.getList(dKWEntry.no);
        if (linkedList == null) {
            return;
        }
        stringBuilder.append("<p>\u5b57\u8a13\uff1a");
        boolean bl = true;
        for (String string : linkedList) {
            if (!bl) {
                stringBuilder.append("\u3001");
            } else {
                bl = false;
            }
            stringBuilder.append(this.jikun2txt(string));
        }
        stringBuilder.append("</p>");
    }

    private void addGwLink(StringBuilder stringBuilder, DKWEntry dKWEntry) {
        this.urlList.clear();
        File file = MakeDKWHtml.hasDkwImage(dKWEntry.no);
        if (file != null) {
            this.urlList.add("http://glyphwiki.org/wiki/" + GetSVG.id2gwid(dKWEntry.no));
        }
        for (String string : dKWEntry.ucsList) {
            this.urlList.add("http://glyphwiki.org/wiki/u" + string.toLowerCase());
        }
        for (String string : this.urlList) {
            stringBuilder.append("<p>");
            stringBuilder.append(string);
            stringBuilder.append("</p>");
        }
    }

    private void output(BushGroup bushGroup, DKWEntry dKWEntry, DKWWords dKWWords) {
        int n;
        boolean bl;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<dt id=\"%s\">%s</dt>%s<dd>", dKWEntry.no, this.shortenDNo(dKWEntry.no), this.makeEntryKey(dKWEntry, dKWWords)));
        String string = this.dkwImage(dKWEntry.no);
        if (string != null) {
            stringBuilder.append("<p>\u3010");
            stringBuilder.append(string);
            stringBuilder.append("\u3011");
            if (dKWEntry.ucsList.size() > 0) {
                stringBuilder.append(String.format("\u3000%s", this.ucss2txt(dKWEntry.ucsList, true, true, true)));
            }
            stringBuilder.append("</p>");
        } else if (dKWEntry.ucsList.size() > 0) {
            stringBuilder.append(String.format("<p>%s</p>", this.ucss2txt(dKWEntry.ucsList, true, true, true)));
        }
        if (!dKWEntry.ids.isEmpty()) {
            stringBuilder.append(String.format("<p>IDS\uff1a %s</p>", this.uni2jis(dKWEntry.ids)));
        }
        String string2 = "<a href=\"#DR" + bushGroup.bushu().bushuNo + "\">\u2192" + this.ucss2txt(bushGroup.bushu().ucsList, false) + "</a>";
        if (dKWEntry.bushuKaku < 100000) {
            stringBuilder.append(String.format("<p>\u90e8\u9996\uff1a%s\u3001\u90e8\u9996\u5185\u753b\u6570\uff1a<a href=\"#DR%d.%d\">%d</a>", string2, bushGroup.bushu().bushuNo, dKWEntry.bushuKaku, dKWEntry.bushuKaku));
        } else {
            stringBuilder.append(String.format("<p>\u90e8\u9996\uff1a%s", string2));
        }
        String string3 = this.dkw2kakuMap.get(dKWEntry.no);
        if (string3 != null) {
            stringBuilder.append("\u3001\u7dcf\u753b\u6570\uff1a");
            stringBuilder.append(string3);
            stringBuilder.append("\u753b");
        }
        stringBuilder.append("</p>");
        int[] nArray = this.dkwNo2volNo(dKWEntry);
        if (nArray[0] > 0) {
            n2 = Integer.parseInt(dKWEntry.page.replaceFirst("DP[XH0]*", ""));
            stringBuilder.append("<p>");
            stringBuilder.append(nArray[0]);
            stringBuilder.append("\u5dfb\u3001");
            stringBuilder.append(n2);
            if (nArray[1] > 0) {
                stringBuilder.append("\uff08");
                stringBuilder.append(n2 - nArray[1]);
                stringBuilder.append("\uff09");
            }
            stringBuilder.append("\u9801");
            stringBuilder.append("</p>");
        }
        this.addJikun(stringBuilder, dKWEntry);
        this.addGwLink(stringBuilder, dKWEntry);
        n2 = !dKWEntry.duplicateNo.isEmpty() ? 1 : 0;
        boolean bl2 = bl = !dKWEntry.relNo.isEmpty();
        if (n2 != 0 || bl) {
            stringBuilder.append("<p>");
            if (n2 != 0) {
                stringBuilder.append(String.format("\u91cd\u8907\uff1a %s", this.linkToNo(dKWEntry.duplicateNo)));
            }
            if (bl) {
                if (n2 != 0) {
                    stringBuilder.append("\u3001");
                }
                stringBuilder.append(String.format("\u95a2\u9023\uff1a%s", this.linkToNo(dKWEntry.relNo)));
            }
            stringBuilder.append("</p>");
        }
        if (dKWEntry.otherUcsList.size() > 0) {
            stringBuilder.append(String.format("<p>\u7570\u4f53\u5b57\uff1a%s</p>", this.ucss2txt(dKWEntry.otherUcsList)));
        }
        if (dKWEntry.otherInfo.size() > 0) {
            stringBuilder.append(String.format("<p>\u8ffd\u8a18\uff1a%s</p>", this.list2txt(dKWEntry.otherInfo)));
        }
        int n3 = -1;
        if (dKWEntry.ucsList.size() == 1 && this.uni2dkwMap.getWithoutNull(String.format("U+%05X", n = Integer.parseInt(dKWEntry.ucsList.getFirst(), 16))).size() == 1) {
            n3 = n;
        }
        n = 0;
        for (Jukugo jukugo : dKWWords.getJukugo(dKWEntry.no)) {
            boolean bl3 = false;
            if (n != jukugo.pageNo) {
                bl3 = true;
                if (n != 0) {
                    stringBuilder.append("</p>");
                }
                stringBuilder.append("<p><b>[");
                if (jukugo.pageNo > 0) {
                    nArray = this.fullpage2volpage(jukugo.pageNo);
                    if (nArray[0] > 0) {
                        stringBuilder.append(nArray[0]);
                        stringBuilder.append("\u5dfb\u3001");
                        stringBuilder.append(jukugo.pageNo);
                        if (nArray[1] != jukugo.pageNo) {
                            stringBuilder.append("\uff08");
                            stringBuilder.append(nArray[1]);
                            stringBuilder.append("\uff09");
                        }
                        stringBuilder.append("\u9801");
                    } else {
                        stringBuilder.append(jukugo.pageNo);
                        stringBuilder.append("\u9801");
                    }
                } else {
                    stringBuilder.append("\u88dc\u5dfb\u3001");
                    stringBuilder.append(-jukugo.pageNo);
                    stringBuilder.append("\u9801");
                }
                stringBuilder.append("]</b> ");
                n = jukugo.pageNo;
            }
            if (jukugo.wordNo.contains("0.") || jukugo.wordNo.contains("5.")) {
                stringBuilder.append("\u3000<b>(");
                stringBuilder.append(jukugo.wordNo.replaceFirst("^H?0*", "").replace(".0", ""));
                stringBuilder.append(")</b>");
            } else if (!bl3) {
                stringBuilder.append("\u3000:");
            }
            stringBuilder.append("\u3000");
            String string4 = this.uni2jis(jukugo.word, n3);
            stringBuilder.append(string4);
            if (string4.contains("<")) continue;
            stringBuilder.append("<key>");
            stringBuilder.append(string4);
            stringBuilder.append("</key>");
        }
        if (n != 0) {
            stringBuilder.append("</p>");
        }
        stringBuilder.append("</dd>");
        System.out.println(stringBuilder.toString());
    }

    private void loadBushuKana(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\t");
            int n = Integer.parseInt(stringArray[0]);
            this.bushuKanaMap.put(n, stringArray[2]);
        }
        bufferedReader.close();
    }

    private String makeBushuKanaKey(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split("\u30fb")) {
            stringBuilder.append("<key type=\"\u304b\u306a\">");
            stringBuilder.append(string2);
            stringBuilder.append("</key>");
        }
        return stringBuilder.toString();
    }

    private void loadStrokes(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\t");
            if (!stringArray[0].startsWith("U+")) continue;
            String string3 = stringArray[0].length() == 6 ? "U+0" + stringArray[0].substring(2) : stringArray[0];
            this.uni2kakuMap.put(string3, stringArray[1]);
        }
        bufferedReader.close();
    }

    private void loadDKWStrokes(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = SOUKAKU_LINE.matcher(string2);
            if (!matcher.find()) continue;
            this.dkw2kakuMap.put(matcher.group(1), matcher.group(2));
        }
        bufferedReader.close();
    }

    private void loadJikunSakuin(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        String string3 = "";
        String string4 = "";
        HashSet<String> hashSet = new HashSet<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = JIKUN.matcher(string2);
            if (matcher.find()) {
                string3 = matcher.group();
                hashSet.clear();
                continue;
            }
            matcher = JIKUN_NO.matcher(string2);
            if (matcher.find()) {
                int n = Integer.parseInt(matcher.group(1));
                String string5 = matcher.group(2) == null ? String.format("D%05d.0", n) : String.format("D%05d%s", n, matcher.group(2));
                if (hashSet.contains(string5)) {
                    System.err.println("\u5b57\u8a13\u91cd\u8907\uff1a" + string4 + "\t" + string3 + "\t" + matcher.group());
                }
                this.jikun2dkwMap.put(string3, string5);
                this.dkw2jikunMap.put(string5, string3);
                hashSet.add(string5);
                continue;
            }
            if (!string2.startsWith("\uff20")) continue;
            string4 = string2;
        }
        bufferedReader.close();
        System.err.println("load " + this.jikun2dkwMap.keySet().size() + " jikun, " + this.jikun2dkwMap.size() + " entries");
    }

    private String bushuMenu(BushGroup bushGroup) {
        String string = bushuCharMap.get(bushGroup.bushu().bushuNo);
        if (string != null) {
            return "(" + string + ")";
        }
        string = this.ucss2txt(bushGroup.bushu().ucsList, false).replaceFirst(" /.+", "");
        if (string.contains(".bmp")) {
            System.err.println("\u90e8\u9996" + bushGroup.bushu().bushuNo + " \t" + string);
        }
        return string;
    }

    private void makeDKWLinkList(StringBuilder stringBuilder, Collection<DKWEntry> collection, boolean bl) {
        boolean bl2 = true;
        int n = 0;
        for (DKWEntry dKWEntry : collection) {
            Object object;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append("\u3000");
            }
            if (bl && ((LinkedList)(object = this.getSoukakuList(dKWEntry))).size() > 0 && ((LinkedList)object).getFirst() > n) {
                n = ((LinkedList)object).getFirst();
                stringBuilder.append("<b>[");
                stringBuilder.append(n);
                stringBuilder.append("\u753b]</b>\u3000");
            }
            stringBuilder.append("<nobr><a href=\"#");
            stringBuilder.append(dKWEntry.no);
            stringBuilder.append("\">\u2192");
            object = this.dkwImage(dKWEntry.no);
            if (object != null) {
                stringBuilder.append((String)object);
            } else {
                stringBuilder.append(this.ucss2txt(dKWEntry.ucsList, false, false, true));
            }
            stringBuilder.append("</a></nobr>");
        }
    }

    private void makeDKWLinkList(StringBuilder stringBuilder, Collection<DKWEntry> collection) {
        this.makeDKWLinkList(stringBuilder, collection, false);
    }

    private void output(BushGroup bushGroup, DKWWords dKWWords) {
        String string = this.bushuMenu(bushGroup);
        String string2 = this.bushuKanaMap.get(bushGroup.bushu().bushuNo);
        System.out.println("<h1 id=\"DR" + bushGroup.bushu().bushuNo + "\">" + string + "\u3010" + string2 + "\u3011</h1>");
        System.out.println(this.makeBushuKanaKey(string2));
        System.out.println("<p>\u90e8\u9996\u756a\u53f7\uff1a" + bushGroup.bushu().bushuNo + "</p>");
        System.out.print("<p>\u90e8\u9996\u5185\u753b\u6570\uff1a");
        for (Integer n : bushGroup.kanjiList.keySet()) {
            if (n != 100000) {
                System.out.printf("<a href=\"#DR%d.%d\">%d</a>\u3000", bushGroup.bushu().bushuNo, n, n);
                continue;
            }
            System.out.printf("<a href=\"#DR%d.%d\">\u4e0d\u660e</a>\u3000", bushGroup.bushu().bushuNo, n);
        }
        System.out.println("</p>");
        for (Integer n : bushGroup.kanjiList.keySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<h2 id=\"DR");
            stringBuilder.append(bushGroup.bushu().bushuNo);
            stringBuilder.append(".");
            stringBuilder.append(n);
            stringBuilder.append("\">");
            stringBuilder.append(string);
            stringBuilder.append("\u3000");
            if (n != 100000) {
                stringBuilder.append(n);
                stringBuilder.append("\u753b");
            } else {
                stringBuilder.append("\u753b\u6570\u4e0d\u660e");
            }
            stringBuilder.append("</h2>");
            for (String string3 : string2.split("\u30fb")) {
                stringBuilder.append("<key type=\"\u8868\u8a18\">");
                stringBuilder.append(string3);
                if (n != 100000) {
                    stringBuilder.append(n);
                    stringBuilder.append("\u753b</key>");
                    continue;
                }
                stringBuilder.append("\u753b\u6570\u4e0d\u660e</key>");
            }
            stringBuilder.append("<p>");
            this.makeDKWLinkList(stringBuilder, bushGroup.kanjiList.getList(n));
            stringBuilder.append("</p>");
            System.out.println(stringBuilder.toString());
        }
        for (Integer n : bushGroup.kanjiList.keySet()) {
            for (String[] stringArray : bushGroup.kanjiList.getList(n)) {
                this.output(bushGroup, (DKWEntry)stringArray, dKWWords);
            }
        }
    }

    private LinkedList<Integer> getSoukakuList(DKWEntry dKWEntry) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        String string = this.dkw2kakuMap.get(dKWEntry.no);
        if (string != null) {
            for (String string2 : string.split(",")) {
                linkedList.add(Integer.parseInt(string2));
            }
        } else {
            for (String string3 : dKWEntry.ucsList) {
                String string4 = string3.length() == 4 ? "U+0" + string3 : "U+" + string3;
                string = this.uni2kakuMap.get(string4);
                if (string == null) continue;
                for (String string5 : string.split(",")) {
                    linkedList.add(Integer.parseInt(string5));
                }
            }
        }
        return linkedList;
    }

    private void outputStrokes() {
        Object object;
        LinkedList<Integer> linkedList;
        TreeMap treeMap = new TreeMap();
        for (int i = 1; i <= 100; ++i) {
            treeMap.put(i, new MultiTreeMap());
        }
        treeMap.put(200000, new MultiTreeMap());
        for (BushGroup object2 : this.bushuGroupMap.values()) {
            int n = object2.bushu().bushuNo;
            for (Iterator iterator : object2.kanjiList.keySet()) {
                for (LinkedList<Object> linkedList2 : object2.kanjiList.getList((Integer)((Object)iterator))) {
                    linkedList = this.getSoukakuList((DKWEntry)((Object)linkedList2));
                    if (linkedList.size() > 0) {
                        object = linkedList.iterator();
                        while (object.hasNext()) {
                            int stringBuilder = (Integer)object.next();
                            MultiTreeMap multiTreeMap = (MultiTreeMap)treeMap.get(stringBuilder);
                            multiTreeMap.put(n, linkedList2);
                        }
                        continue;
                    }
                    ((MultiTreeMap)treeMap.get(200000)).put(n, linkedList2);
                }
            }
        }
        LinkedList linkedList3 = new LinkedList();
        linkedList3.addAll(treeMap.keySet());
        Collections.reverse(linkedList3);
        System.out.println("<h1>\u7dcf\u753b\u6570\u7d22\u5f15</h1>");
        for (Integer n : treeMap.keySet()) {
            LinkedList<Object> linkedList2;
            MultiTreeMap multiTreeMap = (MultiTreeMap)treeMap.get(n);
            if (multiTreeMap.size() == 0) continue;
            String string = "SK" + n;
            if (n != 200000) {
                System.out.println("<h2 id=\"" + (String)string + "\">" + n + "\u753b</h2>");
            } else {
                System.out.println("<h2 id=\"" + (String)string + "\">\u7dcf\u753b\u6570\u4e0d\u660e</h2>");
            }
            System.out.print("<p>");
            for (Object object2 : multiTreeMap.keySet()) {
                linkedList2 = multiTreeMap.getList(object2);
                if (linkedList2 == null) continue;
                linkedList = this.bushuGroupMap.get(object2);
                System.out.printf("<a href=\"#SK%d.%s\">%s</a>\u3000", n, object2, this.bushuMenu((BushGroup)((Object)linkedList)));
            }
            System.out.println("</p>");
            for (Object object2 : multiTreeMap.keySet()) {
                linkedList2 = multiTreeMap.getList(object2);
                if (linkedList2 == null) continue;
                linkedList = (String)string + "." + object2;
                object = this.bushuGroupMap.get(object2);
                if (n != 200000) {
                    System.out.println("<h3 id =\"" + (String)((Object)linkedList) + "\">" + n + "\u753b \u3000" + this.bushuMenu((BushGroup)object) + "</h3>");
                } else {
                    System.out.println("<h3 id =\"" + (String)((Object)linkedList) + "\">\u7dcf\u753b\u6570\u4e0d\u660e\u3000" + this.bushuMenu((BushGroup)object) + "</h3>");
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<p>");
                this.makeDKWLinkList(stringBuilder, linkedList2);
                Iterator<Object> iterator = linkedList3.iterator();
                while (iterator.hasNext()) {
                    Integer n2 = (Integer)iterator.next();
                    if (n2 >= n || ((MultiTreeMap)treeMap.get(n2)).size() <= 0) continue;
                    this.soukakuLink(stringBuilder, n2);
                    break;
                }
                this.soukakuLink(stringBuilder, n);
                for (Integer n2 : treeMap.keySet()) {
                    if (n2 <= n || ((MultiTreeMap)treeMap.get(n2)).size() <= 0) continue;
                    this.soukakuLink(stringBuilder, n2);
                    break;
                }
                stringBuilder.append("</p>");
                System.out.println(stringBuilder.toString());
            }
        }
    }

    private void makeJikunKanaKeys(LinkedList<String> linkedList, String string) {
        if (!string.contains("\uff08")) {
            linkedList.add(string);
        } else {
            linkedList.add(string.replaceAll("\uff08.+?\uff09", "").replace("\uff5c", ""));
            try {
                String string2 = string.replaceAll("\uff5c([^\uff08\uff09]+)\uff08(.+?)\uff09", "$2");
                string2 = string2.replaceAll("([^\uff08\uff09])\uff08(.+?)\uff09", "$2");
                linkedList.add(string2);
            }
            catch (Exception exception) {
                System.err.println(string);
                exception.printStackTrace();
            }
        }
    }

    private String jikun2txt(String string) {
        return string.replaceAll("(\uff08.+?\uff09)", "<sub>$1</sub>").replace("\uff5c", "");
    }

    private void makeJikunDt(StringBuilder stringBuilder, String string, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : string.split("\u30fb")) {
            this.makeJikunKanaKeys(linkedList, string2);
        }
        String string3 = this.jikun2txt(string);
        stringBuilder.append("<dt noindex=\"1\" title=\"");
        stringBuilder.append(string3);
        stringBuilder.append(" ");
        stringBuilder.append(n);
        stringBuilder.append("\">");
        stringBuilder.append(string3);
        stringBuilder.append("</dt>");
        for (String string4 : linkedList) {
            stringBuilder.append("<key type=\"\u304b\u306a\">");
            stringBuilder.append(string4);
            stringBuilder.append("</key>");
        }
    }

    private void outputJikun() {
        System.out.println("<h1>\u5b57\u8a13\u7d22\u5f15</h1>");
        LinkedList<DKWEntry> linkedList = new LinkedList<DKWEntry>();
        for (String string : this.jikun2dkwMap.keySet()) {
            linkedList.clear();
            for (String string2 : this.jikun2dkwMap.getList(string)) {
                DKWEntry dKWEntry = this.dkwMap.get(string2);
                if (dKWEntry != null) {
                    linkedList.add(dKWEntry);
                    continue;
                }
                System.err.println("\u5b57\u8a13\uff1aDKWNO\u4e0d\u6b63\uff1a" + string2);
                System.exit(1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.makeJikunDt(stringBuilder, string, linkedList.size());
            stringBuilder.append("<dd>");
            stringBuilder.append(linkedList.size());
            stringBuilder.append("<p>");
            boolean bl = linkedList.size() >= 30;
            this.makeDKWLinkList(stringBuilder, linkedList, bl);
            stringBuilder.append("</p></dd>");
            System.out.println(stringBuilder.toString());
        }
    }

    private void soukakuLink(StringBuilder stringBuilder, int n) {
        stringBuilder.append("\u3000\u3000<a href=\"#SK");
        stringBuilder.append(n);
        stringBuilder.append("\">\u2192");
        if (n != 200000) {
            stringBuilder.append(n);
            stringBuilder.append("\u753b\u4e00\u89a7");
        } else {
            stringBuilder.append("\u7dcf\u753b\u6570\u4e0d\u660e\u4e00\u89a7");
        }
        stringBuilder.append("</a>");
    }

    private BushGroup getBushGroup(DKWEntry dKWEntry) {
        BushGroup bushGroup = this.bushuGroupMap.get(dKWEntry.bushuNo);
        if (bushGroup == null) {
            bushGroup = new BushGroup();
            this.bushuGroupMap.put(dKWEntry.bushuNo, bushGroup);
            if (dKWEntry.bushuKaku != 0) {
                System.err.println("\u90e8\u9996\u756a\u53f7\u4e0d\u6b63\uff1f\u3000" + dKWEntry.no + " DR" + dKWEntry.bushuNo + " DS" + dKWEntry.bushuKaku);
            }
        }
        return bushGroup;
    }

    private void checkPrevious(DKWEntry dKWEntry) {
        if (this.prevEntry != null && !dKWEntry.page.endsWith("?") && !this.prevEntry.page.endsWith("?") && dKWEntry.page.compareTo(this.prevEntry.page) < 0) {
            System.err.println("\u30da\u30fc\u30b8\u756a\u53f7\uff1f\t" + dKWEntry.no + " " + dKWEntry.page);
        }
        if (dKWEntry.no.compareTo("D48903.0") >= 0 || !dKWEntry.no.endsWith(".0")) {
            return;
        }
        if (this.prevEntry != null && dKWEntry.bushuKaku > 0 && dKWEntry.bushuKaku < this.prevEntry.bushuKaku && this.prevEntry.bushuKaku != 100000) {
            System.err.println("\u90e8\u9996\u5185\u753b\u6570\uff1f\t" + dKWEntry.no + " DS" + dKWEntry.bushuKaku);
        }
        this.prevEntry = dKWEntry;
    }

    private void loadDashPages() throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(new File("dash-pages.txt"));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("[ \t]+");
            if (stringArray.length < 2) continue;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            DKWEntry dKWEntry = this.dkwMap.get(string2);
            if (dKWEntry != null) {
                dKWEntry.page = string3;
                continue;
            }
            System.err.println("\u30c0\u30c3\u30b7\u30e5\u30da\u30fc\u30b8\uff1a" + string2);
        }
        bufferedReader.close();
    }

    private void load(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        BushGroup bushGroup = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            DKWEntry dKWEntry = new DKWEntry(string2);
            if (this.dkwMap.containsKey(dKWEntry.no)) {
                System.err.println("\u89aa\u5b57\u756a\u53f7\u91cd\u8907\t" + string2);
            }
            this.dkwMap.put(dKWEntry.no, dKWEntry);
            bushGroup = this.getBushGroup(dKWEntry);
            bushGroup.add(dKWEntry);
            this.checkPrevious(dKWEntry);
        }
        bufferedReader.close();
        this.loadDashPages();
    }

    private void output(DKWWords dKWWords) {
        System.out.println("<html><body>");
        this.outputStrokes();
        for (BushGroup bushGroup : this.bushuGroupMap.values()) {
            this.output(bushGroup, dKWWords);
        }
        this.outputJikun();
        System.out.println("</body></html>");
    }

    private void outputJikunForCheck() {
        System.out.println("<html><body>");
        LinkedList<DKWEntry> linkedList = new LinkedList<DKWEntry>();
        for (String string : this.jikun2dkwMap.keySet()) {
            DKWEntry dKWEntry;
            Object object2;
            linkedList.clear();
            for (Object object2 : this.jikun2dkwMap.getList(string)) {
                dKWEntry = this.dkwMap.get(object2);
                if (dKWEntry != null) {
                    linkedList.add(dKWEntry);
                    continue;
                }
                System.err.println("\u5b57\u8a13\uff1aDKWNO\u4e0d\u6b63\uff1a" + (String)object2);
                System.exit(1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<p>");
            stringBuilder.append(string);
            stringBuilder.append("\u3000");
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                dKWEntry = (DKWEntry)object2.next();
                if (dKWEntry.ucsList.size() > 0) {
                    for (String string2 : dKWEntry.ucsList) {
                        stringBuilder.append("&#x");
                        stringBuilder.append(string2);
                        stringBuilder.append(";");
                    }
                    stringBuilder.append(" ");
                    continue;
                }
                stringBuilder.append("\u25a0 ");
            }
            stringBuilder.append("</p>");
            System.out.println(stringBuilder.toString());
        }
        System.out.println("</body></html>");
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "dkw2ucs.txt";
        String string2 = stringArray.length > 1 ? stringArray[1] : "dkw-words.txt";
        DKWWords dKWWords = new DKWWords(string2);
        MakeDKWHtml makeDKWHtml = new MakeDKWHtml();
        makeDKWHtml.loadBushuKana("bushukana.txt");
        makeDKWHtml.loadStrokes("ucs-strokes.txt");
        makeDKWHtml.loadDKWStrokes("soukaku.txt");
        makeDKWHtml.loadJikunSakuin("jikun-sakuin.txt");
        makeDKWHtml.load(string);
        makeDKWHtml.output(dKWWords);
    }

    static {
        bushuCharMap.put(2, "\uff5c");
        bushuCharMap.put(43, "\u5c22");
        bushuCharMap.put(44, "\u5c38");
        bushuCharMap.put(45, "\u5c6e");
        bushuCharMap.put(58, "\u30e8");
        bushuCharMap.put(63, "\u6238");
        bushuCharMap.put(104, "\u75c5*");
        bushuCharMap.put(114, "\u79b9*");
        bushuCharMap.put(124, "\u7fbd");
        bushuCharMap.put(162, "\u8fb7*");
        bushuCharMap.put(174, "\u9752*");
        bushuCharMap.put(200, "\u9ebb");
        bushuCharMap.put(201, "\u9ec4*");
        bushuCharMap.put(203, "\u9ed2*");
    }

    static class BushGroup {
        final MultiTreeMap<Integer, DKWEntry> kanjiList = new MultiTreeMap();

        BushGroup() {
        }

        DKWEntry bushu() {
            return (DKWEntry)this.kanjiList.getList(0).getFirst();
        }

        void add(DKWEntry dKWEntry) {
            this.kanjiList.put(dKWEntry.bushuKaku, dKWEntry);
        }
    }

    class DKWEntry {
        final String no;
        String page;
        final int bushuNo;
        final int bushuKaku;
        final LinkedList<String> ucsList = new LinkedList();
        String duplicateNo = "";
        String ids = "";
        String relNo = "";
        final LinkedList<String> otherUcsList = new LinkedList();
        final LinkedList<String> otherInfo = new LinkedList();

        DKWEntry(String string) {
            int n;
            String[] stringArray = string.trim().split(" ");
            if (stringArray.length < 4) {
                System.err.println("*** " + string);
                System.exit(1);
            }
            this.no = stringArray[0];
            this.bushuNo = Integer.parseInt(stringArray[1].replaceFirst("DR0*", ""));
            String string2 = stringArray[2].replaceFirst("DS0*", "");
            this.bushuKaku = string2.isEmpty() ? 0 : (string2.equals("??") ? 100000 : Integer.parseInt(string2));
            this.page = stringArray[3];
            for (n = 4; n < stringArray.length && stringArray[n].startsWith("U+"); ++n) {
                MakeDKWHtml.this.uni2dkwMap.put(stringArray[n], this.no);
                this.ucsList.add(stringArray[n].replaceFirst("U\\+0*", ""));
            }
            if (n == stringArray.length) {
                return;
            }
            if (stringArray[n].startsWith("D")) {
                this.duplicateNo = stringArray[n];
                ++n;
            }
            if (n == stringArray.length) {
                return;
            }
            if (stringArray[n].equals("#")) {
                ++n;
            }
            if (n == stringArray.length) {
                return;
            }
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("D")) {
                    this.relNo = stringArray[n];
                } else if (stringArray[n].startsWith("U+")) {
                    this.otherUcsList.add(stringArray[n].replaceFirst("U\\+0*", ""));
                } else if (stringArray[n].startsWith("missing") || stringArray[n].startsWith("removed") || stringArray[n].startsWith("moved") || stringArray[n].startsWith("changed") || stringArray[n].startsWith("added") || stringArray[n].startsWith("replaced")) {
                    this.otherInfo.add(stringArray[n]);
                } else {
                    this.ids = stringArray[n];
                }
                ++n;
            }
        }

        boolean isBushu() {
            return this.bushuKaku == 0;
        }
    }
}

