/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanshusha.accessdejp;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.sanshusha.accessdejp.BinaryFile;
import zephyr.sanshusha.accessdejp.Buffer;
import zephyr.sanshusha.accessdejp.Table1;
import zephyr.sanshusha.accessdejp.Table2;
import zephyr.sanshusha.accessdejp.TagDecoder;
import zephyr.sanshusha.accessdejp.Util;
import zephyr.util.ZephyrUtil;

public class DecodeRoboword4 {
    private final TagDecoder tagDecoder = new TagDecoder();
    private static final String SINGLE_REGEXP = "^<b>((<sub>.+?</sub> *)?(.+?))</b>\u3000?";
    private static final Pattern SINGLE = Pattern.compile("^<b>((<sub>.+?</sub> *)?(.+?))</b>\u3000?");
    private static final String LINE_REGEXP = "[^\n]+";
    private static final Pattern LINE = Pattern.compile("[^\n]+");
    private static final String MIDASHI_REGEXP = "(\u2026|\u2026?\uff3b.+?\uff3d)([^\uff3b\u3008]+)";
    private static final Pattern MIDASHI = Pattern.compile("(\u2026|\u2026?\uff3b.+?\uff3d)([^\uff3b\u3008]+)");
    private static final String MORPH_REGEXP = "<p>(.+?)</p>";
    private static final Pattern MORPH = Pattern.compile("<p>(.+?)</p>");
    private final HashMap<String, Integer> dtIdMap = new HashMap();
    private static final String REF_REGEXP = "\uff1c([^\u300c]+?)\u300c";
    private static final Pattern REF = Pattern.compile("\uff1c([^\u300c]+?)\u300c");
    private static final String PART_REGEXP = "\uff08([^\u306e\uff09]+?)\u306e.+?\uff09";
    private static final Pattern PART = Pattern.compile("\uff08([^\u306e\uff09]+?)\u306e.+?\uff09");
    private static final String REL_REGEXP = "\u2190([a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc]+)";
    private static final Pattern REL = Pattern.compile("\u2190([a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc]+)");
    private static final String DEWORD_REGEXP = "([a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\\|]+)";
    private static final Pattern DEWORD = Pattern.compile("([a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\\|]+)");

    private int decodeByLZ(byte[] byArray, int n, int n2, int n3, Buffer buffer) {
        int n4 = Table2.decode(Util.sbyte2int(byArray[n + 1])) + n2;
        int n5 = Table2.decode(Util.sbyte2int(byArray[n + 2])) + n3;
        int n6 = buffer.length() - n5;
        if (n6 < 0) {
            System.err.println("ignore outbase=" + n6);
            return 2;
        }
        for (int i = 0; i < n4; ++i) {
            int n7 = Util.sbyte2int(buffer.data[n6 + i]);
            buffer.add((byte)n7);
        }
        return 2;
    }

    private int decodeByte(byte[] byArray, int n, Buffer buffer) {
        int n2 = Util.sbyte2int(byArray[n]);
        int n3 = Table1.decode(n2);
        if (n3 > 0) {
            buffer.add((byte)n3);
            return 0;
        }
        int n4 = 0;
        switch (n2) {
            case 35: {
                buffer.add(buffer.getLeftByte(2, 0));
                break;
            }
            case 61: {
                byte by = buffer.getLeftByte(1, 0);
                buffer.add(by);
                buffer.add(by);
                buffer.add(by);
                break;
            }
            case 62: {
                buffer.add(buffer.getLeftByte(1, 3));
                break;
            }
            case 66: {
                buffer.add(buffer.getLeftByte(1, -1));
                break;
            }
            case 72: {
                buffer.add(buffer.getLeftByte(1, -3));
                break;
            }
            case 74: {
                byte by = buffer.getLeftByte(1, 0);
                buffer.add(by);
                buffer.add(by);
                break;
            }
            case 163: {
                buffer.add(buffer.getLeftByte(1, 0));
                break;
            }
            case 202: {
                buffer.add(buffer.getLeftByte(1, 2));
                break;
            }
            case 222: {
                buffer.add(buffer.getLeftByte(1, 1));
                break;
            }
            case 226: {
                buffer.add(buffer.getLeftByte(1, 0));
                break;
            }
            case 233: {
                buffer.add(buffer.getLeftByte(1, -2));
                break;
            }
            case 237: {
                if (Util.sbyte2int(byArray[n + 1]) == 202) {
                    buffer.add((byte)10);
                    n4 = 1;
                    break;
                }
                buffer.deleteLast();
                break;
            }
            case 41: {
                n4 = this.decodeByLZ(byArray, n, 0, -1, buffer);
                break;
            }
            case 111: {
                n4 = this.decodeByLZ(byArray, n, 0, -2, buffer);
                break;
            }
            case 120: {
                n4 = this.decodeByLZ(byArray, n, 0, 0, buffer);
                break;
            }
            case 235: {
                n4 = this.decodeByLZ(byArray, n, 1, 0, buffer);
                break;
            }
            case 224: 
            case 225: {
                buffer.add(byArray[n]);
                break;
            }
            case 37: 
            case 38: 
            case 50: 
            case 57: 
            case 166: 
            case 177: 
            case 203: 
            case 241: {
                buffer.add(byArray[n]);
                break;
            }
            default: {
                System.err.println("unknown byte: " + String.format("0x%X=%d", n2, n2));
            }
        }
        return n4;
    }

    private void decode(byte[] byArray, int n, Buffer buffer) {
        for (int i = 0; i < n; ++i) {
            int n2 = this.decodeByte(byArray, i, buffer);
            if (n2 <= 0) continue;
            i += n2;
        }
    }

    private int parseHeader(BinaryFile binaryFile) throws Exception {
        binaryFile.skip(896);
        int n = binaryFile.readInt();
        binaryFile.skip(20);
        int n2 = binaryFile.readInt();
        int n3 = n - 924;
        if (n3 > 0) {
            binaryFile.skip(n3);
        }
        return n2 - n;
    }

    private String makeHyokiKey(String string) {
        return "<key type=\"\u8868\u8a18\">" + string + "</key>";
    }

    private String makeKey(String string) {
        return this.makeHyokiKey(string);
    }

    private String fixMorphTable(String string) {
        int n = string.indexOf("<p>\u25c6\u6d3b\u7528\u8868<SUBSECTION/></p>");
        if (n < 0) {
            return string;
        }
        int n2 = string.indexOf("<SECTION/></p>", n += "<p>\u25c6\u6d3b\u7528\u8868<SUBSECTION/></p>".length());
        if (n2 < 0) {
            return string;
        }
        n2 += "<SECTION/></p>".length();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append("<indent val=\"2\"><p>");
        String string2 = string.substring(n, n2);
        Matcher matcher = MORPH.matcher(string2);
        boolean bl = true;
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        while (matcher.find()) {
            String string3 = matcher.group(1);
            if (bl) {
                bl = false;
            } else if (string3.startsWith("\uff08")) {
                if (n5 == 2) {
                    stringBuffer.append("</p><p>");
                } else {
                    stringBuffer.append("</p><indent val=\"2\"><p>");
                    n5 = 2;
                }
                n4 = 0;
            } else if (string3.startsWith("\u00b7")) {
                stringBuffer.append("</p><indent val=\"3\"><p>");
                n5 = 3;
                n4 = 0;
                string3 = "\u30fb" + string3.substring(1);
            } else {
                ++n4;
            }
            if (n4 >= 2) {
                stringBuffer.append(" / ");
            }
            stringBuffer.append(string3);
            if (n4 == 0) {
                stringBuffer.append(" ");
            }
            n3 = matcher.end();
        }
        if (n3 < string2.length()) {
            stringBuffer.append(string2.substring(n3));
        }
        stringBuffer.append("</p>");
        stringBuffer.append("<indent val=\"1\">");
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private String fixMarks(String string) {
        String[][] stringArray = new String[][]{{"\u2019", "'"}, {"\uff08\uff08", "\u300a"}, {"\uff09\uff09", "\u300b"}, {"\u300a\u82f1\uff09", "\uff08\u82f1 "}, {"\u2026", "\uff65\uff65\uff65"}, {"\ufffd", "\uff65"}, {"/\uff08", " / \uff08"}};
        String[][] stringArray2 = new String[][]{{"([\\.,;:!])([^ \\.])", "$1 $2"}};
        return ZephyrUtil.sed(string, stringArray, stringArray2);
    }

    private void addDtId(String string, int n) {
        String string2;
        if (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith("\uff08*\uff09")) {
            string = string.substring(0, string.length() - 3);
        } else if (string.startsWith("<sub>")) {
            int n2 = string.indexOf("</sub>");
            string = string.substring(n2 + 6).trim();
        }
        this.dtIdMap.put(string, n);
        String string3 = string.replace("\u00b7", "");
        if (!string3.equals(string)) {
            this.dtIdMap.put(string3, n);
        }
        if (!(string2 = string3.replace("|", "")).equals(string3)) {
            this.dtIdMap.put(string2, n);
        }
    }

    private int getDtId(String string) {
        Integer n = this.dtIdMap.get(string);
        if (n != null) {
            return n;
        }
        String string2 = string.replace("|", "");
        if (!string2.equals(string) && (n = this.dtIdMap.get(string2)) != null) {
            return n;
        }
        return -1;
    }

    private String htmlFormat(String string, int n, boolean bl) {
        Matcher matcher = SINGLE.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        String string2 = matcher.group(1);
        String string3 = string.substring(matcher.end());
        String string4 = "";
        if (matcher.group(2) != null) {
            string4 = string4 + this.makeKey(matcher.group(3));
        }
        if ((matcher = MIDASHI.matcher(string2)).find()) {
            string4 = string4 + this.makeKey(matcher.group(2));
        }
        string = "<dt id=\"" + n + "\">" + string2 + "</dt>" + string4 + "<dd>";
        this.addDtId(string2, n);
        string3 = this.fixMarks(string3);
        matcher = LINE.matcher(string3);
        int n2 = 1;
        while (matcher.find()) {
            String string5 = matcher.group();
            if (bl) {
                char c = Character.toLowerCase(string5.charAt(0));
                if ('a' <= c && c <= 'z' || string5.startsWith("<i>") || string5.startsWith("\u25b7")) {
                    if (n2 != 2) {
                        string = string + "<indent val=\"2\">";
                        n2 = 2;
                    }
                } else if (n2 != 1) {
                    string = string + "<indent val=\"1\">";
                    n2 = 1;
                }
            }
            string = string + "<p>" + string5 + "</p>";
        }
        string = this.fixMorphTable(string);
        return string + "</dd>";
    }

    private String addHref(String string, Pattern pattern) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            int n2 = this.getDtId(string2);
            if (n2 < 0) continue;
            stringBuffer.append(string.substring(n, matcher.start(1)));
            stringBuffer.append(String.format("<a href=\"#%d\">%s</a>", n2, string2));
            n = matcher.end(1);
        }
        if (n == 0) {
            return string;
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private String addRef(String string) {
        string = this.addHref(string, REF);
        string = this.addHref(string, PART);
        int n = (string = this.addHref(string, REL)).indexOf("\u25c6\u95a2\u9023\u8a9e<SUBSECTION/></p><indent val=\"2\"><p>");
        if (n > 0) {
            int n2 = string.indexOf("</p>", n += "\u25c6\u95a2\u9023\u8a9e<SUBSECTION/></p><indent val=\"2\"><p>".length());
            String string2 = this.addHref(string.substring(n, n2), DEWORD);
            string = string.substring(0, n) + string2 + string.substring(n2);
        }
        return string;
    }

    private String dropTags(String string) {
        String[][] stringArray = new String[][]{{"<SECTION/>", ""}, {"<SUBSECTION/>", ""}, {"<WAKU_START/>", ""}, {"<WAKU_END/>", ""}, {"<p></p>", ""}, {"<b></b>", ""}};
        return ZephyrUtil.sed(string, stringArray, null);
    }

    private void loadDic(String string) throws Exception {
        int n;
        BinaryFile binaryFile = new BinaryFile(string);
        byte[] byArray = new byte[32768];
        Buffer buffer = new Buffer();
        boolean bl = string.endsWith("sansygj.dic");
        int n2 = 0;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = this.parseHeader(binaryFile); i > 0; i -= 17 + n) {
            binaryFile.skip(1);
            n = binaryFile.readInt();
            binaryFile.skip(12);
            if (n <= 0 || n > byArray.length) {
                System.err.println("indexVol=" + n);
                break;
            }
            binaryFile.read(byArray, n);
            this.decode(byArray, n, buffer);
            String string2 = this.tagDecoder.decode(buffer.data, buffer.length());
            buffer.clear();
            linkedList.add(this.htmlFormat(string2, n2, bl));
            if (++n2 % 1000 != 0) continue;
            System.err.print(".");
        }
        System.out.println("<html><body>");
        for (String string2 : linkedList) {
            System.out.println(this.dropTags(this.addRef(string2)));
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println("done. " + n2 + " entries");
        TagDecoder.dumpUnknown();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            DecodeRoboword4 decodeRoboword4 = new DecodeRoboword4();
            try {
                ZephyrUtil.setUTF8Ouput();
                decodeRoboword4.loadDic(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java EncodeRoboWord4 SOME_DIR/robo4_file.dic");
        }
    }
}

