/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.util.PDFIndex;
import zephyr.obunsha.util.RefEntry;
import zephyr.util.ZephyrUtil;

public class PetitPDFRef
extends PDFIndex {
    private final HashMap<String, RefEntry> vbnMap = new HashMap();
    private static final Pattern SNY = Pattern.compile("<span class=['\"]sny['\"]>(.+?)</span>");
    private static final Pattern VBN = Pattern.compile("<span class=['\"]vbn['\"]>(.+?)</span>");

    @Override
    public void handleLine(String string, RefEntry refEntry) {
        if (string.equals("appendice-") && refEntry.title.matches("[0-9]+.+")) {
            String string2 = refEntry.title.replaceAll("[^0-9]+", "");
            this.vbnMap.put(string2, refEntry);
        }
    }

    private String handleSny(String string, String string2) {
        Matcher matcher = SNY.matcher(string2);
        int n = 0;
        StringBuilder stringBuilder = null;
        while (matcher.find()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2.substring(n, matcher.start()));
            stringBuilder.append(matcher.group());
            String string3 = matcher.group(1);
            for (RefEntry refEntry : this.entryMap.values()) {
                if (refEntry.title.length() < 2 || !string3.contains(refEntry.title) && !string3.contains(refEntry.key)) continue;
                for (String string4 : refEntry.jpgs) {
                    stringBuilder.append("\u3000<jpgref id=\"");
                    stringBuilder.append(string4);
                    stringBuilder.append("\"/>");
                }
            }
            n = matcher.end();
        }
        if (stringBuilder == null) {
            return string2;
        }
        if (n < string2.length()) {
            stringBuilder.append(string2.substring(n));
        }
        return stringBuilder.toString();
    }

    private String handleVbn(String string, String string2) {
        Matcher matcher = VBN.matcher(string2);
        int n = 0;
        StringBuilder stringBuilder = null;
        while (matcher.find()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2.substring(n, matcher.start()));
            stringBuilder.append("<span class='vbn'>");
            String string3 = matcher.group(1);
            string3 = ZephyrUtil.zen2num(string3);
            stringBuilder.append(string3);
            RefEntry refEntry = this.vbnMap.get(string3);
            if (refEntry != null) {
                for (String string4 : refEntry.jpgs) {
                    stringBuilder.append(" <jpgref id=\"");
                    stringBuilder.append(string4);
                    stringBuilder.append("\"/>");
                }
            } else {
                System.err.println(matcher.group());
            }
            stringBuilder.append("</span>");
            n = matcher.end();
        }
        if (stringBuilder == null) {
            return string2;
        }
        if (n < string2.length()) {
            stringBuilder.append(string2.substring(n));
        }
        return stringBuilder.toString();
    }

    private String handleWordRef(String string, String string2) {
        string2 = string2.replaceAll("<a [^<>]*onClick=\"searchItem\\('([0-9]+)'[^\"]*\">(.+?)</a>", "<a href=\"#$1\">$2</a>");
        return string2;
    }

    String makeRef(String string, String string2) {
        string2 = this.handleSny(string, string2);
        string2 = this.handleVbn(string, string2);
        string2 = this.handleWordRef(string, string2);
        return string2;
    }
}

