/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.kagakudoujin.kagakueigo.Gaiji;
import zephyr.kagakudoujin.kagakueigo.Util;
import zephyr.kagakudoujin.kagakueigo2.Util2;
import zephyr.util.ZephyrUtil;

public class KatuyouWriter {
    private final int version;
    private boolean katuyouEnKey = false;
    private boolean katuyouJpKey = false;
    private boolean katuKey;
    private static int nextId = 0;
    private final HashMap<String, Integer> jp2idMap = new HashMap();
    private final LinkedList<KEntry> entries = new LinkedList();
    private static final Pattern PART_HEAD = Pattern.compile("\u3000?(\u3014.+?\u3015) *");
    private static final HashMap<String, String> jprelMap = new HashMap();

    public KatuyouWriter(String[] stringArray, int n) {
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("k_enjpkey")) {
                this.katuyouEnKey = true;
                continue;
            }
            if (!string.equals("k_jpenkey")) continue;
            this.katuyouJpKey = true;
        }
        this.katuKey = this.katuyouEnKey || this.katuyouJpKey;
        this.version = n;
    }

    public void addEntry(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String string5) {
        KEntry kEntry = new KEntry(string, string2, string3, string4, stringArray, stringArray2, string5);
        if (!this.jp2idMap.containsKey(kEntry.jp)) {
            this.jp2idMap.put(kEntry.jp, kEntry.id);
        }
        this.entries.add(kEntry);
    }

    private String makeENKey(String[] stringArray, String[] stringArray2, String string) {
        if (stringArray == null || stringArray2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length == stringArray2.length) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.katuyouEnKey) {
                    Util2.appendKey(stringBuilder, "*", stringArray[i], stringArray2[i]);
                }
                if (!this.katuyouJpKey || stringArray2[i].equals(string)) continue;
                Util2.appendKey(stringBuilder, "*", stringArray2[i], stringArray[i]);
            }
        } else {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                if (!this.katuyouEnKey) continue;
                Util2.appendKey(stringBuilder, "*", stringArray[n], "{" + string + "}");
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (!this.katuyouJpKey || stringArray2[n].equals(string)) continue;
                Util2.appendKey(stringBuilder, "*", stringArray2[n], "{" + string + "}");
            }
        }
        return stringBuilder.toString();
    }

    private void parseSentences(StringBuilder stringBuilder, String string) {
        for (String string2 : string.split("\uff0f")) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            stringBuilder.append(ZephyrUtil.BR + "<p>- ");
            stringBuilder.append(string2);
            stringBuilder.append("</p>");
        }
    }

    private void parseValue(StringBuilder stringBuilder, String string) {
        Matcher matcher = PART_HEAD.matcher(string);
        int n = 0;
        while (matcher.find()) {
            if (n < matcher.start()) {
                this.parseSentences(stringBuilder, string.substring(n, matcher.start()));
            }
            stringBuilder.append(ZephyrUtil.BR + "<p><b>");
            stringBuilder.append(matcher.group(1));
            stringBuilder.append("</b></p>");
            n = matcher.end();
        }
        if (n < string.length()) {
            this.parseSentences(stringBuilder, string.substring(n));
        }
    }

    private void initForVer2() {
        this.jp2idMap.put("\u5f97(\u3048)\u308b", 306);
        this.jp2idMap.put("\u7403(\u305f\u307e)", 2193);
        this.jp2idMap.put("\u6570(\u304b\u305a)", 525);
        this.jp2idMap.put("\u7403(\u304d\u3085\u3046)", 785);
    }

    private String rel2href(String string, String string2) {
        Integer n = null;
        if (this.version == 2) {
            n = this.jp2idMap.get(string2);
        }
        if (n == null) {
            String string3 = jprelMap.get(string2);
            if (string3 == null) {
                string3 = string2;
            }
            n = this.jp2idMap.get(string3);
        }
        if (n == null) {
            System.err.println("\u95a2\u9023\u5148\u4e0d\u660e\uff1a" + string + " - " + string2);
            return string2;
        }
        return "<a href=\"#" + n + "\">" + string2 + "</a>";
    }

    private String rel2ref(String string, String string2) {
        String[] stringArray;
        string2 = string2.replaceAll("</?[KR]>", "");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray = string2.split("[\uff0c,] *")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.rel2href(string, string3));
        }
        return stringBuilder.toString();
    }

    private void out(int n, String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String string5) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<dt id=\"");
        stringBuilder.append(n);
        stringBuilder.append("\">*");
        stringBuilder.append(string);
        stringBuilder.append("\u3010");
        stringBuilder.append(string2);
        stringBuilder.append("\u3011</dt>");
        if (this.katuKey) {
            stringBuilder.append(this.makeENKey(stringArray, stringArray2, string));
        }
        stringBuilder.append("<dd>");
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(ZephyrUtil.BR + "<p>* ");
            stringBuilder.append(string3);
            stringBuilder.append("</p>");
        }
        if (string4 != null && string4.length() > 0) {
            this.parseValue(stringBuilder, string4);
        }
        if (stringArray != null && stringArray.length > 0) {
            stringBuilder.append(ZephyrUtil.BR + "<p><b>\u82f1</b> - ");
            Util2.numbering(stringBuilder, stringArray);
            stringBuilder.append("</p>");
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            stringBuilder.append(ZephyrUtil.BR + "<p><b>\u548c</b> - ");
            Util2.numbering(stringBuilder, stringArray2);
            stringBuilder.append("</p>");
        }
        if (string5 != null && string5.length() > 0) {
            stringBuilder.append(ZephyrUtil.BR + "<p><b>\u95a2\u9023</b> - ");
            stringBuilder.append(this.rel2ref(string, string5));
            stringBuilder.append("</p>");
        }
        stringBuilder.append("</dd>");
        String string6 = stringBuilder.toString();
        string6 = string6.replace("over the range 0 < <I>x</I> < 1.2", "over the range 0 &lt; <I>x</I> &lt; 1.2");
        string6 = Util.normalize(string6);
        string6 = Gaiji.convert(string6);
        System.out.println(string6);
    }

    public void out() {
        if (this.version == 2) {
            this.initForVer2();
        }
        System.out.println("<html><body>");
        for (KEntry kEntry : this.entries) {
            this.out(kEntry.id, kEntry.jp, kEntry.kana, kEntry.en, kEntry.enTxts, kEntry.enWords, kEntry.jpWords, kEntry.rel);
        }
        System.out.println("</body></html>");
        System.err.println(this.entries.size() + "\u9805\u76ee");
    }

    static /* synthetic */ int access$008() {
        return nextId++;
    }

    static {
        jprelMap.put("\u2026\u306b\u3064\u304d", "\u306b\u3064\u304d");
        jprelMap.put("\u5171\u540c", "\u5171\u540c\uff08\u5354\u540c\uff09");
        jprelMap.put("\u57fa\u6e96", "\u57fa\u6e96\uff08\u898f\u6e96\uff09");
        jprelMap.put("\u4e3b(\u304a\u3082)\u306b", "\u4e3b\u306b");
        jprelMap.put("\u4e3b(\u304a\u3082)\u306a", "\u4e3b\u306b");
        jprelMap.put("\u96f6(\u308c\u3044)", "\u96f6");
        jprelMap.put("\u753b\u5206", "\u753b\u5206\uff08\u30d5\u30e9\u30af\u30b7\u30e7\u30f3\uff09");
        jprelMap.put("\u6eb6\u51fa\u3000", "\u6eb6\u51fa");
        jprelMap.put("\u79fb\u52d5\u5ea6", "\u79fb\uff08\u6613\uff09\u52d5\u5ea6");
        jprelMap.put("\u6613\u52d5\u5ea6", "\u79fb\uff08\u6613\uff09\u52d5\u5ea6");
        jprelMap.put("\u6db2\u614b", "\u6db2\u4f53\uff08\u614b\uff09");
        jprelMap.put("\u6cb9(\u3042\u3076\u3089)", "\u6cb9");
        jprelMap.put("\u6b21\u7b2c\u306b", "\u3057\u3060\u3044\u306b");
        jprelMap.put("\u3076\u3093\u3074\u3064", "\u5206\u6ccc");
        jprelMap.put("\u3079\u30fc\u305f\u3057\u30fc\u3068", "\u03b2\u30b7\u30fc\u30c8");
        jprelMap.put("\u30d4\u30fc\u30a8\u30c3\u30c1", "pH");
    }

    private static class KEntry {
        private final int id = KatuyouWriter.access$008();
        private final String jp;
        private final String kana;
        private final String en;
        private final String enTxts;
        private final String rel;
        private final String[] enWords;
        private final String[] jpWords;

        KEntry(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String string5) {
            this.jp = KEntry.trim(string);
            this.kana = KEntry.trim(string2);
            this.en = KEntry.trim(string3);
            this.enTxts = KEntry.trim(string4);
            this.enWords = stringArray;
            this.jpWords = stringArray2;
            this.rel = KEntry.trim(string5);
        }

        private static String trim(String string) {
            return string != null ? string.trim() : null;
        }
    }
}

