package jp.oarts.pirka.core.util.check;

import java.io.Serializable;

public class CheckerItem implements Serializable {

	/** `FbNJ[ */
	public static final int MODE_CHECKER = 1;

	/** `FbN&e[ */
	public static final int MODE_CHECK_AND_TELLER = 2;

	/** `FbNu[J[ */
	public static final int MODE_BREAKER = 3;

	/** `FbN^[i[ */
	public static final int MODE_RETURNER = 4;

	/** u[J[ */
	public static final CheckerItem BREAKER = new CheckerItem(MODE_BREAKER);

	/** ^[i[ */
	public static final CheckerItem RETURNER = new CheckerItem(MODE_RETURNER);

	/** 샂[h */
	private int mode;

	/** tB[h */
	private String fieldName;

	/** `FbJ[ */
	private Checker[] checkers;

	/** `FbNe[ */
	private CheckAndTeller[] checkAndTellers;

	/** G[bZ[W */
	private String errorMessage;

	/** sJbZ[W */
	private PirkaMessage prikaMessage;

	/**
	 * RXgN^
	 * 
	 * @param mode
	 *            [h
	 */
	private CheckerItem(int mode) {
		this.mode = mode;
	}

	/**
	 * RXgN^
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param checkers
	 *            `FbJ[z
	 */
	public CheckerItem(String fieldName, Checker... checkers) {
		this(fieldName, "", checkers);
	}

	/**
	 * RXgN^
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param errorMessage
	 *            G[bZ[W
	 * @param checkers
	 *            `FbJ[z
	 */
	public CheckerItem(String fieldName, String errorMessage, Checker... checkers) {
		this.mode = MODE_CHECKER;
		this.fieldName = getBaseName(fieldName);
		this.errorMessage = errorMessage;
		this.checkers = checkers;
		this.checkAndTellers = null;
		this.prikaMessage = null;
	}

	/**
	 * RXgN^
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param prikaMessage
	 *            PirkabZ[W
	 * @param checkers
	 *            `FbJ[z
	 */
	public CheckerItem(String fieldName, PirkaMessage prikaMessage, Checker... checkers) {
		this.mode = MODE_CHECKER;
		this.fieldName = getBaseName(fieldName);
		this.errorMessage = null;
		this.checkers = checkers;
		this.checkAndTellers = null;
		this.prikaMessage = prikaMessage;
	}

	/**
	 * RXgN^
	 * 
	 * @param checkAndTellers
	 *            `FbNe[z
	 */
	public CheckerItem(CheckAndTeller... checkAndTellers) {
		this.mode = MODE_CHECK_AND_TELLER;
		this.fieldName = null;
		this.errorMessage = null;
		this.checkers = null;
		this.checkAndTellers = checkAndTellers;
		this.prikaMessage = null;
	}

	private String getBaseName(String name){
		int index = name.indexOf("$");
		if(index<0){
			return name;
		}
		return name.substring(0, index);
	}
	
	/**
	 * @return checkAndTellers ߂܂B
	 */
	public CheckAndTeller[] getCheckAndTellers() {
		return checkAndTellers;
	}

	/**
	 * @return checkers ߂܂B
	 */
	public Checker[] getCheckers() {
		return checkers;
	}

	/**
	 * @return errorMessage ߂܂B
	 */
	public String getErrorMessage() {
		return errorMessage;
	}

	/**
	 * @return fieldName ߂܂B
	 */
	public String getFieldName() {
		return fieldName;
	}

	/**
	 * @return mode ߂܂B
	 */
	public int getMode() {
		return mode;
	}

	/**
	 * @return prikaMessage ߂܂B
	 */
	public PirkaMessage getPrikaMessage() {
		return prikaMessage;
	}

}
