package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.util.field.FieldItem;

/**
 * INPUT#FILE^OvZbT[
 * 
 * @author ito
 * 
 */
public class InputFileProcesser extends CtrlProcesser {

	/**
	 * HTMLp[cXg̎^O̎qp[c̃^O鎞trueԂ
	 * 
	 * @return true=qp[c̃^O
	 */
	@Override
	public boolean isUseChild() {
		return false;
	}

	/**
	 * [v^O̎tureԂ
	 * 
	 * @return true=[v^O
	 */
	@Override
	public boolean isLoop() {
		return false;
	}

	/**
	 * XCb`^O̎tureԂ
	 * 
	 * @return true=XCb`^O
	 */
	public boolean isSwitch() {
		return false;
	}

	/**
	 * uEUœ͂sȂ^ÔƂrtueԂ
	 * 
	 * @return true=uEUœ
	 */
	@Override
	public boolean isInputCtrl() {
		return true;
	}

	/**
	 * uEU[̃ANVƂtureԂ
	 * 
	 * @return true=ANV
	 */
	@Override
	public boolean isActionCtrl() {
		return false;
	}

	/**
	 * O[sOsȂ^OiWI{^Ȃǁj̊evf̎tureԂ
	 * 
	 * @return true=O[sOvf
	 */
	public boolean isGroupItem() {
		return false;
	}

	/**
	 * `FbNsȂRg[̎tureԂ
	 * 
	 * @return true=`FbNsȂRg[
	 */
	public boolean isCheckCtrl() {
		return false;
	}

	/**
	 * tH[}bg\ȃRg[̎tureԂ
	 * 
	 * @return true=tH[}bg\ȃRg[
	 */
	public boolean isFormatCtrl() {
		return false;
	}

	/**
	 * f[^̃ZbgsȂ
	 * 
	 * @param data
	 */
	public void setValue(Object data, FieldItem fieldItem) {
		if (data == null || !(data instanceof String)) {
			throw new RuntimeException("w肳ꂽl̓Zbgł܂ StringIuWFNgZbgĂ");
		}

		fieldItem.setValue((String) data);
	}

	/**
	 * l͂
	 * 
	 * @param ctrl
	 *            Rg[
	 * @param list
	 *            ̃^OHTMLp[c̃Xg
	 */
	@Override
	public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
	}

	/**
	 * ^O쐬
	 * 
	 * @param ctrl
	 *            Rg[p[c
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param value
	 *            l
	 * @param checked
	 *            `FbNl
	 * @param windowBaseData
	 *            ʃf[^
	 * @param errorMessageManager
	 *            G[bZ[W}l[W[
	 * @param errorMessageStocker
	 *            G[bZ[WXgbJ[
	 * @param errorFlag
	 *            G[tO true=G[
	 * @param workMap
	 *            Ɨp}bv
	 * 
	 * @return 쐬ꂽ^O
	 */
	public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, //
			ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag, Map<String, Object> workMap) {

		Map<String, String> optionMap = ctrl.getOptionMap();
		if (errorFlag) {
			optionMap = changeStyle(errorMessageManager.getNgStyle(), optionMap);
		}
		StringBuilder sb = new StringBuilder();

		sb.append('<');
		sb.append(ctrl.getTagName());
		sb.append(createOptionString(ctrl.getTypeOption(), ctrl.getName() + loopSuffix, loopSuffix, value, ctrl.isSuffix(), optionMap));
		sb.append(">");
		return sb.toString();
	}

	/**
	 * NGXgi͌ʁjtB[hɃZbg
	 * 
	 * @param reqMap
	 *            NGXg}bv
	 * @param fieldName
	 *            TtBbNXttB[h
	 * @param fieldItem
	 *            tB[h
	 * @param values
	 *            l
	 */
	@Override
	public void setReq(Map<String, String[]> reqMap, String fieldName, FieldItem fieldItem, String[] values) {
		if (values != null) {

			if (values.length > 0 && values[0] != null) {
				fieldItem.setValue(values[0]);
			}
			if (values.length > 1 && values[1] != null) {
				long fileNo = 0;

				try {
					fileNo = Long.parseLong(values[1]);
				} catch (NumberFormatException e) {
					throw new RuntimeException("tBԍsł ", e);
				}
				fieldItem.setFileNo(fileNo);
			// 2009/07/08 G[`FbÑt@CAbv[hُIsC
			}else{
				fieldItem.setFileNo(0);
			}

		}
	}

}
