package jp.oarts.pirka.core.app;

import java.util.*;
import java.io.*;

import javax.servlet.http.HttpServletRequest;

import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.kernel.PirkaUploadManager;
import jp.oarts.pirka.core.util.converter.ReqCharacterConverter;

/**
 * NGXgp[XNX
 * 
 * @author ito
 * 
 */
public class ReqParser implements Serializable {

	private static final String MULTIPPART_STRING = "multipart/form-data";

	// private static final String AJAX_STRING = "application/x-www-form-urlencoded";

	private static final String CONTENT_DISPOSITION_HEAD = "content-disposition:";

	// /**
	// * HTTPNGXg͂NGXg}bvƃt@CԍXgɒli[
	// *
	// * @param req
	// * NGXg
	// * @param reqMap
	// * NGXg}bv
	// * @throws IOException
	// */
	// public static void parserAjax(HttpServletRequest req, Map<String, String[]> reqMap) throws IOException {
	// Enumeration en = req.getParameterNames();
	// while (en.hasMoreElements()) {
	// String name = (String) en.nextElement();
	// name = convertKanji(name);
	// String[] values = req.getParameterValues(name);
	// for (int i = 0; i < values.length; i++) {
	// values[i] = new String(values[i].getBytes("8859_1"), "UTF-8");
	// }
	// reqMap.put(name, values);
	// }
	// }

	// private static void parserAjax(InputStream is, Map<String, String[]> reqMap) throws IOException {
	// ByteArrayOutputStream baos = null;
	// try {
	// byte[] buff = new byte[2048];
	// baos = new ByteArrayOutputStream();
	// while (true) {
	// int len = is.read(buff);
	// if (len <= 0) {
	// break;
	// }
	// baos.write(buff, 0, len);
	// }
	// baos.flush();
	// System.out.println(new String(baos.toByteArray(), "UTF-8"));
	// } finally {
	// if (baos != null) {
	// baos.close();
	// }
	// if (is != null) {
	// is.close();
	// }
	// }
	//
	// }

	/**
	 * HTTPNGXg͂NGXg}bvƃt@CԍXgɒli[
	 * 
	 * @param req
	 *            NGXg
	 * @param reqMap
	 *            NGXg}bv
	 * @param fileNoList
	 *            t@CԍXg
	 * @throws IOException
	 */
	public static void parser(HttpServletRequest req, Map<String, String[]> reqMap, List<Long> fileNoList) throws IOException {

		EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
		ReqCharacterConverter charConverter = entryPoint.getReqCharacterConverter();

		String contentType = req.getContentType();

		if (contentType != null && contentType.toLowerCase().indexOf(MULTIPPART_STRING) >= 0) { // Abv[hñtH[}bg̔
			// }`p[giAbv[hj
			multipartParser(req.getInputStream(), reqMap, fileNoList, charConverter);
		} else {
			// VOp[g
			singleParser(req, reqMap, charConverter);
		}
	}

	/**
	 * VOp[g̉
	 * 
	 * @param req
	 *            NGXg
	 * @param reqMap
	 *            ͕ꂽp[^}bv
	 * @throws G[
	 */
	private static void singleParser(HttpServletRequest req, Map<String, String[]> reqMap, ReqCharacterConverter charConverte) throws IOException {

		Enumeration en = req.getParameterNames();
		while (en.hasMoreElements()) {
			String name = (String) en.nextElement();
			name = charConverte.convertKanji(name);
			String[] values = req.getParameterValues(name);
			for (int i = 0; i < values.length; i++) {
				values[i] = charConverte.convertKanji(values[i]);
			}
			reqMap.put(name, values);
		}

	}

	/**
	 * }`p[g̉
	 * 
	 * @param sis
	 *            CvbgXg[
	 * @param reqMap
	 *            ͕ꂽp[^}bv
	 * @throws G[
	 */
	private static void multipartParser(InputStream sis, Map<String, String[]> reqMap, List<Long> fileNoList, ReqCharacterConverter charConverte) throws IOException {

		// ȉ̃WbÑt@Co^Ɗϊƃ[v͌

		HashMap<String, List> paramMap = new HashMap<String, List>();
		BufferedOutputStream bos = null;
		byte[] tempBuff = new byte[1024];
		byte[] tempValue = new byte[256];
		int tempValueOffset = 0;
		boolean bFileOut = false;
		long fileNo = 0;

		try {
			try {
				do {
					// t@Cf[^̏I[p^[L[v
					byte[] boundaryTemp = readByteLine(sis, tempBuff);

					// t@Cf[^̏I[p^[0oCgƃf[^Ɣf
					if (boundaryTemp.length <= 0)
						throw new EOFException("I[p^[");

					// t@Cf[^̏I[p^[̐擪CRLFt
					byte[] boundary = new byte[boundaryTemp.length + 2];
					System.arraycopy(boundaryTemp, 0, boundary, 2, boundaryTemp.length);
					boundary[0] = 0x0d;
					boundary[1] = 0x0a;

					// }`p[g[v
					while (true) {
						bFileOut = false;

						// content-dispositionsǂ
						String contentDisposition = readStringLine(sis, tempBuff, charConverte);

						// content-dispositions̐擪CONTENT_DISPOSITION_HEAD`FbN
						if (contentDisposition.length() <= CONTENT_DISPOSITION_HEAD.length())
							throw new EOFException("CONTENT_DISPOSITION_HEADG[");
						if (!contentDisposition.substring(0, CONTENT_DISPOSITION_HEAD.length()).toLowerCase().equals(CONTENT_DISPOSITION_HEAD))
							throw new EOFException("CONTENT_DISPOSITION_HEADG[");

						// content-dispositionŝnameyfilenameo
						String name = "";
						String filename = "";

						contentDisposition = contentDisposition.substring(CONTENT_DISPOSITION_HEAD.length()).trim();
						StringTokenizer st = new StringTokenizer(contentDisposition, ";");
						int count = st.countTokens();
						if (count < 1)
							break;

						for (int i = 0; i < count; i++) {
							StringTokenizer st2 = new StringTokenizer(st.nextToken().trim(), "=");
							if (st2.countTokens() == 2) {
								String key = st2.nextToken().toLowerCase().trim();
								String value = st2.nextToken();
								if (key.equals("name")) {
									name = cutDC(value);
								} else if (key.equals("filename")) {
									filename = cutDC(value);
								}
							}
						}

						// content-dispositionŝnameyfilenameoȂƂ͒~
						bFileOut = false;
						bos = null;
						if (!filename.equals("")) {
							// System.out.println("filename="+filename) ;
							fileNo = PirkaUploadManager.getFileNo();
							fileNoList.add(fileNo);

							// File tempFile = PirkaUploadManager.getFile(fileNo);
							// bos = new BufferedOutputStream(new FileOutputStream(tempFile));
							
							bos = new BufferedOutputStream(PirkaUploadManager.getOutputStream(fileNo));

							bFileOut = true;
						}

						// s܂œǂݔ΂
						while (true) {
							if (readStringLine(sis, tempBuff, charConverte).equals(""))
								break;
						}

						tempValueOffset = 0;
						int offset = 0;
						int length = 0;
						long outCount = 0;
						while (true) {
							int readCount = sis.read(tempBuff, offset++, 1);
							if (readCount <= 0) {
								throw new EOFException("f[^ǂݎ蒆EOF");
							}
							if (offset >= boundary.length) {
								if (checkEnd(tempBuff, offset - boundary.length, boundary) == true) {
									break;
								} else {
									if (bFileOut == true) {
										if (bos != null) {
											bos.write(tempBuff, offset - boundary.length, 1);
											outCount++;
										}
									} else {
										if (tempValueOffset < tempValue.length) {
											tempValue[tempValueOffset++] = tempBuff[offset - boundary.length];
										} else {
											byte[] t = tempValue;
											tempValue = new byte[t.length + 100];
											System.arraycopy(t, 0, tempValue, 0, t.length);
											tempValue[tempValueOffset++] = tempBuff[offset - boundary.length];
										}
									}
								}

								if (offset >= tempBuff.length) {
									System.arraycopy(tempBuff, offset - boundary.length + 1, tempBuff, 0, boundary.length - 1);
									offset = boundary.length - 1;
								}
							}
						}
						if (bFileOut) {
							if (bos != null) {
								bos.flush();
								bos.close();
								bos = null;
							}
							setParamNoConvertKanji(name, filename, paramMap);
							// setParam(name, "" + fileNo, paramMap);
							setParamNoConvertKanji(name, "" + fileNo, paramMap);
						} else {
							byte[] tempByte = new byte[tempValueOffset];
							System.arraycopy(tempValue, 0, tempByte, 0, tempValueOffset);
							// paramMap.put(name, new String(tempByte, "JISAutoDetect")) ;
							// setParam(name, new String(tempByte, "JISAutoDetect")) ;
							setParam(name, tempByte, paramMap, charConverte);
						}
						// Skip one line
						readStringLine(sis, tempBuff, charConverte);
					}
				} while (false);
			} catch (EOFException e) {
			} catch (IOException e) {
				throw e;
			} finally {
				sis.close();
			}
		} finally {
			if (bos != null) {
				bos.close();
				bos = null;
				throw new IOException("}`p[T[̉͂Ɏs܂ Ytt@CN[YĂ܂");
			}
		}
		for (String key : paramMap.keySet()) {
			reqMap.put(key, (String[]) paramMap.get(key).toArray(new String[0]));
		}
	}

	/**
	 * w肳ꂽT[ubgCvbgXg[CRLF܂ł̃f[^ǂݍށB ACRLFƃobt@Ŏw肳ꂽ̈撷܂ő݂ȂƂ͗̈撷܂łƂB
	 * 
	 * @param is
	 *            T[ubgCvbgXg[
	 * @param tempBuff
	 *            ƃobt@
	 * @return ǂݍ񂾗̈iAǂݍ܂ȂɃXg[ɂȂnullԂj
	 */
	private static byte[] readByteLine(InputStream is, byte[] tempBuff) throws IOException {
		int offset = 0;
		int mode = 0;
		while (true) {
			if (offset >= tempBuff.length) {
				break;
			}
			if (is.read(tempBuff, offset, 1) < 1) {
				break;
			}

			byte byteData = tempBuff[offset++];
			if (byteData == 0x0d) {
				mode = 1;
			} else if (byteData == 0x0a && mode == 1) {
				mode = 2;
				break;
			} else {
				mode = 0;
			}
		}
		offset -= mode;
		if (offset <= 0) {
			if (mode != 2) {
				throw new EOFException("eof");
			} else {
				return new byte[0];
			}
		}

		byte[] buff = new byte[offset];
		System.arraycopy(tempBuff, 0, buff, 0, offset);

		return buff;
	}

	/**
	 * w肳ꂽT[ubgCvbgXg[CRLF܂ł̃f[^ǂݍށB ACRLFƃobt@Ŏw肳ꂽ̈撷܂ő݂ȂƂ͗̈撷܂łƂB
	 * 
	 * @param is
	 *            T[ubgCvbgXg[
	 * @param tempBuff
	 *            ƃobt@
	 * @return ǂݍ񂾗̈StringiAǂݍ܂ȂɃXg[ɂȂnullԂj
	 */
	private static String readStringLine(InputStream is, byte[] tempBuff, ReqCharacterConverter charConverte) throws IOException {
		byte[] buff = readByteLine(is, tempBuff);

		if (buff == null) {
			return null;
		}
		return charConverte.convertKanji(buff);
	}

	/**
	 * w肳ꂽobt@̃ItZbgʒu̒lrobt@ƓrB
	 * 
	 * @param buff
	 *            obt@
	 * @param offset
	 *            obt@̃ItZbg
	 * @param checkData
	 *            robt@
	 * @return true=
	 */
	private static boolean checkEnd(byte[] buff, int offset, byte[] checkData) {
		for (int i = 0; i < checkData.length; i++) {
			if (buff[offset + i] != checkData[i])
				return false;
		}

		return true;
	}

	/**
	 * w肳ꂽ񂪃_uR[e[VɈ͂܂Ă炻폜B
	 * 
	 * @param str
	 *            
	 * @return 폜ꂽ
	 */
	private static String cutDC(String str) {
		if (str == null)
			return null;

		if (str.equals("\"\""))
			return "";

		if (str.length() > 1) {
			if (str.substring(0, 1).equals("\"")) {
				str = str.substring(1);
			}
		}
		if (str.length() > 1) {
			if (str.substring(str.length() - 1).equals("\"")) {
				str = str.substring(0, str.length() - 1);
			}
		}

		return str;
	}

	/**
	 * uploadp[^̃t@C肾B
	 * 
	 * @param str
	 *            
	 * @return 폜ꂽ
	 */
	private String cutFileName(String str) {
		if (str == null)
			return null;

		str = cutDC(str);

		int idx;
		idx = str.lastIndexOf("\\");
		if ((idx + 1) < str.length()) {
			str = str.substring(idx + 1);
		}

		idx = str.lastIndexOf("/");
		if ((idx + 1) < str.length()) {
			str = str.substring(idx + 1);
		}

		return str;
	}

	/**
	 * p[^̒ǉ
	 * 
	 * @param key
	 *            L[
	 * @param value
	 *            o^l
	 */
	private static void setParam(String key, byte[] value, HashMap<String, List> paramMap, ReqCharacterConverter charConverte) {
		List paramList = (List) paramMap.get(key);
		if (paramList == null) {
			paramList = new LinkedList();
			paramMap.put(key, paramList);
		}
		paramList.add(charConverte.convertKanji(value));
	}

	// /**
	// * p[^̒ǉ
	// *
	// * @param key
	// * L[
	// * @param value
	// * o^l
	// */
	// private static void setParam(String key, String value, HashMap<String, List> paramMap) {
	// // System.out.println("setParam "+key+","+value) ;
	// List paramList = (List) paramMap.get(key);
	// if (paramList == null) {
	// paramList = new LinkedList();
	// paramMap.put(key, paramList);
	// }
	// paramList.add(convertKanji(value));
	// }

	/**
	 * p[^̒ǉ
	 * 
	 * @param key
	 *            L[
	 * @param value
	 *            o^l
	 */
	private static void setParamNoConvertKanji(String key, String value, HashMap<String, List> paramMap) {
		// System.out.println("setParam "+key+","+value) ;
		List paramList = (List) paramMap.get(key);
		if (paramList == null) {
			paramList = new LinkedList();
			paramMap.put(key, paramList);
		}
		paramList.add(value);
	}
}
