/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: thread.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<pthread.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<arpa/inet.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	"common.h"

pthread_mutex_t accept_lock = PTHREAD_MUTEX_INITIALIZER;
pthread_t       commander = 0;
struct m_thread **pool = NULL;

int             init_thread_struct(const int max);
void           *thread_main(void *arg);
void           *commander_main(void *arg);

int 
create_thread_pool(void)
{
	int             max, n, ret;

	LOG_DEBUG("Initializing thread control area ...");
	max = atoi(ini_refer_value_by_name(ini, NULL, "max_connection"));
	if (init_thread_struct(max))
	{
		goto ERROR;
	}
	LOG_DEBUG("Creating %d thread pools ...", max);
	for (n = 0; n < max; n++)
	{
		ret = pthread_create(&pool[n]->tid, NULL, &thread_main, pool[n]);
		if (ret != 0)
		{
			goto ERROR;
		}
	}

	return (0);
ERROR:
	LOG_DEBUG("Failed");
	return (1);
}

int 
init_thread_struct(const int max)
{
	int             n;

	pool = (struct m_thread **) calloc(max + 1, sizeof(struct m_thread *));
	if (!pool)
	{
		goto ERROR;
	}
	pool[max] = NULL;

	for (n = 0; n < max; n++)
	{
		pool[n] = (struct m_thread *) calloc(1, sizeof(struct m_thread));
		pool[n]->soc = -1;
	}

	return (0);
ERROR:
	return (1);
}

void           *
thread_main(void *arg)
{
	int             len;
	int             accept_soc;
	struct sockaddr_in sin;
	struct m_thread *th = (struct m_thread *) arg;
	int             err;
	cmd_t          *cmd;

	mask_signal();

	fprintf(stderr, "[%u] > Hello, World\n", (int) th->tid);

	len = sizeof(sin);

	while (1)
	{
		pthread_mutex_lock(&accept_lock);

		accept_soc = accept(listen_soc, (struct sockaddr *) & sin, (socklen_t *) & len);

		pthread_mutex_unlock(&accept_lock);

		if (accept_soc < 0)
		{
			break;
		}
		th->soc = accept_soc;
		th->addr = strdup(inet_ntoa(sin.sin_addr));
		th->port = ntohs(sin.sin_port);

		th->list = cmdlist_create();

		while (1)
		{
			sleep(1);
			cmd = cmdlist_dequeue(th->list);
			if (cmd)
			{
				err = cmd_write(th->soc, cmd);
				if (err)
				{
					break;
				}
				cmd_destroy(cmd);
			}
		}

		shutdown(th->soc, SHUT_WR);
		close(th->soc);
		th->soc = -1;

		cmdlist_destroy(th->list);
		th->list = NULL;

		free(th->addr);
	}

	fprintf(stderr, "[%u] > Cya World\n", (int) th->tid);

	th->tid = 0;

	return (NULL);
}

int 
create_commander(void)
{
	int             ret;

	LOG_DEBUG("Creating Commander ...");

	ret = pthread_create(&commander, NULL, &commander_main, NULL);
	if (ret != 0)
	{
		goto ERROR;
	}
	return (0);
ERROR:
	LOG_DEBUG("Failed");
	return (1);
}


void           *
commander_main(void *arg)
{
	cmd_t          *cmd = NULL;
	char            buf[32];
	int             n, type;
	int             err;

	while (1)
	{
		fprintf(stderr,
			"\n" \
			"    1. Start Attack   |   2. Stop Attack\n" \
			"    3. Pause Attack   |   4. Resume Attack\n" \
			"    5. Data           |   6. Config\n" \
			"    7. Scenario\n" \
			" > ");

		memset(buf, 0, sizeof(buf));
		fgets(buf, sizeof(buf - 1), stdin);

		type = *buf & 0x0F;

		cmd = cmd_create();

		err = cmd_set_type(cmd, type);
		if (err)
		{
			cmd_destroy(cmd);
			continue;
		}
		if (type > 4)
		{
			err = cmd_set_body(cmd, "test data", 9);
			if (err)
			{
				cmd_destroy(cmd);
				continue;
			}
		}
		for (n = 0; pool[n]; n++)
		{
			if (pool[n]->soc != -1)
			{
				err = cmdlist_queue(pool[n]->list, cmd);
				fprintf(stderr, "queue [%u] %s\n", (int) pool[n]->tid, err ? "failed" : "success");
			}
		}

		cmd_destroy(cmd);
	}
}
