/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: piranhad.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<errno.h>
#include	<string.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/socket.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/mman.h>
#include	<fcntl.h>
#include	<netdb.h>
#include	"common.h"

ini_t          *ini = NULL;
log_t          *dlog = NULL;
int             dsoc = -1;

ini_t          *init_piranhad_ini(const char *path);
log_t          *init_piranhad_log(void);
int             connect_to_manager(void);

int 
main(int argc, char *argv[])
{
	cmd_t          *cmd = NULL;
	int             err;

	ini = init_piranhad_ini(PIRANHAD_INI_PATH);
	if (!ini)
	{
		goto ERROR;
	}
	dlog = init_piranhad_log();
	if (!dlog)
	{
		goto ERROR;
	}
	dsoc = connect_to_manager();
	if (dsoc == -1)
	{
		goto ERROR;
	}
	/* int	 len; */
	/* char	*body; */

	while (1)
	{
		cmd = cmd_read(dsoc);

		if (!cmd)
		{
			continue;
		}
		switch (cmd_get_type(cmd))
		{
		case CMD_TYPE_START:
			err = proc_start(cmd);
			break;
		case CMD_TYPE_STOP:
			err = proc_stop(cmd);
			break;
		case CMD_TYPE_PAUSE:
			err = proc_pause(cmd);
			break;
		case CMD_TYPE_RESUME:
			err = proc_resume(cmd);
			break;
		case CMD_TYPE_DATA:
			err = proc_data(cmd);
			break;
		case CMD_TYPE_CONFIG:
			err = proc_config(cmd);
			break;
		case CMD_TYPE_SCENARIO:
			err = proc_scenario(cmd);
			break;
		}

		fprintf(stderr, "command: 0x%02x -> %s\n",
			cmd_get_type(cmd), err ? "failed" : "success");

		/*
		 * fprintf(stderr, "Type           -> 0x%02x\n",
		 * cmd_get_type(cmd));
		 */
		/*
		 * fprintf(stderr, "Content-Length -> %s\n",
		 * cmd_refer_header_value_by_name(cmd, "Content-Length"));
		 */

		/* len = cmd_get_body(cmd, &body); */

		/* if(len) */
		/* { */
		/* debug_print_hex(stdout, body, len); */

		/* free(body); */

		/* body = NULL; */
		/* } */

		cmd_destroy(cmd);

		cmd = NULL;
	}

ERROR:
	finalize_all();
	return (0);
}

ini_t          *
init_piranhad_ini(const char *path)
{
	return (ini_load(path, "\x0a", "=", '#'));
}

log_t          *
init_piranhad_log(void)
{
	char           *path, *level;

	path = ini_refer_value_by_name(ini, NULL, "log_path");
	level = ini_refer_value_by_name(ini, NULL, "log_level");

	dlog = log_open(path);
	if (!dlog)
	{
		goto ERROR;
	}
	LOG_DEBUG("----> Start Client");

	return (dlog);
ERROR:
	return (NULL);
}

int 
connect_to_manager(void)
{
	int             ret, soc = -1;
	char           *addr, *port;
	struct addrinfo hints, *res = NULL;

	addr = ini_refer_value_by_name(ini, NULL, "server_addr");
	port = ini_refer_value_by_name(ini, NULL, "server_port");

	if (!addr || !port)
	{
		LOG_ERR("server_addr: %s", addr);
		LOG_ERR("server_port: %s", port);
		goto ERROR;
	}
	memset(&hints, 0, sizeof(hints));
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_family = AF_INET;
	if (getaddrinfo(addr, port, &hints, &res) != 0)
	{
		LOG_ERR("%s", strerror(errno));
		goto ERROR;
	}
	soc = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
	if (soc == -1)
	{
		LOG_ERR("%s", strerror(errno));
		goto ERROR;
	}
	ret = connect(soc, res->ai_addr, res->ai_addrlen);
	if (ret == -1)
	{
		LOG_ERR("%s", strerror(errno));
		goto ERROR;
	}
	freeaddrinfo(res);

	return (soc);
ERROR:
	if (soc != -1)
	{
		close(soc);
	}
	if (res)
	{
		freeaddrinfo(res);
	}
	return (-1);
}
