/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: url_encode.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<ctype.h>
#include	"strtool.h"
#include	"url_encode.h"

int             url_encode_is_ignore(const char ch);
char            url_decode_core(const char ch);

char           *
url_encode(const char *src)
{
	char           *dst = NULL;
	char           *sp = (char *) src;
	char            hex_dat[4];

	if (strtool_isempty(src))
	{
		goto ERROR;
	}
	while (*src)
	{
		if (!url_encode_is_ignore(*src))
		{
			if (sp != src)
			{
				strtool_ncat(&dst, sp, src - sp);
			}
			if (*src == ' ')
			{
				strtool_cat(&dst, "+");
			} else
			{
				sprintf(hex_dat, "%%%02x", *src & 0xFF);
				strtool_cat(&dst, hex_dat);
			}

			sp = (char *) src + 1;
		}
		src++;
	}

	if (sp != src)
	{
		strtool_ncat(&dst, sp, src - sp);
	}
	return (dst);
ERROR:
	return (NULL);
}

char           *
url_decode(const char *src)
{
	char           *dst = NULL;
	char           *sp = (char *) src;
	char            ch[2];

	if (strtool_isempty(src))
	{
		goto ERROR;
	}
	while (*src)
	{
		if (*src == '+')
		{
			if (sp != src)
			{
				strtool_ncat(&dst, sp, src - sp);
			}
			strtool_cat(&dst, " ");

			sp = (char *) src + 1;
		} else if (*src == '%')
		{
			if (sp != src)
			{
				strtool_ncat(&dst, sp, src - sp);
			}
			ch[0] = url_decode_core(*(src + 1));
			ch[0] = (ch[0] & 0x0F) << 4;

			ch[0] ^= url_decode_core(*(src + 2));

			ch[1] = '\0';

			strtool_cat(&dst, ch);

			src += 2;

			sp = (char *) src + 1;
		}
		src++;
	}

	if (sp != src)
	{
		strtool_ncat(&dst, sp, src - sp);
	}
	return (dst);
ERROR:
	return (NULL);
}

int 
url_encode_is_ignore(const char ch)
{
	char           *sign = ".-_";
	int             n;

	if (isalnum(ch) != 0)
	{
		return (1);
	}
	for (n = 0; sign[n]; n++)
	{
		if (sign[n] == ch)
		{
			return (1);
		}
	}

	return (0);
}

char 
url_decode_core(const char ch)
{
	char            dst;

	if (ch >= 'a')
	{
		dst = ch - 0x57;
	} else if (ch >= 'A')
	{
		dst = ch - 0x37;
	} else
	{
		dst = ch - 0x30;
	}

	return (dst);
}
