/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: strtool.h 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#ifndef	_inc_strtool_h
#define	_inc_strtool_h

#include	"strlist.h"

extern int      strtool_len(const char *str);
extern int      strtool_isempty(const char *str);
extern char    *strtool_toupper(char *str);
extern char    *strtool_tolower(char *str);

extern char    *strtool_dup(const char *src);
extern char    *strtool_ndup(const char *src, const int size);

extern int      strtool_ncat(char **str1, const char *str2, const int size);
extern int      strtool_cat(char **str1, const char *str2);

extern int      strtool_strip(char **str);
extern strlist_t *strtool_split(const char *str, const char *delim, const int time);

extern char    *strtool_sprintf(const char *fmt,...);

extern char    *strtool_to_hex(const char *str);

extern int      strtool_isequal(const char *str1, const char *str2);

extern int      strtool_isdigit(const char *str);

extern int      strtool_add_fence(char **src, char fence);
extern int      strtool_remove_fence(char **src, char fence);

extern int      strtool_remove_prefix(char *src, const char *prefix);

extern int      strtool_cmp(const char *str1, const char *str2);

#endif
