/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: strlists.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	"dlist.h"
#include	"strlist.h"
#include	"strlists.h"

struct strlists
{
	dlist_t        *dlist;
};

void            strlists_free(void *data);

strlists_t     *
strlists_create(void)
{
	strlists_t     *obj = NULL;

	obj = (strlists_t *) calloc(1, sizeof(strlists_t));
	if (!obj)
	{
		goto ERROR;
	}
	obj->dlist = dlist_create();
	if (!obj->dlist)
	{
		goto ERROR;
	}
	return (obj);
ERROR:
	return (NULL);
}

int 
strlists_destroy(strlists_t * obj)
{
	if (!obj)
	{
		goto ERROR;
	}
	dlist_destroy(obj->dlist, strlists_free);

	free(obj);

	return (0);
ERROR:
	return (1);
}

void 
strlists_free(void *data)
{
	if (data)
	{
		strlist_destroy((strlist_t *) data);
	}
}

strlist_t      *
strlists_pop(strlists_t * obj)
{
	if (!obj)
	{
		goto ERROR;
	}
	return ((strlist_t *) dlist_pop(obj->dlist));
ERROR:
	return (NULL);
}

int 
strlists_push(strlists_t * obj, const strlist_t * data)
{
	if (!strlist_len(data))
	{
		goto ERROR;
	}
	return (dlist_push(obj->dlist, strlist_dup(data)));
ERROR:
	return (1);
}

strlist_t      *
strlists_dequeue(strlists_t * obj)
{
	if (!obj)
	{
		goto ERROR;
	}
	return ((strlist_t *) dlist_dequeue(obj->dlist));
ERROR:
	return (NULL);
}

int 
strlists_queue(strlists_t * obj, const strlist_t * data)
{
	if (!obj || !strlist_len(data))
	{
		goto ERROR;
	}
	return (dlist_queue(obj->dlist, (void *) strlist_dup(data)));
ERROR:
	return (1);
}

int 
strlists_add(strlists_t * obj, const strlist_t * data)
{
	return (strlists_push(obj, data));
}

strlist_t      *
strlists_get(const strlists_t * obj, const int offset)
{
	strlist_t      *tmp = NULL;

	tmp = strlists_refer(obj, offset);

	if (!tmp)
	{
		goto ERROR;
	}
	return (strlist_dup(tmp));
ERROR:
	return (NULL);
}

strlist_t      *
strlists_refer(const strlists_t * obj, const int offset)
{
	if (!obj)
	{
		goto ERROR;
	}
	return ((strlist_t *) dlist_get_data_by_offset(obj->dlist, offset));
ERROR:
	return (NULL);
}

int 
strlists_len(const strlists_t * obj)
{
	if (!obj)
	{
		return (0);
	}
	return (dlist_len(obj->dlist));
}
