/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: sock.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	"strtool.h"
#include	"sock.h"

int 
read_block(int fd, const char *block, char **dst)
{
	int             n, m, ret, len = 0;
	char            ch;
	char            buf[1024];
	char           *tmp = NULL;

	if (!strtool_len(block) || !dst)
	{
		goto ERROR;
	}
	memset(buf, 0, sizeof(buf));

	*dst = NULL;

	n = m = len = 0;

	while (1)
	{
		ret = read(fd, &ch, 1);
		if (ret != 1)
		{
			break;
		}
		buf[n] = ch;

		if (buf[n] == block[m])
		{
			m++;
		} else
		{
			if (m != 0)
			{
				m = 0;
			}
		}

		if (block[m] == '\0')
		{
			break;
		}
		n++;

		if (n == sizeof(buf) - 1)
		{
			strtool_cat(&tmp, buf);

			len += strlen(buf);

			n = 0;

			memset(buf, 0, sizeof(buf));
		}
	}

	if (strlen(buf))
	{
		strtool_cat(&tmp, buf);

		len += strlen(buf);
	}
	*dst = tmp;

	return (len);
ERROR:
	free(tmp);
	return (0);
}
