# PinkyBlog定数

module PinkyBlog

	MENU_KEYS = %w(blog_top about recent_entries entry_list search news_feed master_menu)
	
	SPECIAL_TAG_PATTERN = /^[!！](.+)$/
	SPECIAL_TAG_NAMES = {}
	SPECIAL_TAG_NAMES['uncommentable'] = 'コメント不可'
	
	STATIC_ENTRY_DEFAULT_TITLES = {}
	STATIC_ENTRY_DEFAULT_TITLES['welcome'] = ''
	#STATIC_ENTRY_TITLES['message_response'] = 'ひとことレス'
	STATIC_ENTRY_DEFAULT_TITLES['about_blog'] = "このblogについて"
	STATIC_ENTRY_DEFAULT_TITLES['about_writer'] = "執筆者について"
	
	LIMIT_TIGHT = 'tight'
	LIMIT_LOOSE = 'loose'
	LIMIT_VERY_LOOSE = 'very-loose'
	LIMIT_TABLE = {
		:message_length => {'tight' => 80, 'loose' => 160, 'very-loose' => 300},
		:comment_length => {'tight' => 150, 'loose' => 300, 'very-loose' => 800},
	}
	
	
	# CGI#outに渡すためのステータスコード
	# スペルミス防止のために定数として定義してある
	HTTP_OK = HTTP_200 = '200 OK'
	HTTP_PARTIAL_CONTENT = HTTP_206 = '206 Partial Content'
	HTTP_MULTIPLE_CHOICES = HTTP_300 = '300 Multiple Choices'
	HTTP_MOVED = HTTP_MOVED_PERMANENTLY = HTTP_301 = '301 Moved Permanently'
	HTTP_FOUND = HTTP_302 = '302 Found'
	HTTP_SEE_OTHER = HTTP_303 = '303 See Other'
	HTTP_NOT_MODIFIED = HTTP_304 = '304 Not Modified'
	HTTP_BAD_REQUEST = HTTP_400 = '400 Bad Request'
	HTTP_AUTH_REQUIRED = HTTP_AUTHORIZATION_REQUIRED =\
		HTTP_401 = '401 Authorization Required'
	HTTP_FORBIDDEN = HTTP_403 = '403 Forbidden'
	HTTP_NOT_FOUND = HTTP_404 = '404 Not Found'
	HTTP_METHOD_NOT_ALLOWED = HTTP_405 = '405 Method Not Allowed'
	HTTP_NOT_ACCEPTABLE = HTTP_406 = '406 Not Acceptable'
	HTTP_CONFLICT = HTTP_409 = '409 Conflict'
	HTTP_GONE = HTTP_410 = '410 Gone'
	HTTP_SERVER_ERROR = HTTP_INTERNAL_SERVER_ERROR =\
		HTTP_500 = '500 Internal Server Error'
	
	MASTER_SESSION_TIME_LIMIT = 60*60*24*14
	
	ENTRY_LIST_PAGE_LENGTH = 15
	RECENT_ENTRY_PAGE_LENGTH = 3
	
	#COMMENT_LENGTH_MAX = 500
	#MESSAGE_LENGTH_MAX = 160
	
	NOTIFIED_MESSAGE_NUMBER = 100
	
	# ソート方式
	module Sort
		BY_MODIFIED = 'by_modified'
		BY_CREATED = 'by_created'
		BY_ACCESS = 'by_access'
	end
	include Sort
end



