
# Path to config file
CONFIG_FILE_NAME = 'pinkyblog_conf.rb'




require 'webrick'
require 'pathname'
$KCODE = 'u'


conf_path = Pathname.new(CONFIG_FILE_NAME)
raise "Failed to load config file. - #{CONFIG_FILE_NAME}" unless conf_path.readable?
mock = Object.new

script = conf_path.read.untaint
script.sub!(/^\xef\xbb\xbf/, '') # Deleting UTF-8 BOM

mock.instance_eval(script)
lib_path = Pathname.new(mock.instance_variable_get('@lib_dir_path'))
$LOAD_PATH << lib_path.to_s


require 'pinkyblog' 
include PinkyBlog

CONFIG = PinkyBlog::Config.load(conf_path)
APP = PinkyBlog::Application.load(CONFIG)


class BlogServlet < WEBrick::HTTPServlet::AbstractServlet
	def do_GET(req, res)
		#header.each(){ |key, value|
		#	res[key] = value
		#}
		
		APP.repository.clear_cache
		
		
		script_uri = req.request_uri.dup
		script_uri.path = ''
		script_uri.query = nil
		cookies = {}
		req.cookies.each do |ck|
			cookies[ck.name] ||= []
			cookies[ck.name] << ck.value
		end
		opts = {:cookies => cookies}
		preq = PinkyBlog::Request.new(script_uri, req.request_uri.path, req.query, opts)
		screen = APP.request(preq)
		screen.cookies.each do |cgi_cookie|
			c = WEBrick::Cookie.new(cgi_cookie.name, cgi_cookie.value.first || '')
			c.expires = cgi_cookie.expires
			res.cookies << c
		end
		res.body = screen.to_s
		screen.headers.each_pair do |key, value|
			res[key] = value
		end
		res.status = screen.http_status
	end

	def do_POST(req, res)
		do_GET(req, res)
	end
end

server = WEBrick::HTTPServer.new( :Port => CONFIG.http_server_port )

server.mount("/", BlogServlet)
server.mount("/res", WEBrick::HTTPServlet::FileHandler, "./res")
server.mount("/feed", WEBrick::HTTPServlet::FileHandler, "./feed")
server.mount("/csstemplate", WEBrick::HTTPServlet::FileHandler, "./csstemplate")

#Thread.start{
#	sleep(5);
#	server.shutdown;
#}

trap("INT"){ server.shutdown }
server.start

