#!/usr/local/bin/ruby

begin

	# Path to config file
	CONFIG_FILE_NAME = 'pinkyblog_conf.rb'





	require 'pathname'
	require 'cgi/session'
	$SAFE = 1
	$KCODE = 'u'

	config_path = Pathname.new(CONFIG_FILE_NAME)
	raise "Failed to load config file. - #{CONFIG_FILE_NAME}" unless config_path.readable?
	mock = Object.new
	
	script = config_path.read.untaint
	script.sub!(/^\xef\xbb\xbf/, '') # Deleting UTF-8 BOM
	
	mock.instance_eval(script)
	lib_path = Pathname.new(mock.instance_variable_get('@lib_dir_path'))
	$LOAD_PATH << lib_path.to_s
	
	require 'pinkyblog' 
	include PinkyBlog
	
	cgi = CGI.new
	config = Config.load(config_path)
	app = Application.load(config)
	req = Request.build(cgi)

	screen = app.request(req)
	screen.out(cgi)


rescue Exception

	require 'cgi'
	cgi = CGI.new
	opts = {}
	opts['type'] = 'text/plain'
	opts['status'] = '500 Internal Server Error'
	
	body = ''
	body << "#{$!} (#{$!.class})\n"
	body << "  " << $@.join("\n  ") << "\n\n"
	body << "ruby #{RUBY_VERSION} (#{RUBY_RELEASE_DATE}) [#{RUBY_PLATFORM}]" << "\n"
	if defined?(PinkyBlog::CORE_VERSION) then
		body << "Pinky:blog #{PinkyBlog::CORE_VERSION}"
	else
		body << "Pinky:blog (system version is unidentified)"
	end
	cgi.out(opts){ body }
end

