/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.datatransfer.Transferable;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingWindow;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class FloatingWindowDockableDropPanel
extends DockableDropPanel {
    protected ToolWindowManager toolWindowManager;
    protected FloatingWindow floatingWindow;

    public FloatingWindowDockableDropPanel(FloatingWindow floatingWindow, ToolWindowManager toolWindowManager) {
        super(ToolWindow.class);
        this.floatingWindow = floatingWindow;
        this.toolWindowManager = toolWindowManager;
    }

    public boolean dragStart(Transferable transferable, int action) {
        try {
            if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_MANAGER).equals(System.identityHashCode(this.toolWindowManager)) && action == 2 && (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF))) {
                return super.dragStart(transferable, action);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Transferable transferable) {
        if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF)) {
            try {
                ToolWindow toolWindow = this.toolWindowManager.getToolWindow(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_ID_DF));
                if (toolWindow != null) {
                    ToolWindow onToolWindow;
                    if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF)) {
                        ToolWindowTab tab = (ToolWindowTab)this.toolWindowManager.lookupDockable(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF));
                        tab.getOwner().removeToolWindowTab(tab);
                        toolWindow = (ToolWindow)tab.getDockableDelegator();
                    }
                    if (toolWindow == (onToolWindow = (ToolWindow)this.getOnDockable())) {
                        return false;
                    }
                    boolean oldAggregateMode = toolWindow.isAggregateMode();
                    toolWindow.setAggregateMode(true);
                    ToolWindowAnchor dragAnchor = this.getOnAnchor();
                    try {
                        if (dragAnchor == null && onToolWindow != null && toolWindow != onToolWindow && !SwingUtil.getBoolean("drag.toolwindow.asTab", true)) {
                            switch (onToolWindow.getAnchor()) {
                                case LEFT: 
                                case RIGHT: {
                                    dragAnchor = ToolWindowAnchor.TOP;
                                    break;
                                }
                                case TOP: 
                                case BOTTOM: {
                                    dragAnchor = ToolWindowAnchor.LEFT;
                                }
                            }
                        }
                        if (dragAnchor != null) {
                            switch (dragAnchor) {
                                case LEFT: {
                                    if (onToolWindow != null) {
                                        toolWindow.aggregate(onToolWindow, AggregationPosition.LEFT);
                                        break;
                                    }
                                    if (!this.checkCondition(toolWindow)) break;
                                    toolWindow.aggregateByReference((ToolWindow)this.floatingWindow.getDockable(), AggregationPosition.LEFT);
                                    break;
                                }
                                case RIGHT: {
                                    if (onToolWindow != null) {
                                        toolWindow.aggregate(onToolWindow, AggregationPosition.RIGHT);
                                        break;
                                    }
                                    if (!this.checkCondition(toolWindow)) break;
                                    toolWindow.aggregateByReference((ToolWindow)this.floatingWindow.getDockable(), AggregationPosition.RIGHT);
                                    break;
                                }
                                case BOTTOM: {
                                    if (onToolWindow != null) {
                                        toolWindow.aggregate(onToolWindow, AggregationPosition.BOTTOM);
                                        break;
                                    }
                                    if (!this.checkCondition(toolWindow)) break;
                                    toolWindow.aggregateByReference((ToolWindow)this.floatingWindow.getDockable(), AggregationPosition.BOTTOM);
                                    break;
                                }
                                case TOP: {
                                    if (onToolWindow != null) {
                                        toolWindow.aggregate(onToolWindow, AggregationPosition.TOP);
                                        break;
                                    }
                                    if (!this.checkCondition(toolWindow)) break;
                                    toolWindow.aggregateByReference((ToolWindow)this.floatingWindow.getDockable(), AggregationPosition.TOP);
                                }
                            }
                            toolWindow.setActive(true);
                        } else if (onToolWindow != null && toolWindow != onToolWindow) {
                            onToolWindow.addToolWindowTab(toolWindow).setSelected(true);
                            onToolWindow.setActive(true);
                        } else {
                            toolWindow.aggregateByReference((ToolWindow)this.floatingWindow.getDockable(), AggregationPosition.DEFAULT);
                            toolWindow.setActive(true);
                        }
                    }
                    finally {
                        toolWindow.setAggregateMode(oldAggregateMode);
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public FloatingWindow getModalWindow() {
        return this.floatingWindow;
    }

    public void setModalWindow(FloatingWindow floatingWindow) {
        this.floatingWindow = floatingWindow;
    }

    protected boolean checkCondition(ToolWindow toolWindow) {
        if (toolWindow.getAnchor() != ToolWindowAnchor.BOTTOM) {
            return true;
        }
        int visibleNum = 0;
        boolean flag = false;
        for (ToolWindow tool : this.toolWindowManager.getToolsByAnchor(ToolWindowAnchor.BOTTOM)) {
            if (tool.isVisible()) {
                ++visibleNum;
            }
            if (tool != toolWindow) continue;
            flag = true;
        }
        return !flag || visibleNum != 1;
    }
}

