/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.animation.TransparencyAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingLiveWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingResizeMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.cmp.multisplit.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.translucent.TranslucentPanel;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatingLivePanel
extends TranslucentPanel
implements FloatingLiveWindow,
PropertyChangeListener,
ActionListener {
    protected MyDoggyToolWindowManager manager;
    protected JLayeredPane layeredPane;
    protected DockableDropPanel dockableDropPanel;
    protected MultiSplitDockableContainer<ToolWindow> multiSplitDockableContainer;
    protected TransparencyAnimation animation;
    protected Timer timer;
    protected FloatingResizeMouseInputHandler resizeMouseInputHandler;

    public FloatingLivePanel(MyDoggyToolWindowManager manager) {
        this.manager = manager;
        this.initComponents();
        this.initListeners();
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("active".equals(propertyName)) {
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                this.layeredPane.setLayer(this, JLayeredPane.DEFAULT_LAYER + 4);
                if (this.timer != null) {
                    this.timer.stop();
                    if (this.animation.isAnimating()) {
                        this.animation.stop();
                    }
                }
                this.setAlphaModeRatio(1.0f);
            } else {
                this.layeredPane.setLayer(this, JLayeredPane.DEFAULT_LAYER + 3);
                FloatingLiveTypeDescriptor floatingLiveTypeDescriptor = (FloatingLiveTypeDescriptor)((ToolWindow)evt.getSource()).getTypeDescriptor(ToolWindowType.FLOATING_LIVE);
                if (floatingLiveTypeDescriptor.isTransparentMode()) {
                    this.timer = new Timer(floatingLiveTypeDescriptor.getTransparentDelay() + 100, this){

                        protected void fireActionPerformed(ActionEvent e) {
                            e = new ActionEvent(evt.getSource(), e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
                            super.fireActionPerformed(e);
                        }
                    };
                    this.timer.start();
                }
            }
            SwingUtil.repaint(this.layeredPane);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.timer.isRunning()) {
            this.timer.stop();
            FloatingLiveTypeDescriptor floatingLiveTypeDescriptor = ((ToolWindow)e.getSource()).getTypeDescriptor(FloatingLiveTypeDescriptor.class);
            this.animation.setAlpha(floatingLiveTypeDescriptor.getTransparentRatio());
            this.animation.show(new Object[0]);
        }
    }

    @Override
    public void resetLayout() {
        TableLayout layout = (TableLayout)this.getLayout();
        layout.setColumn(0, 0.0);
        layout.setColumn(2, 0.0);
        layout.setRow(0, 0.0);
        layout.setRow(2, 0.0);
    }

    @Override
    public void setLayout() {
        TableLayout layout = (TableLayout)this.getLayout();
        layout.setColumn(0, 2.0);
        layout.setColumn(2, 2.0);
        layout.setRow(0, 2.0);
        layout.setRow(2, 2.0);
    }

    @Override
    public void addDockable(ToolWindow toolWindow, Component content) {
        this.addDockable(toolWindow, content, (ToolWindow)null, AggregationPosition.DEFAULT);
    }

    @Override
    public void addDockable(ToolWindow toolWindow, Component content, ToolWindow aggregationOnDockable, AggregationPosition aggregationPosition) {
        this.multiSplitDockableContainer.addDockable(toolWindow, content, aggregationOnDockable, -1, aggregationPosition);
        toolWindow.addPropertyChangeListener(this);
        boolean resizable = toolWindow.getTypeDescriptor(FloatingLiveTypeDescriptor.class).isResizable();
        if (this.getDockableCount() == 1) {
            this.resizeMouseInputHandler.setResizable(resizable);
        } else if (resizable) {
            this.resizeMouseInputHandler.setResizable(resizable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDockable(ToolWindow toolWindow) {
        try {
            this.multiSplitDockableContainer.removeDockable(toolWindow);
        }
        finally {
            toolWindow.removePropertyChangeListener(this);
        }
    }

    @Override
    public int getDockableCount() {
        return this.multiSplitDockableContainer.getDockableCount();
    }

    @Override
    public ToolWindow getDockable() {
        return (ToolWindow)this.multiSplitDockableContainer.getDockableEntries().get((int)0).dockable;
    }

    @Override
    public List<ToolWindow> getDockables() {
        return this.multiSplitDockableContainer.getDockables();
    }

    @Override
    public boolean containsDockable(ToolWindow toolWindow) {
        return this.multiSplitDockableContainer.containsDockable(toolWindow);
    }

    @Override
    public Object getMultiSplitLayout() {
        return this.multiSplitDockableContainer.getMultiSplitLayout();
    }

    @Override
    public void setMultiSplitLayout(Object model) {
        this.multiSplitDockableContainer.setMultiSplitLayout((MultiSplitLayout.Node)model);
    }

    @Override
    public void mount() {
        if (this.getParent() == this.layeredPane) {
            return;
        }
        this.layeredPane.remove(this);
        this.layeredPane.setLayer(this, JLayeredPane.DEFAULT_LAYER + 3);
        this.layeredPane.add(this);
    }

    @Override
    public boolean unmount() {
        if (this.multiSplitDockableContainer.getDockableCount() == 0) {
            this.setLayout();
            this.layeredPane.remove(this);
            this.setBorder(null);
            SwingUtil.repaint(this.layeredPane);
            return true;
        }
        SwingUtil.repaint(this.layeredPane);
        return false;
    }

    protected void initComponents() {
        this.layeredPane = this.manager.getLayeredPane();
        this.multiSplitDockableContainer = new MultiSplitDockableContainer(this.manager, 0);
        this.dockableDropPanel = new FloatingLiveDockableDropPanel();
        this.dockableDropPanel.setComponent(this.multiSplitDockableContainer);
        this.setLayout(new ExtendedTableLayout(new double[][]{{2.0, -1.0, 2.0}, {2.0, -1.0, 2.0}}));
        this.add((Component)this.dockableDropPanel, "1,1,FULL,FULL");
        this.animation = new TransparencyAnimation(this, (Component)this, 1.0f, 500.0f);
    }

    protected void initListeners() {
        this.resizeMouseInputHandler = new FloatingResizeMouseInputHandler(this);
        this.addMouseMotionListener(this.resizeMouseInputHandler);
        this.addMouseListener(this.resizeMouseInputHandler);
    }

    public class FloatingLiveDockableDropPanel
    extends DockableDropPanel {
        public FloatingLiveDockableDropPanel() {
            super(ToolWindow.class);
        }

        public boolean dragStart(Transferable transferable, int action) {
            try {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_MANAGER).equals(System.identityHashCode(FloatingLivePanel.this.manager)) && action == 2 && (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF))) {
                    return super.dragStart(transferable, action);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean drop(Transferable transferable) {
            if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF)) {
                try {
                    ToolWindow toolWindow = FloatingLivePanel.this.manager.getToolWindow(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_ID_DF));
                    if (toolWindow != null) {
                        ToolWindow onToolWindow;
                        if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF)) {
                            ToolWindowTab tab = (ToolWindowTab)FloatingLivePanel.this.manager.lookupDockable(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF));
                            tab.getOwner().removeToolWindowTab(tab);
                            toolWindow = (ToolWindow)tab.getDockableDelegator();
                        }
                        if (toolWindow == (onToolWindow = (ToolWindow)this.getOnDockable())) {
                            return false;
                        }
                        boolean oldAggregateMode = toolWindow.isAggregateMode();
                        toolWindow.setAggregateMode(true);
                        ToolWindowAnchor dragAnchor = this.getOnAnchor();
                        try {
                            if (dragAnchor == null && onToolWindow != null && toolWindow != onToolWindow && !SwingUtil.getBoolean("drag.toolwindow.asTab", true)) {
                                switch (onToolWindow.getAnchor()) {
                                    case LEFT: 
                                    case RIGHT: {
                                        dragAnchor = ToolWindowAnchor.TOP;
                                        break;
                                    }
                                    case TOP: 
                                    case BOTTOM: {
                                        dragAnchor = ToolWindowAnchor.LEFT;
                                    }
                                }
                            }
                            if (dragAnchor != null) {
                                switch (dragAnchor) {
                                    case LEFT: {
                                        if (onToolWindow != null) {
                                            toolWindow.aggregate(onToolWindow, AggregationPosition.LEFT);
                                            break;
                                        }
                                        if (!this.checkCondition(toolWindow)) break;
                                        toolWindow.aggregateByReference((ToolWindow)FloatingLivePanel.this.multiSplitDockableContainer.getDockable(), AggregationPosition.LEFT);
                                        break;
                                    }
                                    case RIGHT: {
                                        if (onToolWindow != null) {
                                            toolWindow.aggregate(onToolWindow, AggregationPosition.RIGHT);
                                            break;
                                        }
                                        if (!this.checkCondition(toolWindow)) break;
                                        toolWindow.aggregateByReference((ToolWindow)FloatingLivePanel.this.multiSplitDockableContainer.getDockable(), AggregationPosition.RIGHT);
                                        break;
                                    }
                                    case BOTTOM: {
                                        if (onToolWindow != null) {
                                            toolWindow.aggregate(onToolWindow, AggregationPosition.BOTTOM);
                                            break;
                                        }
                                        if (!this.checkCondition(toolWindow)) break;
                                        toolWindow.aggregateByReference((ToolWindow)FloatingLivePanel.this.multiSplitDockableContainer.getDockable(), AggregationPosition.BOTTOM);
                                        break;
                                    }
                                    case TOP: {
                                        if (onToolWindow != null) {
                                            toolWindow.aggregate(onToolWindow, AggregationPosition.TOP);
                                            break;
                                        }
                                        if (!this.checkCondition(toolWindow)) break;
                                        toolWindow.aggregateByReference((ToolWindow)FloatingLivePanel.this.multiSplitDockableContainer.getDockable(), AggregationPosition.TOP);
                                    }
                                }
                                final ToolWindow toolWindow2 = toolWindow;
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        toolWindow2.setActive(true);
                                    }
                                });
                            } else if (onToolWindow != null && toolWindow != onToolWindow) {
                                onToolWindow.addToolWindowTab(toolWindow).setSelected(true);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        onToolWindow.setActive(true);
                                    }
                                });
                            } else {
                                toolWindow.aggregateByReference((ToolWindow)FloatingLivePanel.this.multiSplitDockableContainer.getDockable(), AggregationPosition.DEFAULT);
                                final ToolWindow toolWindow1 = toolWindow;
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        toolWindow1.setActive(true);
                                    }
                                });
                            }
                        }
                        finally {
                            toolWindow.setAggregateMode(oldAggregateMode);
                        }
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }

        protected boolean checkCondition(ToolWindow toolWindow) {
            if (toolWindow.getAnchor() != ToolWindowAnchor.BOTTOM) {
                return true;
            }
            int visibleNum = 0;
            boolean flag = false;
            for (ToolWindow tool : FloatingLivePanel.this.manager.getToolsByAnchor(ToolWindowAnchor.BOTTOM)) {
                if (tool.isVisible()) {
                    ++visibleNum;
                }
                if (tool != toolWindow) continue;
                flag = true;
            }
            return !flag || visibleNum != 1;
        }
    }
}

