/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.persistence.xml;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.noos.common.context.Context;
import org.noos.common.context.MutableContext;
import org.noos.common.element.ElementParser;
import org.noos.common.element.ElementWriter;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.DesktopContentManagerUI;
import org.noos.xing.mydoggy.DesktopContentUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.MostRecentDescriptor;
import org.noos.xing.mydoggy.MultiSplitContentManagerUI;
import org.noos.xing.mydoggy.MultiSplitContentUI;
import org.noos.xing.mydoggy.Observable;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.PersistenceDelegateCallback;
import org.noos.xing.mydoggy.PersistenceDelegateFilter;
import org.noos.xing.mydoggy.PushAwayMode;
import org.noos.xing.mydoggy.RepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.SlidingTypeDescriptor;
import org.noos.xing.mydoggy.TabbedContentManagerUI;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowManagerDescriptor;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowBar;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.common.context.DefaultMutableContext;
import org.noos.xing.mydoggy.plaf.persistence.InternalPersistenceDelegateFilter;
import org.noos.xing.mydoggy.plaf.persistence.InternalPersistenceDelegateFilterAdapter;
import org.noos.xing.mydoggy.plaf.persistence.InternalPersistenceDelegateFilterWrapper;
import org.noos.xing.mydoggy.plaf.persistence.PersistenceDelegateCallbackAdapter;
import org.noos.xing.mydoggy.plaf.persistence.xml.Base64;
import org.noos.xing.mydoggy.plaf.persistence.xml.SharedWindows;
import org.noos.xing.mydoggy.plaf.persistence.xml.XMLPersistenceNode;
import org.noos.xing.mydoggy.plaf.persistence.xml.XMLWriter;
import org.noos.xing.mydoggy.plaf.persistence.xml.merge.MergePolicyApplier;
import org.noos.xing.mydoggy.plaf.persistence.xml.merge.ResetMergePolicy;
import org.noos.xing.mydoggy.plaf.persistence.xml.merge.UnionMergePolicy;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingLiveWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.multisplit.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.content.ContentDescriptor;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyMultiSplitContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPersistenceDelegate
implements PersistenceDelegate {
    protected MyDoggyToolWindowManager toolWindowManager;
    protected ElementParser<Element> masterElementParser;
    protected ElementWriter<XMLWriter> masterElementWriter;
    protected Map<PersistenceDelegate.MergePolicy, MergePolicyApplier> mergePolicyApplierMap;
    protected PersistenceDelegateCallback dummyCallback;
    protected PersistenceDelegateFilter dummyFilter;

    public XMLPersistenceDelegate(MyDoggyToolWindowManager toolWindowManager) {
        this.toolWindowManager = toolWindowManager;
        this.masterElementParser = new MasterElementParser();
        this.masterElementWriter = new ToolWindowManagerElementWriter(toolWindowManager);
        this.dummyCallback = new PersistenceDelegateCallbackAdapter();
        this.dummyFilter = new InternalPersistenceDelegateFilterAdapter();
        this.initMaps();
    }

    @Override
    public void save(OutputStream outputStream) {
        this.saveInternal(outputStream, this.dummyFilter, true);
    }

    @Override
    public void save(OutputStream outputStream, PersistenceDelegateFilter filter) {
        this.saveInternal(outputStream, filter, true);
    }

    @Override
    public void apply(InputStream inputStream) {
        this.applyInternal(inputStream, PersistenceDelegate.MergePolicy.RESET, null);
    }

    @Override
    public void merge(InputStream inputStream, PersistenceDelegate.MergePolicy mergePolicy) {
        this.applyInternal(inputStream, mergePolicy, null);
    }

    @Override
    public void merge(InputStream inputStream, PersistenceDelegate.MergePolicy mergePolicy, PersistenceDelegateCallback callback) {
        this.applyInternal(inputStream, mergePolicy, callback);
    }

    public void save(OutputStream outputStream, PersistenceDelegateFilter filter, boolean standalone) {
        this.saveInternal(outputStream, filter, standalone);
    }

    public void apply(Element element, PersistenceDelegate.MergePolicy mergePolicy, PersistenceDelegateCallback callback) {
        if (callback == null) {
            callback = this.dummyCallback;
        }
        try {
            DefaultMutableContext context = new DefaultMutableContext();
            context.put(ToolWindowManager.class, this.toolWindowManager);
            context.put(MyDoggyToolWindowManager.class, this.toolWindowManager);
            context.put(MergePolicyApplier.class, this.mergePolicyApplierMap.get((Object)mergePolicy));
            context.put(PersistenceDelegateCallback.class, callback);
            this.masterElementParser.parse(element, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initMaps() {
        this.mergePolicyApplierMap = new Hashtable<PersistenceDelegate.MergePolicy, MergePolicyApplier>();
        this.mergePolicyApplierMap.put(PersistenceDelegate.MergePolicy.RESET, new ResetMergePolicy());
        this.mergePolicyApplierMap.put(PersistenceDelegate.MergePolicy.UNION, new UnionMergePolicy());
    }

    protected void saveInternal(OutputStream outputStream, PersistenceDelegateFilter filter, boolean standalone) {
        ClassLoader bundleClassLoader = this.getClass().getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        try {
            XMLWriter writer = new XMLWriter(new OutputStreamWriter(outputStream));
            DefaultMutableContext context = new DefaultMutableContext();
            context.put(MyDoggyToolWindowManager.class, this.toolWindowManager);
            context.put(PersistenceDelegateFilter.class, filter != null ? filter : this.dummyFilter);
            context.put(InternalPersistenceDelegateFilter.class, filter != null ? (filter instanceof InternalPersistenceDelegateFilter ? filter : new InternalPersistenceDelegateFilterWrapper(filter)) : this.dummyFilter);
            context.put("standalone", standalone);
            this.masterElementWriter.write(writer, context);
            writer.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyInternal(InputStream inputStream, PersistenceDelegate.MergePolicy mergePolicy, PersistenceDelegateCallback callback) {
        if (callback == null) {
            callback = this.dummyCallback;
        }
        ClassLoader bundleClassLoader = this.getClass().getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            DefaultMutableContext context = new DefaultMutableContext();
            context.put(ToolWindowManager.class, this.toolWindowManager);
            context.put(MyDoggyToolWindowManager.class, this.toolWindowManager);
            context.put(MergePolicyApplier.class, this.mergePolicyApplierMap.get((Object)mergePolicy));
            context.put(PersistenceDelegateCallback.class, callback);
            this.masterElementParser.parse(document.getDocumentElement(), context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        if (callback == null) {
            callback = this.dummyCallback;
        }
    }

    protected void storeMultiSplitWindow(XMLWriter writer, MultiSplitWindow<? extends Dockable> sharedWindow) {
        if (sharedWindow.getDockableCount() > 1) {
            try {
                writer.startElement("sharedWindow");
                for (Dockable dockable : sharedWindow.getDockables()) {
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute(null, "id", null, null, dockable.getId());
                    writer.dataElement("dockable", attributes);
                }
                writer.startElement("layout");
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLEncoder xMLEncoder = new XMLEncoder(os);
                xMLEncoder.writeObject(sharedWindow.getMultiSplitLayout());
                xMLEncoder.flush();
                xMLEncoder.close();
                String model = os.toString();
                writer.cdata(model.substring(model.indexOf(10)));
                writer.endElement("layout");
                writer.endElement("sharedWindow");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class DekstopManagerUIElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            if (context.get(ToolWindowManager.class).getContentManager().getContentManagerUI() instanceof DesktopContentManagerUI) {
                DesktopContentManagerUI managerUI = (DesktopContentManagerUI)context.get(ToolWindowManager.class).getContentManager().getContentManagerUI();
                managerUI.setCloseable(this.getBoolean(context, element, "closeable", true));
                managerUI.setDetachable(this.getBoolean(context, element, "detachable", false));
                managerUI.setMinimizable(this.getBoolean(context, element, "minimizable", false));
                managerUI.setMaximizable(this.getBoolean(context, element, "maximizable", false));
                managerUI.setPopupMenuEnabled(this.getBoolean(context, element, "popupMenuEnabled", true));
                ContentManager contentManager = context.get(ToolWindowManager.class).getContentManager();
                NodeList contentUIElms = element.getElementsByTagName("content");
                int size = contentUIElms.getLength();
                for (int i = 0; i < size; ++i) {
                    Element contentUIElm = (Element)contentUIElms.item(i);
                    String contentId = contentUIElm.getAttribute("id");
                    Content content = contentManager.getContent(contentId);
                    if (content == null) {
                        content = context.get(PersistenceDelegateCallback.class).contentNotFound(context.get(ToolWindowManager.class), contentId, node.setElement(contentUIElm));
                    }
                    if (content == null) continue;
                    DesktopContentUI desktopContentUI = (DesktopContentUI)content.getContentUI();
                    desktopContentUI.setIconified(this.getBoolean(context, contentUIElm, "iconified", false));
                    desktopContentUI.setLocation(this.getInteger(context, contentUIElm, "x", 0), this.getInteger(context, contentUIElm, "y", 0));
                    desktopContentUI.setSize(this.getInteger(context, contentUIElm, "width", 100), this.getInteger(context, contentUIElm, "height", 1000));
                }
            }
            return false;
        }
    }

    public class TabbedContentManagerUIElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            if (context.get(ToolWindowManager.class).getContentManager().getContentManagerUI() instanceof TabbedContentManagerUI) {
                TabbedContentManagerUI managerUI = (TabbedContentManagerUI)context.get(ToolWindowManager.class).getContentManager().getContentManagerUI();
                managerUI.setCloseable(this.getBoolean(context, element, "closeable", true));
                managerUI.setDetachable(this.getBoolean(context, element, "detachable", false));
                managerUI.setMinimizable(this.getBoolean(context, element, "minimizable", false));
                managerUI.setMaximizable(this.getBoolean(context, element, "maximizable", false));
                managerUI.setPopupMenuEnabled(this.getBoolean(context, element, "popupMenuEnabled", true));
                managerUI.setShowAlwaysTab(this.getBoolean(context, element, "showAlwaysTab", false));
                managerUI.setTabLayout(TabbedContentManagerUI.TabLayout.valueOf(element.getAttribute("tabLayout")));
                managerUI.setTabPlacement(TabbedContentManagerUI.TabPlacement.valueOf(element.getAttribute("tabPlacement")));
            }
            return false;
        }
    }

    public class MultiSplitContentManagerUIElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            if (context.get(ToolWindowManager.class).getContentManager().getContentManagerUI() instanceof MultiSplitContentManagerUI) {
                Element layout;
                MultiSplitContentManagerUI managerUI = (MultiSplitContentManagerUI)context.get(ToolWindowManager.class).getContentManager().getContentManagerUI();
                managerUI.setCloseable(this.getBoolean(context, element, "closeable", true));
                managerUI.setDetachable(this.getBoolean(context, element, "detachable", false));
                managerUI.setMinimizable(this.getBoolean(context, element, "minimizable", false));
                managerUI.setMaximizable(this.getBoolean(context, element, "maximizable", false));
                managerUI.setPopupMenuEnabled(this.getBoolean(context, element, "popupMenuEnabled", true));
                managerUI.setShowAlwaysTab(this.getBoolean(context, element, "showAlwaysTab", false));
                managerUI.setTabLayout(TabbedContentManagerUI.TabLayout.valueOf(element.getAttribute("tabLayout")));
                managerUI.setTabPlacement(TabbedContentManagerUI.TabPlacement.valueOf(element.getAttribute("tabPlacement")));
                ContentManager contentManager = context.get(ToolWindowManager.class).getContentManager();
                Element contents = this.getElement(element, "contents");
                if (contents != null) {
                    NodeList contentUIElms = contents.getElementsByTagName("content");
                    int size = contentUIElms.getLength();
                    for (int i = 0; i < size; ++i) {
                        Element contentUIElm = (Element)contentUIElms.item(i);
                        String contentId = contentUIElm.getAttribute("id");
                        Content content = contentManager.getContent(contentId);
                        if (content == null) {
                            content = context.get(PersistenceDelegateCallback.class).contentNotFound(context.get(ToolWindowManager.class), contentId, node.setElement(contentUIElm));
                        }
                        if (content == null) continue;
                        MultiSplitContentUI multiSplitContentUI = (MultiSplitContentUI)content.getContentUI();
                        multiSplitContentUI.setShowAlwaysTab(this.getBoolean(context, contentUIElm, "showAlwaysTab", true));
                    }
                }
                if ((layout = this.getElement(element, "layout")) != null) {
                    String text = layout.getTextContent();
                    XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(text.getBytes()));
                    ((MutableContext)context).put((Object)ContextKey.MultiSplitContentManagerUILayout, decoder.readObject());
                } else {
                    ((MutableContext)context).put((Object)ContextKey.MultiSplitContentManagerUILayout, null);
                }
            }
            return false;
        }
    }

    public class ToolWindowBarElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, final Context context) {
            Element workspaceElement;
            final ToolWindowAnchor anchor = ToolWindowAnchor.valueOf(element.getAttribute("anchor"));
            MyDoggyToolWindowBar toolWindowBar = (MyDoggyToolWindowBar)context.get(ToolWindowManager.class).getToolWindowBar(anchor);
            toolWindowBar.setDividerSize(this.getInteger(context, element, "dividerSize", 3));
            toolWindowBar.setAggregateMode(this.getBoolean(context, element, "aggregateMode", false));
            toolWindowBar.setLength(this.getInteger(context, element, "length", 23));
            Element layoutElement = this.getElement(element, "layout");
            if (layoutElement != null) {
                String layoutAsText = layoutElement.getTextContent();
                XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(layoutAsText.getBytes()));
                final MultiSplitLayout.Node layout = (MultiSplitLayout.Node)decoder.readObject();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((MyDoggyToolWindowBar)context.get(ToolWindowManager.class).getToolWindowBar(anchor)).setLayout(layout);
                    }
                });
            }
            if ((workspaceElement = this.getElement(element, "workspace")) != null) {
                byte[] workspace = Base64.decode(workspaceElement.getTextContent());
                toolWindowBar.setToolWorkspace(workspace, this.getBoolean(context, element, "toolsVisible", false));
            }
            return false;
        }
    }

    public class ContentManagerElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, final Context context) {
            Element sharedWindowsElem = this.getElement(element, "sharedWindows");
            SharedWindows sharedWindows = new SharedWindows(context.get(ToolWindowManager.class).getContentManager(), context.get(PersistenceDelegateCallback.class));
            if (sharedWindowsElem != null) {
                NodeList sharedWindowsList = sharedWindowsElem.getElementsByTagName("sharedWindow");
                int size = sharedWindowsList.getLength();
                for (int i = 0; i < size; ++i) {
                    Element sharedwindowElem = (Element)sharedWindowsList.item(i);
                    NodeList dockabledIdList = sharedwindowElem.getElementsByTagName("dockable");
                    if (dockabledIdList.getLength() <= 0) continue;
                    String[] ids = new String[dockabledIdList.getLength()];
                    int sizej = dockabledIdList.getLength();
                    for (int j = 0; j < sizej; ++j) {
                        ids[j] = ((Element)dockabledIdList.item(j)).getAttribute("id");
                    }
                    Element modelElement = this.getElement(element, "layout");
                    if (modelElement == null) continue;
                    String text = modelElement.getTextContent();
                    XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(text.getBytes()));
                    MultiSplitLayout.Node model = (MultiSplitLayout.Node)decoder.readObject();
                    sharedWindows.addSharedWindow(model, ids);
                }
            }
            NodeList contents = element.getElementsByTagName("content");
            Content selectedContent = null;
            Dockable maximizedContent = null;
            int size = contents.getLength();
            for (int i = 0; i < size; ++i) {
                Element contentElement = (Element)contents.item(i);
                String contentId = contentElement.getAttribute("id");
                Content content = context.get(ToolWindowManager.class).getContentManager().getContent(contentId);
                if (content == null) {
                    content = context.get(PersistenceDelegateCallback.class).contentNotFound(context.get(ToolWindowManager.class), contentId, node.setElement(contentElement));
                }
                if (content == null) continue;
                if (this.getBoolean(context, contentElement, "selected", false)) {
                    selectedContent = content;
                }
                if (this.getBoolean(context, contentElement, "maximized", false)) {
                    maximizedContent = content;
                }
                content.setEnabled(this.getBoolean(context, contentElement, "enabled", true));
                boolean detached = this.getBoolean(context, contentElement, "detached", false);
                content.setMaximized(false);
                content.setMinimized(this.getBoolean(context, contentElement, "minimized", false));
                content.setFlashing(this.getBoolean(context, contentElement, "flashing", false));
                Element minimizedStateElem = this.getElement(contentElement, "minimizedState");
                if (minimizedStateElem != null && content.isMinimized()) {
                    ContentDescriptor contentDescriptor = (ContentDescriptor)XMLPersistenceDelegate.this.toolWindowManager.getDockableDescriptor(content.getId());
                    contentDescriptor.setAnchor(this.getToolWindowAnchor(context, minimizedStateElem, "anchor", ToolWindowAnchor.LEFT), this.getInteger(context, minimizedStateElem, "anchorIndex", -1));
                }
                ContentUI contentUI = content.getContentUI();
                contentUI.setCloseable(this.getBoolean(context, contentElement, "closeable", true));
                contentUI.setDetachable(this.getBoolean(context, contentElement, "detachable", true));
                contentUI.setMinimizable(this.getBoolean(context, contentElement, "minimizable", true));
                contentUI.setMaximizable(this.getBoolean(context, contentElement, "maximizable", true));
                contentUI.setTransparentMode(this.getBoolean(context, contentElement, "transparentMode", true));
                contentUI.setTransparentDelay(this.getInteger(context, contentElement, "transparentDelay", 0));
                contentUI.setTransparentRatio(this.getFloat(context, contentElement, "transparentRatio", 0.7f));
                contentUI.setAddToTaskBarWhenDetached(this.getBoolean(context, contentElement, "addToTaskBarWhenDetached", false));
                contentUI.setAlwaysOnTop(this.getBoolean(context, contentElement, "alwaysOnTop", false));
                NodeList list = contentElement.getElementsByTagName("detachedBounds");
                if (list.getLength() > 0) {
                    Element detachedBoundsElm = (Element)list.item(0);
                    contentUI.setDetachedBounds(new Rectangle(this.getInteger(context, detachedBoundsElm, "x", 100), this.getInteger(context, detachedBoundsElm, "y", 100), this.getInteger(context, detachedBoundsElm, "width", 320), this.getInteger(context, detachedBoundsElm, "height", 200)));
                }
                if (detached) {
                    if (sharedWindows.isInSharedWindow(content)) {
                        Dockable refDockable = sharedWindows.getRefDockable(content);
                        if (refDockable != null) {
                            content.detachByReference((Content)refDockable, AggregationPosition.DEFAULT);
                            continue;
                        }
                        content.setDetached(true);
                        continue;
                    }
                    content.setDetached(true);
                    continue;
                }
                content.setDetached(false);
            }
            Element modelElement = this.getElement(element, "layout");
            if (modelElement != null && !XMLPersistenceDelegate.this.toolWindowManager.getContentManager().isEnabled()) {
                String text = modelElement.getTextContent();
                XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(text.getBytes()));
                final MultiSplitLayout.Node model = (MultiSplitLayout.Node)decoder.readObject();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MultiSplitDockableContainer dockableContainer = (MultiSplitDockableContainer)((DockableDropPanel)context.get(MyDoggyToolWindowManager.class).getMainContent()).getComponent();
                        dockableContainer.setMultiSplitLayout(model);
                    }
                });
            } else if (context.get((Object)ContextKey.MultiSplitContentManagerUILayout) != null && XMLPersistenceDelegate.this.toolWindowManager.getContentManager().isEnabled()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MyDoggyMultiSplitContentManagerUI myDoggyMultiSplitContentManagerUI = (MyDoggyMultiSplitContentManagerUI)XMLPersistenceDelegate.this.toolWindowManager.getContentManager().getContentManagerUI();
                        myDoggyMultiSplitContentManagerUI.setLayout(context.get((Object)ContextKey.MultiSplitContentManagerUILayout));
                    }
                });
            }
            final Content selectedContent1 = selectedContent;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (selectedContent1 != null) {
                        selectedContent1.setSelected(true);
                    }
                }
            });
            if (maximizedContent != null) {
                maximizedContent.setMaximized(true);
            }
            return false;
        }
    }

    public class ToolWindowsElementParser
    extends ElementParserAdapter {
        protected MergePolicyApplier mergePolicyApplier;

        public boolean parse(Element element, Context context) {
            int i;
            int size;
            this.mergePolicyApplier = context.get(MergePolicyApplier.class);
            Element sharedWindowsElem = this.getElement(element, "sharedWindows");
            SharedWindows sharedWindows = new SharedWindows(context.get(ToolWindowManager.class), context.get(PersistenceDelegateCallback.class));
            if (sharedWindowsElem != null) {
                NodeList sharedWindowsList = sharedWindowsElem.getElementsByTagName("sharedWindow");
                size = sharedWindowsList.getLength();
                for (i = 0; i < size; ++i) {
                    Element sharedwindowElem = (Element)sharedWindowsList.item(i);
                    NodeList dockabledIdList = sharedwindowElem.getElementsByTagName("dockable");
                    if (dockabledIdList.getLength() <= 0) continue;
                    String[] ids = new String[dockabledIdList.getLength()];
                    int sizej = dockabledIdList.getLength();
                    for (int j = 0; j < sizej; ++j) {
                        ids[j] = ((Element)dockabledIdList.item(j)).getAttribute("id");
                    }
                    Element modelElement = this.getElement(element, "layout");
                    if (modelElement == null) continue;
                    String text = modelElement.getTextContent();
                    XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(text.getBytes()));
                    MultiSplitLayout.Node model = (MultiSplitLayout.Node)decoder.readObject();
                    sharedWindows.addSharedWindow(model, ids);
                }
            }
            NodeList tools = element.getElementsByTagName("toolWindow");
            size = tools.getLength();
            for (i = 0; i < size; ++i) {
                ToolWindowType type;
                Element dimension;
                Observable descriptor;
                Element tool = (Element)tools.item(i);
                String toolId = tool.getAttribute("id");
                ToolWindow toolWindow = context.get(ToolWindowManager.class).getToolWindow(toolId);
                if (toolWindow == null) {
                    toolWindow = context.get(PersistenceDelegateCallback.class).toolwindowNotFound(context.get(ToolWindowManager.class), toolId, node.setElement(tool));
                }
                if (toolWindow == null) continue;
                Element typeElement = this.getElement(tool, "docked");
                if (typeElement != null) {
                    descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
                    this.applyAttributes(context, typeElement, (ToolWindowTypeDescriptor)descriptor);
                    descriptor.setDockLength(this.getInteger(context, typeElement, "dockLength", 200));
                    descriptor.setMinimumDockLength(this.getInteger(context, typeElement, "minimumDockLength", 100));
                    descriptor.setPopupMenuEnabled(this.getBoolean(context, typeElement, "popupMenuEnabled", true));
                }
                if ((typeElement = this.getElement(tool, "sliding")) != null) {
                    descriptor = (SlidingTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.SLIDING);
                    this.applyAttributes(context, typeElement, (ToolWindowTypeDescriptor)descriptor);
                    descriptor.setTransparentDelay(this.getInteger(context, typeElement, "transparentDelay", 0));
                    descriptor.setTransparentMode(this.getBoolean(context, typeElement, "transparentMode", true));
                    descriptor.setTransparentRatio(this.getFloat(context, typeElement, "transparentRatio", 0.7f));
                }
                if ((typeElement = this.getElement(tool, "floating")) != null) {
                    descriptor = (FloatingTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.FLOATING);
                    this.applyAttributes(context, typeElement, (ToolWindowTypeDescriptor)descriptor);
                    descriptor.setTransparentDelay(this.getInteger(context, typeElement, "transparentDelay", 0));
                    descriptor.setTransparentMode(this.getBoolean(context, typeElement, "transparentMode", true));
                    descriptor.setTransparentRatio(this.getFloat(context, typeElement, "transparentRatio", 0.7f));
                    descriptor.setModal(this.getBoolean(context, typeElement, "modal", false));
                    descriptor.setAddToTaskBar(this.getBoolean(context, typeElement, "addToTaskBar", false));
                    descriptor.setAlwaysOnTop(this.getBoolean(context, typeElement, "alwaysOnTop", true));
                    descriptor.setOsDecorated(this.getBoolean(context, typeElement, "osDecorated", false));
                    descriptor.setResizable(this.getBoolean(context, typeElement, "resizable", true));
                    Element location = this.getElement(typeElement, "location");
                    if (location != null) {
                        descriptor.setLocation(this.getInteger(context, location, "x", 0), this.getInteger(context, location, "y", 0));
                    }
                    if ((dimension = this.getElement(typeElement, "size")) != null) {
                        descriptor.setSize(this.getInteger(context, dimension, "width", 100), this.getInteger(context, dimension, "height", 100));
                    }
                }
                if ((typeElement = this.getElement(tool, "floatingLive")) != null) {
                    descriptor = (FloatingLiveTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE);
                    this.applyAttributes(context, typeElement, (ToolWindowTypeDescriptor)descriptor);
                    descriptor.setTransparentDelay(this.getInteger(context, typeElement, "transparentDelay", 0));
                    descriptor.setTransparentMode(this.getBoolean(context, typeElement, "transparentMode", true));
                    descriptor.setTransparentRatio(this.getFloat(context, typeElement, "transparentRatio", 0.7f));
                    descriptor.setResizable(this.getBoolean(context, typeElement, "resizable", true));
                    Element location = this.getElement(typeElement, "location");
                    if (location != null) {
                        descriptor.setLocation(this.getInteger(context, location, "x", 0), this.getInteger(context, location, "y", 0));
                    }
                    if ((dimension = this.getElement(typeElement, "size")) != null) {
                        descriptor.setSize(this.getInteger(context, dimension, "width", 100), this.getInteger(context, dimension, "height", 100));
                    }
                }
                if ((typeElement = this.getElement(tool, "anchor")) != null) {
                    descriptor = toolWindow.getRepresentativeAnchorDescriptor();
                    descriptor.setPreviewEnabled(this.getBoolean(context, typeElement, "previewEnabled", true));
                    descriptor.setPreviewDelay(this.getInteger(context, typeElement, "previewDelay", 0));
                    descriptor.setPreviewTransparentRatio(this.getFloat(context, typeElement, "previewTransparentRatio", 0.7f));
                    descriptor.setTitle(typeElement.getAttribute("title"));
                    if (toolWindow.getType() != ToolWindowType.FLOATING_FREE) {
                        descriptor.setVisible(this.getBoolean(context, typeElement, "visible", true));
                    }
                    descriptor.removeAllLockingAnchor();
                    Element lockingAnchorsElement = this.getElement(typeElement, "lockingAnchors");
                    if (lockingAnchorsElement != null) {
                        NodeList lockingAnchorList = lockingAnchorsElement.getElementsByTagName("lockingAnchor");
                        int sizej = lockingAnchorList.getLength();
                        for (int j = 0; j < sizej; ++j) {
                            Element lockingAnchorElement = (Element)lockingAnchorList.item(j);
                            descriptor.addLockingAnchor(ToolWindowAnchor.valueOf(lockingAnchorElement.getAttribute("anchor")));
                        }
                    }
                }
                if ((type = ToolWindowType.valueOf(tool.getAttribute("type"))) != ToolWindowType.EXTERN) {
                    toolWindow.setType(type);
                }
                toolWindow.setAvailable(this.getBoolean(context, tool, "available", false));
                int index = this.getInteger(context, tool, "index", -1);
                if (index != -1) {
                    toolWindow.setIndex(index);
                }
                toolWindow.setAggregateMode(this.getBoolean(context, tool, "aggregateMode", false));
                toolWindow.setFlashing(this.getBoolean(context, tool, "flashing", false));
                toolWindow.setLockedOnAnchor(this.getBoolean(context, tool, "lockedOnAnchor", false));
                toolWindow.setHideOnZeroTabs(this.getBoolean(context, tool, "hideOnZeroTabs", false));
                Element tabs = this.getElement(tool, "tabs");
                if (tabs != null) {
                    NodeList tabList = tabs.getElementsByTagName("tab");
                    block4: for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                        if (tab.getDockableDelegator() == null) continue;
                        String dockableId = tab.getDockableDelegator().getId();
                        int sizej = tabList.getLength();
                        for (int j = 0; j < sizej; ++j) {
                            Element tabElement = (Element)tabList.item(j);
                            if (!dockableId.equals(tabElement.getAttribute("dockableId"))) continue;
                            toolWindow.removeToolWindowTab(tab);
                            continue block4;
                        }
                    }
                    Dockable selectedTab = null;
                    Dockable maximizedTab = null;
                    int sizej = tabList.getLength();
                    for (int j = 0; j < sizej; ++j) {
                        Element tabElement = (Element)tabList.item(j);
                        String dockableId = tabElement.getAttribute("dockableId");
                        boolean selected = this.getBoolean(context, tabElement, "selected", false);
                        boolean maximized = this.getBoolean(context, tabElement, "maximized", false);
                        Dockable dockable = context.get(ToolWindowManager.class).lookupDockable(dockableId);
                        if (dockable == null) continue;
                        ToolWindowTab tab = toolWindow.addToolWindowTab(dockable);
                        if (selected) {
                            selectedTab = tab;
                        }
                        if (maximized) {
                            maximizedTab = tab;
                        }
                        tab.setSelected(false);
                        tab.setMaximized(false);
                        tab.setCloseable(this.getBoolean(context, tabElement, "closeable", true));
                        tab.setMinimizable(this.getBoolean(context, tabElement, "minimizable", true));
                        tab.setFlashing(this.getBoolean(context, tabElement, "flashing", false));
                        tab.setMinimized(this.getBoolean(context, tabElement, "minimized", false));
                    }
                    if (maximizedTab != null) {
                        maximizedTab.setMaximized(true);
                    }
                    if (selectedTab == null) continue;
                    selectedTab.setSelected(true);
                    continue;
                }
                for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                    if (tab.getDockableDelegator() == null) continue;
                    toolWindow.removeToolWindowTab(tab);
                }
            }
            this.apply(context, tools, ToolWindowAnchor.LEFT, sharedWindows);
            this.apply(context, tools, ToolWindowAnchor.BOTTOM, sharedWindows);
            this.apply(context, tools, ToolWindowAnchor.RIGHT, sharedWindows);
            this.apply(context, tools, ToolWindowAnchor.TOP, sharedWindows);
            sharedWindows.applyLayouts();
            return false;
        }

        protected void apply(final Context context, NodeList tools, ToolWindowAnchor anchor, SharedWindows sharedWindows) {
            ArrayList<Element> toolsByAnchor = new ArrayList<Element>();
            int size = tools.getLength();
            for (int i = 0; i < size; ++i) {
                Element tool = (Element)tools.item(i);
                if (ToolWindowAnchor.valueOf(tool.getAttribute("anchor")) != anchor) continue;
                toolsByAnchor.add(tool);
            }
            Collections.sort(toolsByAnchor, new Comparator<Element>(){

                @Override
                public int compare(Element o1, Element o2) {
                    int anchorIndex1 = ToolWindowsElementParser.this.getInteger(context, o1, "anchorIndex", 0);
                    int anchorIndex2 = ToolWindowsElementParser.this.getInteger(context, o2, "anchorIndex", 0);
                    ToolWindowType type1 = ToolWindowType.valueOf(o1.getAttribute("type"));
                    ToolWindowType type2 = ToolWindowType.valueOf(o2.getAttribute("type"));
                    if (type1 == ToolWindowType.SLIDING) {
                        return 1;
                    }
                    if (type2 == ToolWindowType.SLIDING) {
                        return -1;
                    }
                    if (anchorIndex1 < anchorIndex2) {
                        return -1;
                    }
                    if (anchorIndex1 == anchorIndex2) {
                        return 0;
                    }
                    return 1;
                }
            });
            ToolWindow activeTool = null;
            Dockable maximizedTool = null;
            for (Element tool : toolsByAnchor) {
                String toolId = tool.getAttribute("id");
                ToolWindow toolWindow = context.get(ToolWindowManager.class).getToolWindow(toolId);
                if (toolWindow == null) {
                    toolWindow = context.get(PersistenceDelegateCallback.class).toolwindowNotFound(context.get(ToolWindowManager.class), toolId, node.setElement(tool));
                }
                if (toolWindow == null) continue;
                int anchorIndex = this.getInteger(context, tool, "anchorIndex", Integer.MIN_VALUE);
                ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
                if (this.isAttributePresent(tool, "anchor")) {
                    toolWindowAnchor = ToolWindowAnchor.valueOf(tool.getAttribute("anchor"));
                }
                if (anchorIndex == Integer.MIN_VALUE) {
                    toolWindow.setAnchor(toolWindowAnchor);
                } else {
                    toolWindow.setAnchor(toolWindowAnchor, anchorIndex);
                }
                this.mergePolicyApplier.applyToolWindow(toolWindow, node.setElement(tool), sharedWindows);
                if (this.getBoolean(context, tool, "active", false)) {
                    activeTool = toolWindow;
                }
                if (!this.getBoolean(context, tool, "maximized", false)) continue;
                maximizedTool = toolWindow;
            }
            if (activeTool != null) {
                ((MutableContext)context).put((Object)ContextKey.ActiveTool, activeTool);
            }
            if (maximizedTool != null) {
                maximizedTool.setMaximized(true);
            }
        }

        protected void applyAttributes(Context context, Element element, ToolWindowTypeDescriptor descriptor) {
            descriptor.setAnimating(this.getBoolean(context, element, "animating", true));
            descriptor.setAutoHide(this.getBoolean(context, element, "autoHide", false));
            descriptor.setEnabled(this.getBoolean(context, element, "enabled", true));
            descriptor.setHideRepresentativeButtonOnVisible(this.getBoolean(context, element, "hideRepresentativeButtonOnVisible", false));
            descriptor.setIdVisibleOnTitleBar(this.getBoolean(context, element, "idVisibleOnTitleBar", true));
            descriptor.setTitleBarButtonsVisible(this.getBoolean(context, element, "titleBarButtonsVisible", true));
            descriptor.setTitleBarVisible(this.getBoolean(context, element, "titleBarVisible", true));
        }
    }

    public class PushAwayModeElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            ToolWindowManagerDescriptor descriptor = context.get(ToolWindowManager.class).getToolWindowManagerDescriptor();
            NodeList modes = element.getElementsByTagName("mode");
            int size = modes.getLength();
            for (int i = 0; i < size; ++i) {
                Element mode = (Element)modes.item(i);
                if (!"MOST_RECENT".equals(this.getAttributeValue(context, mode, "type", null))) continue;
                MostRecentDescriptor mostRecentDescriptor = (MostRecentDescriptor)descriptor.getPushAwayModeDescriptor(PushAwayMode.MOST_RECENT);
                NodeList anchors = element.getElementsByTagName("anchor");
                int sizej = anchors.getLength();
                for (int j = 0; j < sizej; ++j) {
                    Element anchor = (Element)anchors.item(j);
                    mostRecentDescriptor.append(ToolWindowAnchor.valueOf(anchor.getAttribute("type")));
                }
            }
            if (this.isAttributePresent(element, "pushAwayMode")) {
                descriptor.setPushAwayMode(PushAwayMode.valueOf(element.getAttribute("pushAwayMode")));
            }
            return false;
        }
    }

    public class ToolWindowManagerDescriptorElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            ToolWindowManagerDescriptor descriptor = context.get(ToolWindowManager.class).getToolWindowManagerDescriptor();
            descriptor.setNumberingEnabled(this.getBoolean(context, element, "numberingEnabled", true));
            descriptor.setPreviewEnabled(this.getBoolean(context, element, "previewEnabled", true));
            descriptor.setShowUnavailableTools(this.getBoolean(context, element, "showUnavailableTools", false));
            return true;
        }
    }

    public class MyDoggyElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            if (!"1.5.0".equals(element.getAttribute("version"))) {
                throw new IllegalArgumentException("Invalid workspace version. Expected 1.5.0");
            }
            ContentManager contentManager = context.get(ToolWindowManager.class).getContentManager();
            contentManager.setEnabled(this.getBoolean(context, element, "contentManagerEnabled", true));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ElementParserAdapter
    implements ElementParser<Element> {
        protected static XMLPersistenceNode node = new XMLPersistenceNode();

        protected ElementParserAdapter() {
        }

        public Element getElement(Element root, String name) {
            NodeList list = root.getElementsByTagName(name);
            if (list.getLength() == 0) {
                return null;
            }
            return (Element)list.item(0);
        }

        public boolean isAttributePresent(Element element, String name) {
            String attr = element.getAttribute(name);
            return attr != null && !"".equals(attr.trim());
        }

        public String getAttributeValue(Context context, Element element, String name, String defaultValue) {
            try {
                String attr = context.get(PersistenceDelegateCallback.class).validate(node.setElement(element), name, element.getAttribute(name), defaultValue);
                if (attr != null && !"".equals(attr.trim())) {
                    return attr;
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public boolean getBoolean(Context context, Element element, String name, boolean defaultValue) {
            try {
                String attr = context.get(PersistenceDelegateCallback.class).validate(node.setElement(element), name, element.getAttribute(name), defaultValue);
                if (attr != null && !"".equals(attr.trim())) {
                    return Boolean.parseBoolean(attr);
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public int getInteger(Context context, Element element, String name, int defaultValue) {
            try {
                String attr = context.get(PersistenceDelegateCallback.class).validate(node.setElement(element), name, element.getAttribute(name), defaultValue);
                if (attr != null && !"".equals(attr.trim())) {
                    return Integer.parseInt(attr);
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public float getFloat(Context context, Element element, String name, float defaultValue) {
            try {
                String attr = context.get(PersistenceDelegateCallback.class).validate(node.setElement(element), name, element.getAttribute(name), Float.valueOf(defaultValue));
                if (attr != null && !"".equals(attr.trim())) {
                    return Float.parseFloat(attr);
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public ToolWindowAnchor getToolWindowAnchor(Context context, Element element, String name, ToolWindowAnchor defaultValue) {
            try {
                String attr = context.get(PersistenceDelegateCallback.class).validate(node.setElement(element), name, element.getAttribute(name), (Object)defaultValue);
                if (attr != null && !"".equals(attr.trim())) {
                    return ToolWindowAnchor.valueOf(attr);
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MasterElementParser
    implements ElementParser<Element> {
        protected Map<String, ElementParser<Element>> elementParserMap = new Hashtable<String, ElementParser<Element>>();

        public MasterElementParser() {
            this.populateParserMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean parse(Element element, Context context) {
            try {
                context.get(MyDoggyToolWindowManager.class).putClientProperty("PERSISTENCE_DELEGATE_PARSING", this);
                boolean result = this.parseTree(element, context);
                final ToolWindow activeTool = (ToolWindow)context.get((Object)ContextKey.ActiveTool);
                if (activeTool != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            activeTool.setActive(true);
                        }
                    });
                }
                boolean bl = result;
                return bl;
            }
            finally {
                context.get(MyDoggyToolWindowManager.class).putClientProperty("PERSISTENCE_DELEGATE_PARSING", null);
            }
        }

        public boolean parseTree(Element element, Context context) {
            ElementParser<Element> elementParser = this.elementParserMap.get(element.getNodeName());
            if (elementParser == null || elementParser.parse(element, context)) {
                NodeList children = element.getChildNodes();
                int size = children.getLength();
                for (int i = 0; i < size; ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    this.parse((Element)node, context);
                }
            }
            return false;
        }

        protected void populateParserMap() {
            this.elementParserMap.put("mydoggy", new MyDoggyElementParser());
            this.elementParserMap.put("toolWindowManagerDescriptor", new ToolWindowManagerDescriptorElementParser());
            this.elementParserMap.put("pushAway", new PushAwayModeElementParser());
            this.elementParserMap.put("toolWindows", new ToolWindowsElementParser());
            this.elementParserMap.put("contentManager", new ContentManagerElementParser());
            this.elementParserMap.put("toolWindowBar", new ToolWindowBarElementParser());
            this.elementParserMap.put("MultiSplitContentManagerUI", new MultiSplitContentManagerUIElementParser());
            this.elementParserMap.put("TabbedContentManagerUI", new TabbedContentManagerUIElementParser());
            this.elementParserMap.put("DesktopContentManagerUI", new DekstopManagerUIElementParser());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ToolWindowAnchorEntityWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                ToolWindowManager toolWindowManager = context.get(ToolWindowManager.class);
                writer.startElement("toolWindowBars");
                this.saveBar(writer, (MyDoggyToolWindowBar)toolWindowManager.getToolWindowBar(ToolWindowAnchor.LEFT), context);
                this.saveBar(writer, (MyDoggyToolWindowBar)toolWindowManager.getToolWindowBar(ToolWindowAnchor.BOTTOM), context);
                this.saveBar(writer, (MyDoggyToolWindowBar)toolWindowManager.getToolWindowBar(ToolWindowAnchor.RIGHT), context);
                this.saveBar(writer, (MyDoggyToolWindowBar)toolWindowManager.getToolWindowBar(ToolWindowAnchor.TOP), context);
                writer.endElement("toolWindowBars");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        protected void saveBar(XMLWriter writer, MyDoggyToolWindowBar toolWindowBar, Context context) throws SAXException {
            if (context.get(PersistenceDelegateFilter.class).storeToolWindowBar(toolWindowBar)) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(null, "anchor", null, null, toolWindowBar.getAnchor().toString());
                attributes.addAttribute(null, "dividerSize", null, null, String.valueOf(toolWindowBar.getDividerSize()));
                attributes.addAttribute(null, "aggregateMode", null, null, String.valueOf(toolWindowBar.isAggregateMode()));
                attributes.addAttribute(null, "length", null, null, String.valueOf(toolWindowBar.getLength()));
                attributes.addAttribute(null, "visible", null, null, String.valueOf(toolWindowBar.isVisible()));
                attributes.addAttribute(null, "toolsVisible", null, null, String.valueOf(toolWindowBar.areToolsVisible()));
                writer.startElement("toolWindowBar", attributes);
                if (toolWindowBar.getToolWindows().length > 0) {
                    writer.startElement("layout");
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    XMLEncoder encoder = new XMLEncoder(os);
                    encoder.writeObject(toolWindowBar.getLayout());
                    encoder.flush();
                    encoder.close();
                    String model = os.toString();
                    writer.cdata(model.substring(model.indexOf(10)));
                    writer.endElement("layout");
                }
                if (toolWindowBar.getToolsWorkspace() != null) {
                    writer.startElement("workspace");
                    writer.cdata(Base64.encodeBytes(toolWindowBar.getToolsWorkspace()));
                    writer.endElement("workspace");
                }
                writer.endElement("toolWindowBar");
            }
        }
    }

    public class DesktopContentManagerUIEntityWriter
    extends ContentManagerUIEntityWriter {
        public void write(XMLWriter writer, Context context) {
            try {
                DesktopContentManagerUI desktopContentManagerUI = (DesktopContentManagerUI)context.get(ContentManagerUI.class);
                AttributesImpl attributes = new AttributesImpl();
                this.addContentManagerUIAttributes(attributes, desktopContentManagerUI);
                writer.startElement("DesktopContentManagerUI", attributes);
                writer.startElement("contents");
                for (Content content : context.get(ContentManager.class).getContents()) {
                    DesktopContentUI contentUI = (DesktopContentUI)content.getContentUI();
                    AttributesImpl contentUIAttributes = new AttributesImpl();
                    contentUIAttributes.addAttribute(null, "id", null, null, content.getId());
                    contentUIAttributes.addAttribute(null, "x", null, null, String.valueOf(contentUI.getLocation().x));
                    contentUIAttributes.addAttribute(null, "y", null, null, String.valueOf(contentUI.getLocation().y));
                    contentUIAttributes.addAttribute(null, "width", null, null, String.valueOf(contentUI.getSize().width));
                    contentUIAttributes.addAttribute(null, "height", null, null, String.valueOf(contentUI.getSize().height));
                    contentUIAttributes.addAttribute(null, "iconified", null, null, String.valueOf(contentUI.isIconified()));
                    writer.dataElement("content", contentUIAttributes);
                }
                writer.endElement("contents");
                writer.endElement("DesktopContentManagerUI");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class MultiSplitContentManagerUIEntityWriter
    extends ContentManagerUIEntityWriter {
        public void write(XMLWriter writer, Context context) {
            try {
                MultiSplitContentManagerUI multiSplitContentManagerUI = (MultiSplitContentManagerUI)context.get(ContentManagerUI.class);
                AttributesImpl attributes = new AttributesImpl();
                this.addContentManagerUIAttributes(attributes, multiSplitContentManagerUI);
                attributes.addAttribute(null, "showAlwaysTab", null, null, String.valueOf(multiSplitContentManagerUI.isShowAlwaysTab()));
                attributes.addAttribute(null, "tabLayout", null, null, multiSplitContentManagerUI.getTabLayout().toString());
                attributes.addAttribute(null, "tabPlacement", null, null, multiSplitContentManagerUI.getTabPlacement().toString());
                writer.startElement("MultiSplitContentManagerUI", attributes);
                writer.startElement("contents");
                for (Content content : context.get(ContentManager.class).getContents()) {
                    MultiSplitContentUI contentUI = (MultiSplitContentUI)content.getContentUI();
                    AttributesImpl contentUIAttributes = new AttributesImpl();
                    contentUIAttributes.addAttribute(null, "id", null, null, content.getId());
                    contentUIAttributes.addAttribute(null, "showAlwaysTab", null, null, String.valueOf(contentUI.isShowAlwaysTab()));
                    writer.dataElement("content", contentUIAttributes);
                }
                writer.endElement("contents");
                writer.startElement("layout");
                MyDoggyMultiSplitContentManagerUI splitContentManagerUI = (MyDoggyMultiSplitContentManagerUI)multiSplitContentManagerUI;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLEncoder encoder = new XMLEncoder(os);
                encoder.writeObject(splitContentManagerUI.getLayout());
                encoder.flush();
                encoder.close();
                String model = os.toString();
                writer.cdata(model.substring(model.indexOf(10)));
                writer.endElement("layout");
                writer.endElement("MultiSplitContentManagerUI");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class TabbedContentManagerUIEntityWriter
    extends ContentManagerUIEntityWriter {
        public void write(XMLWriter writer, Context context) {
            try {
                TabbedContentManagerUI tabbedContentManagerUI = (TabbedContentManagerUI)context.get(ContentManagerUI.class);
                AttributesImpl attributes = new AttributesImpl();
                this.addContentManagerUIAttributes(attributes, tabbedContentManagerUI);
                attributes.addAttribute(null, "showAlwaysTab", null, null, String.valueOf(tabbedContentManagerUI.isShowAlwaysTab()));
                attributes.addAttribute(null, "tabLayout", null, null, tabbedContentManagerUI.getTabLayout().toString());
                attributes.addAttribute(null, "tabPlacement", null, null, tabbedContentManagerUI.getTabPlacement().toString());
                writer.dataElement("TabbedContentManagerUI", attributes);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ContentManagerUIEntityWriter
    implements ElementWriter<XMLWriter> {
        protected void addContentManagerUIAttributes(AttributesImpl attributes, ContentManagerUI contentManagerUI) {
            attributes.addAttribute(null, "closeable", null, null, String.valueOf(contentManagerUI.isCloseable()));
            attributes.addAttribute(null, "detachable", null, null, String.valueOf(contentManagerUI.isDetachable()));
            attributes.addAttribute(null, "minimizable", null, null, String.valueOf(contentManagerUI.isMinimizable()));
            attributes.addAttribute(null, "maximizable", null, null, String.valueOf(contentManagerUI.isMaximizable()));
            attributes.addAttribute(null, "popupMenuEnabled", null, null, String.valueOf(contentManagerUI.isPopupMenuEnabled()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContentManagerEntityWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                MyDoggyToolWindowManager toolWindowManager = (MyDoggyToolWindowManager)context.get(ToolWindowManager.class);
                ContentManager contentManager = context.get(ContentManager.class);
                writer.startElement("contentManager");
                writer.startElement("sharedWindows");
                for (ContentWindow multiSplitWindow : SwingUtil.getContentWindows()) {
                    XMLPersistenceDelegate.this.storeMultiSplitWindow(writer, multiSplitWindow);
                }
                writer.endElement("sharedWindows");
                writer.startElement("contents");
                for (Content content : contentManager.getContents()) {
                    ContentUI contentUI = content.getContentUI();
                    AttributesImpl contentAttributes = new AttributesImpl();
                    contentAttributes.addAttribute(null, "id", null, null, content.getId());
                    contentAttributes.addAttribute(null, "detached", null, null, String.valueOf(content.isDetached()));
                    contentAttributes.addAttribute(null, "enabled", null, null, String.valueOf(content.isEnabled()));
                    contentAttributes.addAttribute(null, "selected", null, null, context.get(InternalPersistenceDelegateFilter.class).saveSelectedContent() ? String.valueOf(content.isSelected()) : "false");
                    contentAttributes.addAttribute(null, "maximized", null, null, String.valueOf(content.isMaximized()));
                    contentAttributes.addAttribute(null, "minimized", null, null, String.valueOf(content.isMinimized()));
                    contentAttributes.addAttribute(null, "flashing", null, null, String.valueOf(content.isFlashing()));
                    contentAttributes.addAttribute(null, "closeable", null, null, String.valueOf(contentUI.isCloseable()));
                    contentAttributes.addAttribute(null, "detachable", null, null, String.valueOf(contentUI.isDetachable()));
                    contentAttributes.addAttribute(null, "minimizable", null, null, String.valueOf(contentUI.isMinimizable()));
                    contentAttributes.addAttribute(null, "maximizable", null, null, String.valueOf(contentUI.isMaximizable()));
                    contentAttributes.addAttribute(null, "transparentMode", null, null, String.valueOf(contentUI.isTransparentMode()));
                    contentAttributes.addAttribute(null, "transparentDelay", null, null, String.valueOf(contentUI.getTransparentDelay()));
                    contentAttributes.addAttribute(null, "transparentRatio", null, null, String.valueOf(contentUI.getTransparentRatio()));
                    contentAttributes.addAttribute(null, "addToTaskBarWhenDetached", null, null, String.valueOf(contentUI.isAddToTaskBarWhenDetached()));
                    contentAttributes.addAttribute(null, "alwaysOnTop", null, null, String.valueOf(contentUI.isAlwaysOnTop()));
                    writer.startElement("content", contentAttributes);
                    Rectangle detachedBounds = contentUI.getDetachedBounds();
                    if (detachedBounds != null) {
                        AttributesImpl attributes = new AttributesImpl();
                        attributes.addAttribute(null, "x", null, null, String.valueOf(detachedBounds.x));
                        attributes.addAttribute(null, "y", null, null, String.valueOf(detachedBounds.y));
                        attributes.addAttribute(null, "width", null, null, String.valueOf(detachedBounds.width));
                        attributes.addAttribute(null, "height", null, null, String.valueOf(detachedBounds.height));
                        writer.dataElement("detachedBounds", attributes);
                    }
                    if (content.isMinimized()) {
                        ContentDescriptor contentDescriptor = (ContentDescriptor)toolWindowManager.getDockableDescriptor(content.getId());
                        AttributesImpl attributes = new AttributesImpl();
                        attributes.addAttribute(null, "anchor", null, null, contentDescriptor.getAnchor().toString());
                        attributes.addAttribute(null, "anchorIndex", null, null, String.valueOf(contentDescriptor.getAnchorIndex()));
                        writer.dataElement("minimizedState", attributes);
                    }
                    writer.endElement("content");
                }
                writer.endElement("contents");
                if (!contentManager.isEnabled()) {
                    MultiSplitDockableContainer dockableContainer = (MultiSplitDockableContainer)((DockableDropPanel)toolWindowManager.getMainContent()).getComponent();
                    writer.startElement("layout");
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    XMLEncoder encoder = new XMLEncoder(os);
                    encoder.writeObject(dockableContainer.getMultiSplitLayout());
                    encoder.flush();
                    encoder.close();
                    String model = os.toString();
                    writer.cdata(model.substring(model.indexOf(10)));
                    writer.endElement("layout");
                }
                writer.endElement("contentManager");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ToolWindowManagerDescriptorEntityWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                ToolWindowManagerDescriptor descriptor = context.get(ToolWindowManagerDescriptor.class);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(null, "numberingEnabled", null, null, String.valueOf(descriptor.isNumberingEnabled()));
                attributes.addAttribute(null, "previewEnabled", null, null, String.valueOf(descriptor.isPreviewEnabled()));
                attributes.addAttribute(null, "showUnavailableTools", null, null, String.valueOf(descriptor.isShowUnavailableTools()));
                writer.startElement("toolWindowManagerDescriptor", attributes);
                attributes = new AttributesImpl();
                attributes.addAttribute(null, "pushAwayMode", null, null, descriptor.getPushAwayMode().toString());
                writer.startElement("pushAway", attributes);
                attributes = new AttributesImpl();
                attributes.addAttribute(null, "type", null, null, String.valueOf((Object)PushAwayMode.MOST_RECENT));
                writer.startElement("mode", attributes);
                MostRecentDescriptor mostRecentDescriptor = (MostRecentDescriptor)descriptor.getPushAwayModeDescriptor(PushAwayMode.MOST_RECENT);
                for (ToolWindowAnchor toolWindowAnchor : mostRecentDescriptor.getMostRecentAnchors()) {
                    AttributesImpl anchorAttributes = new AttributesImpl();
                    anchorAttributes.addAttribute(null, "type", null, null, String.valueOf((Object)toolWindowAnchor));
                    writer.dataElement("anchor", anchorAttributes);
                }
                writer.endElement("mode");
                writer.endElement("pushAway");
                writer.endElement("toolWindowManagerDescriptor");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ToolWindowEntityWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                ToolWindow toolWindow = context.get(ToolWindow.class);
                AttributesImpl toolAttributes = new AttributesImpl();
                toolAttributes.addAttribute(null, "id", null, null, String.valueOf(toolWindow.getId()));
                toolAttributes.addAttribute(null, "available", null, null, String.valueOf(toolWindow.isAvailable()));
                toolAttributes.addAttribute(null, "visible", null, null, String.valueOf(toolWindow.isVisible()));
                toolAttributes.addAttribute(null, "active", null, null, String.valueOf(toolWindow.isActive()));
                toolAttributes.addAttribute(null, "autoHide", null, null, String.valueOf(toolWindow.isAutoHide()));
                toolAttributes.addAttribute(null, "anchor", null, null, String.valueOf((Object)toolWindow.getAnchor()));
                toolAttributes.addAttribute(null, "anchorIndex", null, null, String.valueOf(toolWindow.getAnchorIndex()));
                toolAttributes.addAttribute(null, "type", null, null, String.valueOf((Object)toolWindow.getType()));
                toolAttributes.addAttribute(null, "aggregateMode", null, null, String.valueOf(toolWindow.isAggregateMode()));
                toolAttributes.addAttribute(null, "maximized", null, null, String.valueOf(toolWindow.isMaximized()));
                toolAttributes.addAttribute(null, "index", null, null, String.valueOf(toolWindow.getIndex()));
                toolAttributes.addAttribute(null, "flashing", null, null, String.valueOf(toolWindow.isFlashing()));
                toolAttributes.addAttribute(null, "lockedOnAnchor", null, null, String.valueOf(toolWindow.isLockedOnAnchor()));
                toolAttributes.addAttribute(null, "hideOnZeroTabs", null, null, String.valueOf(toolWindow.isHideOnZeroTabs()));
                writer.startElement("toolWindow", toolAttributes);
                writer.startElement("descriptors");
                DockedTypeDescriptor dockedTypeDescriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
                AttributesImpl dockedDescriptorAttributes = new AttributesImpl();
                this.addAttributes(dockedDescriptorAttributes, dockedTypeDescriptor);
                dockedDescriptorAttributes.addAttribute(null, "dockLength", null, null, String.valueOf(dockedTypeDescriptor.getDockLength()));
                dockedDescriptorAttributes.addAttribute(null, "minimumDockLength", null, null, String.valueOf(dockedTypeDescriptor.getMinimumDockLength()));
                dockedDescriptorAttributes.addAttribute(null, "popupMenuEnabled", null, null, String.valueOf(dockedTypeDescriptor.isPopupMenuEnabled()));
                writer.dataElement("docked", dockedDescriptorAttributes);
                SlidingTypeDescriptor slidingTypeDescriptor = (SlidingTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.SLIDING);
                AttributesImpl slidingDescriptorAttributes = new AttributesImpl();
                this.addAttributes(slidingDescriptorAttributes, slidingTypeDescriptor);
                slidingDescriptorAttributes.addAttribute(null, "transparentMode", null, null, String.valueOf(slidingTypeDescriptor.isTransparentMode()));
                slidingDescriptorAttributes.addAttribute(null, "transparentDelay", null, null, String.valueOf(slidingTypeDescriptor.getTransparentDelay()));
                slidingDescriptorAttributes.addAttribute(null, "transparentRatio", null, null, String.valueOf(slidingTypeDescriptor.getTransparentRatio()));
                writer.dataElement("sliding", slidingDescriptorAttributes);
                FloatingTypeDescriptor floatingTypeDescriptor = (FloatingTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.FLOATING);
                AttributesImpl floatingDescriptorAttributes = new AttributesImpl();
                this.addAttributes(floatingDescriptorAttributes, floatingTypeDescriptor);
                floatingDescriptorAttributes.addAttribute(null, "modal", null, null, String.valueOf(floatingTypeDescriptor.isModal()));
                floatingDescriptorAttributes.addAttribute(null, "transparentMode", null, null, String.valueOf(floatingTypeDescriptor.isTransparentMode()));
                floatingDescriptorAttributes.addAttribute(null, "transparentDelay", null, null, String.valueOf(floatingTypeDescriptor.getTransparentDelay()));
                floatingDescriptorAttributes.addAttribute(null, "transparentRatio", null, null, String.valueOf(floatingTypeDescriptor.getTransparentRatio()));
                floatingDescriptorAttributes.addAttribute(null, "addToTaskBar", null, null, String.valueOf(floatingTypeDescriptor.isAddToTaskBar()));
                floatingDescriptorAttributes.addAttribute(null, "alwaysOnTop", null, null, String.valueOf(floatingTypeDescriptor.isAlwaysOnTop()));
                floatingDescriptorAttributes.addAttribute(null, "osDecorated", null, null, String.valueOf(floatingTypeDescriptor.isOsDecorated()));
                floatingDescriptorAttributes.addAttribute(null, "resizable", null, null, String.valueOf(floatingTypeDescriptor.isResizable()));
                Point point = floatingTypeDescriptor.getLocation();
                Dimension dimension = floatingTypeDescriptor.getSize();
                if (point != null || dimension != null) {
                    AttributesImpl attributes;
                    writer.startElement("floating", floatingDescriptorAttributes);
                    if (point != null) {
                        attributes = new AttributesImpl();
                        attributes.addAttribute(null, "x", null, null, String.valueOf(point.x));
                        attributes.addAttribute(null, "y", null, null, String.valueOf(point.y));
                        writer.dataElement("location", attributes);
                    }
                    if (dimension != null) {
                        attributes = new AttributesImpl();
                        attributes.addAttribute(null, "width", null, null, String.valueOf(dimension.width));
                        attributes.addAttribute(null, "height", null, null, String.valueOf(dimension.height));
                        writer.dataElement("size", attributes);
                    }
                    writer.endElement("floating");
                } else {
                    writer.dataElement("floating", floatingDescriptorAttributes);
                }
                if (toolWindow.isMaximized() && (toolWindow.getType() == ToolWindowType.FLOATING || toolWindow.getType() == ToolWindowType.FLOATING_FREE)) {
                    Rectangle screenWindowBounds = context.get(MyDoggyToolWindowManager.class).getDescriptor(toolWindow).getScreenWindowBounds();
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute(null, "x", null, null, String.valueOf(screenWindowBounds.x));
                    attributes.addAttribute(null, "y", null, null, String.valueOf(screenWindowBounds.y));
                    attributes.addAttribute(null, "width", null, null, String.valueOf(screenWindowBounds.width));
                    attributes.addAttribute(null, "height", null, null, String.valueOf(screenWindowBounds.height));
                    writer.dataElement("screenWindowBounds", attributes);
                }
                FloatingLiveTypeDescriptor floatingLiveTypeDescriptor = (FloatingLiveTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE);
                AttributesImpl floatingLiveDescriptorAttributes = new AttributesImpl();
                this.addAttributes(floatingLiveDescriptorAttributes, floatingLiveTypeDescriptor);
                floatingLiveDescriptorAttributes.addAttribute(null, "transparentMode", null, null, String.valueOf(floatingLiveTypeDescriptor.isTransparentMode()));
                floatingLiveDescriptorAttributes.addAttribute(null, "transparentDelay", null, null, String.valueOf(floatingLiveTypeDescriptor.getTransparentDelay()));
                floatingLiveDescriptorAttributes.addAttribute(null, "transparentRatio", null, null, String.valueOf(floatingLiveTypeDescriptor.getTransparentRatio()));
                floatingLiveDescriptorAttributes.addAttribute(null, "resizable", null, null, String.valueOf(floatingLiveTypeDescriptor.isResizable()));
                point = floatingLiveTypeDescriptor.getLocation();
                dimension = floatingLiveTypeDescriptor.getSize();
                if (point != null || dimension != null) {
                    AttributesImpl attributes;
                    writer.startElement("floatingLive", floatingDescriptorAttributes);
                    if (point != null) {
                        attributes = new AttributesImpl();
                        attributes.addAttribute(null, "x", null, null, String.valueOf(point.x));
                        attributes.addAttribute(null, "y", null, null, String.valueOf(point.y));
                        writer.dataElement("location", attributes);
                    }
                    if (dimension != null) {
                        attributes = new AttributesImpl();
                        attributes.addAttribute(null, "width", null, null, String.valueOf(dimension.width));
                        attributes.addAttribute(null, "height", null, null, String.valueOf(dimension.height));
                        writer.dataElement("size", attributes);
                    }
                    writer.endElement("floatingLive");
                } else {
                    writer.dataElement("floatingLive", floatingLiveDescriptorAttributes);
                }
                RepresentativeAnchorDescriptor<ToolWindow> anchorDescriptor = toolWindow.getRepresentativeAnchorDescriptor();
                AttributesImpl anchorDescriptorAttributes = new AttributesImpl();
                anchorDescriptorAttributes.addAttribute(null, "visible", null, null, String.valueOf(toolWindow.getRepresentativeAnchorDescriptor().isVisible()));
                anchorDescriptorAttributes.addAttribute(null, "title", null, null, toolWindow.getRepresentativeAnchorDescriptor().getTitle());
                anchorDescriptorAttributes.addAttribute(null, "previewEnabled", null, null, String.valueOf(anchorDescriptor.isPreviewEnabled()));
                anchorDescriptorAttributes.addAttribute(null, "previewDelay", null, null, String.valueOf(anchorDescriptor.getPreviewDelay()));
                anchorDescriptorAttributes.addAttribute(null, "previewTransparentRatio", null, null, String.valueOf(anchorDescriptor.getPreviewTransparentRatio()));
                writer.startElement("anchor", anchorDescriptorAttributes);
                writer.startElement("lockingAnchors");
                for (ToolWindowAnchor anchor : anchorDescriptor.getLockingAnchors()) {
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute(null, "anchor", null, null, anchor.toString());
                    writer.dataElement("lockingAnchor", attributes);
                }
                writer.endElement("lockingAnchors");
                writer.endElement("anchor");
                writer.endElement("descriptors");
                boolean addTabsTag = false;
                for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                    if (tab.getDockableDelegator() == null) continue;
                    Dockable dockable = tab.getDockableDelegator();
                    if (!addTabsTag) {
                        addTabsTag = true;
                        writer.startElement("tabs");
                    }
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute(null, "dockableId", null, null, dockable.getId());
                    attributes.addAttribute(null, "selected", null, null, String.valueOf(tab.isSelected()));
                    attributes.addAttribute(null, "maximized", null, null, String.valueOf(tab.isMaximized()));
                    attributes.addAttribute(null, "minimized", null, null, String.valueOf(tab.isMinimized()));
                    attributes.addAttribute(null, "closeable", null, null, String.valueOf(tab.isCloseable()));
                    attributes.addAttribute(null, "minimizable", null, null, String.valueOf(tab.isMinimizable()));
                    attributes.addAttribute(null, "detached", null, null, String.valueOf(tab.isDetached()));
                    attributes.addAttribute(null, "flashing", null, null, String.valueOf(tab.isFlashing()));
                    writer.dataElement("tab", attributes);
                }
                if (addTabsTag) {
                    writer.endElement("tabs");
                }
                writer.endElement("toolWindow");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        protected void addAttributes(AttributesImpl attributes, ToolWindowTypeDescriptor descriptor) {
            attributes.addAttribute(null, "animating", null, null, String.valueOf(descriptor.isAnimating()));
            attributes.addAttribute(null, "autoHide", null, null, String.valueOf(descriptor.isAutoHide()));
            attributes.addAttribute(null, "enabled", null, null, String.valueOf(descriptor.isEnabled()));
            attributes.addAttribute(null, "hideRepresentativeButtonOnVisible", null, null, String.valueOf(descriptor.isHideRepresentativeButtonOnVisible()));
            attributes.addAttribute(null, "idVisibleOnTitleBar", null, null, String.valueOf(descriptor.isIdVisibleOnTitleBar()));
            attributes.addAttribute(null, "titleBarButtonsVisible", null, null, String.valueOf(descriptor.isTitleBarButtonsVisible()));
            attributes.addAttribute(null, "titleBarVisible", null, null, String.valueOf(descriptor.isTitleBarVisible()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ToolWindowManagerElementWriter
    implements ElementWriter<XMLWriter> {
        protected ToolWindowManager manager;
        protected Map<Class, ElementWriter<XMLWriter>> elementWriterMap;

        public ToolWindowManagerElementWriter(ToolWindowManager manager) {
            this.manager = manager;
            this.elementWriterMap = new HashMap<Class, ElementWriter<XMLWriter>>();
            this.populateWriterMap();
        }

        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                MutableContext mutableContext = (MutableContext)context;
                mutableContext.put(ToolWindowManager.class, this.manager);
                boolean standalone = (Boolean)context.get("standalone");
                if (standalone) {
                    writer.startDocument();
                }
                AttributesImpl mydoggyAttributes = new AttributesImpl();
                mydoggyAttributes.addAttribute(null, "version", null, null, "1.5.0");
                mydoggyAttributes.addAttribute(null, "contentManagerEnabled", null, null, String.valueOf(this.manager.getContentManager().isEnabled()));
                writer.startElement("mydoggy", mydoggyAttributes);
                writer.startElement("toolWindows");
                writer.startElement("sharedWindows");
                for (FloatingWindow floatingWindow : XMLPersistenceDelegate.this.toolWindowManager.getFloatingWindows()) {
                    XMLPersistenceDelegate.this.storeMultiSplitWindow(writer, floatingWindow);
                }
                for (FloatingLiveWindow floatingLiveWindow : XMLPersistenceDelegate.this.toolWindowManager.getFloatingLiveWindows()) {
                    XMLPersistenceDelegate.this.storeMultiSplitWindow(writer, floatingLiveWindow);
                }
                writer.endElement("sharedWindows");
                for (ToolWindow toolWindow : this.manager.getToolWindows()) {
                    if (!context.get(PersistenceDelegateFilter.class).storeToolWindow(toolWindow)) continue;
                    mutableContext.put(ToolWindow.class, toolWindow);
                    this.getElementWriter(ToolWindow.class).write(writer, context);
                }
                writer.endElement("toolWindows");
                if (context.get(PersistenceDelegateFilter.class).storeToolWindowManagerDescriptor()) {
                    mutableContext.put(ToolWindowManagerDescriptor.class, this.manager.getToolWindowManagerDescriptor());
                    this.getElementWriter(ToolWindowManagerDescriptor.class).write(writer, context);
                }
                if (context.get(PersistenceDelegateFilter.class).storeContentManager()) {
                    mutableContext.put(ContentManager.class, this.manager.getContentManager());
                    mutableContext.put(ContentManagerUI.class, this.manager.getContentManager().getContentManagerUI());
                    ContentManager contentManager = this.manager.getContentManager();
                    writer.startElement("contentManagerUI");
                    this.getElementWriter(contentManager.getContentManagerUI().getClass()).write(writer, context);
                    writer.endElement("contentManagerUI");
                    this.getElementWriter(ContentManager.class).write(writer, context);
                }
                this.getElementWriter(ToolWindowAnchor.class).write(writer, context);
                writer.endElement("mydoggy");
                if (standalone) {
                    writer.endDocument();
                }
                writer.flush();
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected ElementWriter<XMLWriter> getElementWriter(Class clazz) {
            ElementWriter<XMLWriter> elementWriter = this.elementWriterMap.get(clazz);
            if (elementWriter == null) {
                while (clazz != null) {
                    elementWriter = this.elementWriterMap.get(clazz.getSuperclass());
                    if (elementWriter != null) {
                        return elementWriter;
                    }
                    for (Class<?> interfaceClazz : clazz.getInterfaces()) {
                        elementWriter = this.elementWriterMap.get(interfaceClazz);
                        if (elementWriter == null) continue;
                        return elementWriter;
                    }
                    clazz = clazz.getSuperclass();
                }
            }
            return elementWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateWriterMap() {
            ClassLoader bundleClassLoader = this.getClass().getClassLoader();
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            try {
                this.elementWriterMap.put(ToolWindow.class, new ToolWindowEntityWriter());
                this.elementWriterMap.put(ToolWindowManagerDescriptor.class, new ToolWindowManagerDescriptorEntityWriter());
                this.elementWriterMap.put(ContentManager.class, new ContentManagerEntityWriter());
                this.elementWriterMap.put(TabbedContentManagerUI.class, new TabbedContentManagerUIEntityWriter());
                this.elementWriterMap.put(MultiSplitContentManagerUI.class, new MultiSplitContentManagerUIEntityWriter());
                this.elementWriterMap.put(DesktopContentManagerUI.class, new DesktopContentManagerUIEntityWriter());
                this.elementWriterMap.put(ToolWindowAnchor.class, new ToolWindowAnchorEntityWriter());
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ContextKey {
        ActiveTool,
        MultiSplitContentManagerUILayout;

    }
}

